/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog;

import com.complexible.common.timer.DurationFormat;
import com.complexible.stardog.QueryInfo;
import com.google.common.base.Objects;

public abstract class AbstractQueryInfo
implements QueryInfo {
    @Override
    public long getExecutionTime() {
        return this.isStarted() ? (this.isEnded() ? this.getEndTime() : System.currentTimeMillis()) - this.getStartTime() : -1L;
    }

    public int hashCode() {
        return this.getID().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryInfo)) {
            return false;
        }
        QueryInfo that = (QueryInfo)obj;
        return Objects.equal((Object)this.getKernelID(), (Object)that.getKernelID()) && Objects.equal((Object)this.getID(), (Object)that.getID()) && Objects.equal((Object)this.getUser(), (Object)that.getUser()) && Objects.equal((Object)this.getDBName(), (Object)that.getDBName()) && Objects.equal((Object)this.getQuery(), (Object)that.getQuery()) && this.isReasoningEnabled() == that.isReasoningEnabled();
    }

    public String toString() {
        return String.format("Query(%s, %s, DB=%s, User=%s, Reasoning=%s, Started=%6$tF %6$tr, Elapsed=%7$s, Timeout=%8$s):%n%9$s", this.getKernelID(), this.getID(), this.getDBName(), this.getUser(), this.isReasoningEnabled(), this.getStartTime(), DurationFormat.LONG.format(this.getExecutionTime()), DurationFormat.LONG.format(this.getTimeout()), this.getQuery());
    }

    @Override
    public abstract QueryInfo.Status getStatus();

    @Override
    public boolean isManaged() {
        return true;
    }
}

