/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog;

import com.complexible.common.base.Progress;
import com.complexible.common.timer.DurationFormat;
import com.complexible.stardog.process.ProcessInfo;
import com.complexible.stardog.process.ProcessType;
import com.google.common.base.Objects;
import java.util.Optional;

public abstract class AbstractProcessInfo
implements ProcessInfo {
    protected final ProcessType mType;
    private final String mKernelID;
    protected final String mProcessId;
    protected final String mDB;
    protected final String mUser;
    protected final long mStartTime;
    protected final boolean mManaged;
    protected ProcessInfo.Status mStatus = ProcessInfo.Status.NOT_STARTED;

    public AbstractProcessInfo(ProcessType type, String theKernelID, String theExternalID, String theDB, String theUser, long theStartTime, boolean theManaged) {
        this.mType = type;
        this.mKernelID = theKernelID;
        this.mProcessId = theExternalID;
        this.mDB = theDB;
        this.mUser = theUser;
        this.mStartTime = theStartTime;
        this.mManaged = theManaged;
    }

    @Override
    public String getKernelID() {
        return this.mKernelID;
    }

    @Override
    public String getID() {
        return this.mProcessId;
    }

    @Override
    public String getDBName() {
        return this.mDB;
    }

    @Override
    public String getUser() {
        return this.mUser;
    }

    @Override
    public ProcessInfo.Status getProcessStatus() {
        return this.mStatus;
    }

    @Override
    public ProcessType getType() {
        return this.mType;
    }

    @Override
    public long getStartTime() {
        return this.mStartTime;
    }

    @Override
    public Optional<Progress> progress() {
        return Optional.empty();
    }

    @Override
    public long getExecutionTime() {
        return System.currentTimeMillis() - this.getStartTime();
    }

    public int hashCode() {
        return this.getID().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProcessInfo)) {
            return false;
        }
        ProcessInfo that = (ProcessInfo)obj;
        return Objects.equal((Object)this.getID(), (Object)that.getID()) && Objects.equal((Object)this.getUser(), (Object)that.getUser()) && Objects.equal((Object)this.getDBName(), (Object)that.getDBName()) && Objects.equal((Object)((Object)this.getType()), (Object)((Object)that.getType()));
    }

    public String toString() {
        return String.format("Process(%s, %s, %s, Kernel=%s, DB=%s, User=%s, Started=%7$tF %7$tr, Elapsed=%8$s)", new Object[]{this.getType(), this.getID(), this.mStatus.toString(), this.getKernelID(), this.getDBName(), this.getUser(), this.getStartTime(), DurationFormat.LONG.format(this.getExecutionTime())});
    }

    @Override
    public boolean isManaged() {
        return this.mManaged;
    }
}

