/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.mvcc.impl.oracle;

import com.complexible.mvcc.api.oracle.TransactionOracle;
import com.complexible.mvcc.api.oracle.TransactionStateListener;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class TxnStateListenerSet {
    public static final Logger LOGGER = LoggerFactory.getLogger(TxnStateListenerSet.class);
    private final Map<Long, Collection<TransactionStateListener>> listenerMap = new ConcurrentHashMap<Long, Collection<TransactionStateListener>>();
    private final ExecutorService mExecutorService;
    private final TransactionOracle mTxnOracle;
    private final AtomicBoolean disposed = new AtomicBoolean(false);

    TxnStateListenerSet(TransactionOracle theTxnOracle, boolean startThreads) {
        this.mTxnOracle = theTxnOracle;
        if (startThreads) {
            ThreadFactory threadFactory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("TransactionOracle-%d").setUncaughtExceptionHandler((t, e) -> LOGGER.error("Unexpected error in Oracle background thread: ", e)).build();
            this.mExecutorService = Executors.newScheduledThreadPool(4, threadFactory);
        } else {
            this.mExecutorService = new OnThreadExecutorService();
        }
    }

    private void assertNotDisposed() {
        if (this.disposed.get()) {
            throw new IllegalStateException("System has been disposed");
        }
    }

    void attachListener(TransactionStateListener listener) {
        this.assertNotDisposed();
        Collection<TransactionStateListener> listeners = this.listenerMap.get(listener.getAssociatedTransaction().beginTimestamp());
        if (listeners == null) {
            listeners = new ConcurrentLinkedQueue<TransactionStateListener>();
            Collection<TransactionStateListener> old = this.listenerMap.putIfAbsent(listener.getAssociatedTransaction().beginTimestamp(), listeners);
            if (old != null) {
                listeners = old;
            }
        }
        listeners.add(listener);
    }

    void onCommit(long theCommittedTxnId) {
        this.assertNotDisposed();
        Collection<TransactionStateListener> listeners = this.listenerMap.remove(theCommittedTxnId);
        if (listeners == null || listeners.size() <= 0) {
            return;
        }
        Callable<Void> r = () -> {
            long mat = this.mTxnOracle.minimumActiveTransaction();
            for (TransactionStateListener listener : listeners) {
                try {
                    listener.onCommit();
                }
                catch (IOException ioe) {
                    LOGGER.warn("Error encountered performing post-commit hook:", (Throwable)ioe);
                }
            }
            return null;
        };
        this.mExecutorService.submit(r);
    }

    void onUpgrade(long theTxnId) {
        this.assertNotDisposed();
        Collection<TransactionStateListener> listeners = this.listenerMap.get(theTxnId);
        if (listeners == null || listeners.isEmpty()) {
            return;
        }
        Callable<Void> r = () -> {
            for (TransactionStateListener listener : listeners) {
                try {
                    listener.onUpgradeToWritable();
                }
                catch (IOException ioe) {
                    LOGGER.warn("Error encountered performing post-upgrade hook: ", (Throwable)ioe);
                }
            }
            return null;
        };
        this.mExecutorService.submit(r);
    }

    void onAbort(long rolledbackTxnId) {
        this.assertNotDisposed();
        Collection<TransactionStateListener> listeners = this.listenerMap.remove(rolledbackTxnId);
        if (listeners == null || listeners.size() <= 0) {
            return;
        }
        this.mExecutorService.submit(() -> {
            long mat = this.mTxnOracle.minimumActiveTransaction();
            for (TransactionStateListener listener : listeners) {
                try {
                    listener.onRollback();
                }
                catch (IOException ioe) {
                    LOGGER.warn("Error encountered performing post-rollback hook:", (Throwable)ioe);
                }
            }
            return null;
        });
    }

    void detachListener(TransactionStateListener theListener) {
        ((Collection)this.listenerMap.getOrDefault(theListener.getAssociatedTransaction().beginTimestamp(), Collections.emptyList())).remove(theListener);
    }

    public void dispose() {
        if (!this.disposed.compareAndSet(false, true)) {
            return;
        }
        this.mExecutorService.shutdownNow();
    }

    private static class OnThreadExecutorService
    extends AbstractExecutorService
    implements ExecutorService {
        private final AtomicBoolean shutdown = new AtomicBoolean(false);

        private OnThreadExecutorService() {
        }

        @Override
        public void shutdown() {
            this.shutdown.set(true);
        }

        @Override
        @Nonnull
        public List<Runnable> shutdownNow() {
            return Collections.emptyList();
        }

        @Override
        public boolean isShutdown() {
            return this.shutdown.get();
        }

        @Override
        public boolean isTerminated() {
            return this.isShutdown();
        }

        @Override
        public boolean awaitTermination(long timeout, @Nonnull TimeUnit unit) {
            return true;
        }

        @Override
        public void execute(@Nonnull Runnable command) {
            command.run();
        }
    }
}

