/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.mvcc.impl.oracle;

import com.complexible.common.primitives.Serializers;
import com.complexible.mvcc.impl.oracle.BlockTimestampGenerator;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;

public class FileBlockTimestampGenerator
extends BlockTimestampGenerator {
    private final Path blockLocation;

    public FileBlockTimestampGenerator(Path tsBlockLocation, long theBlockSize, long theInitialValue) throws IOException {
        super(theBlockSize, theInitialValue);
        this.blockLocation = tsBlockLocation;
        this.initializeFile(theBlockSize, theInitialValue);
    }

    @Inject
    public FileBlockTimestampGenerator(@Named(value="mvcc.timestamp.block.location") File tsBlockLocation, @Named(value="mvcc.timestamp.block.size") long theBlockSize) throws IOException {
        super(theBlockSize, 0L);
        this.blockLocation = tsBlockLocation.toPath();
        this.initializeFile(theBlockSize, 0L);
    }

    @Override
    protected void allocateBlock(long nextBlockStart, long theBlockSize) throws IOException {
        Files.write(this.blockLocation, Serializers.LONG.serialize(nextBlockStart + theBlockSize), new OpenOption[0]);
    }

    private void initializeFile(long blockSize, long theInitialValue) throws IOException {
        long initialBlockLocation = Math.max(1L, theInitialValue);
        if (Files.exists(this.blockLocation, new LinkOption[0])) {
            initialBlockLocation = Serializers.LONG.deserialize(Files.readAllBytes(this.blockLocation));
            this.allocateBlock(initialBlockLocation, blockSize);
        } else {
            Files.write(this.blockLocation, Serializers.LONG.serialize(initialBlockLocation + blockSize), StandardOpenOption.CREATE_NEW);
        }
        this.initialize(initialBlockLocation);
    }
}

