/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.mvcc.api;

import com.complexible.mvcc.api.IsolationLevel;

public interface Txn {
    public long beginTimestamp();

    public long commitTimestamp();

    public State currentState();

    public IsolationLevel isolationLevel();

    public boolean canSee(Txn var1);

    public boolean conflicts(Txn var1);

    default public boolean isActive() {
        return this.currentState() == State.ACTIVE;
    }

    default public boolean isCommitted() {
        return this.currentState() == State.COMMITTED;
    }

    default public boolean isRolledback() {
        return this.currentState() == State.ROLLED_BACK;
    }

    public boolean isWritable();

    public static enum State {
        ACTIVE(-127),
        ROLLED_BACK(-126),
        COMMITTED(0);

        private final byte code;

        private State(byte theCode) {
            this.code = theCode;
        }

        public byte code() {
            return this.code;
        }

        public static State decode(byte[] bytes, int offset) {
            switch (bytes[offset]) {
                case -127: {
                    return ACTIVE;
                }
                case -126: {
                    return ROLLED_BACK;
                }
                case 0: {
                    return COMMITTED;
                }
            }
            throw new IllegalStateException("Unknown transaction state: " + bytes[offset]);
        }

        public static State fromNativeOrdinal(int theInt) {
            switch (theInt) {
                case -1: {
                    return ACTIVE;
                }
                case -2: {
                    return ROLLED_BACK;
                }
                case 0: {
                    return COMMITTED;
                }
            }
            throw new IllegalArgumentException("Unexpected native state ordinal: " + theInt);
        }
    }
}

