/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.rdf.model;

import com.complexible.common.rdf.model.TransientValue;
import com.google.common.base.Preconditions;
import com.stardog.stark.Datatype;
import com.stardog.stark.IRI;
import com.stardog.stark.Literal;
import com.stardog.stark.Value;
import com.stardog.stark.Values;
import java.util.Arrays;
import javax.annotation.Nonnull;

public class ArrayLiteral
implements Literal,
TransientValue {
    public static final IRI ARRAY = Values.iri((String)"tag:stardog:api:array");
    private int mHashCode = -1;
    private final long[] mValues;
    private String mLabel;

    public ArrayLiteral(long ... theValues) {
        Preconditions.checkArgument((theValues != null ? 1 : 0) != 0, (Object)"Array literal must have non-null values");
        this.mValues = theValues;
    }

    public long[] getValues() {
        return this.mValues;
    }

    @Nonnull
    public Datatype datatype() {
        return Datatype.UDF;
    }

    @Nonnull
    public IRI datatypeIRI() {
        return ARRAY;
    }

    @Nonnull
    public String label() {
        if (this.mLabel == null) {
            this.mLabel = Arrays.toString(this.mValues);
        }
        return this.mLabel;
    }

    public int hashCode() {
        if (this.mHashCode == -1) {
            this.mHashCode = Arrays.hashCode(this.mValues);
        }
        return this.mHashCode;
    }

    public boolean equals(Object theObject) {
        if (this == theObject) {
            return true;
        }
        if (theObject instanceof ArrayLiteral) {
            ArrayLiteral that = (ArrayLiteral)theObject;
            return Arrays.equals(this.mValues, that.mValues);
        }
        return false;
    }

    public static ArrayLiteral coerce(Literal encodedValue) {
        String encodedString = Value.lex((Value)encodedValue);
        if ((encodedString = encodedString.substring(1, encodedString.length() - 1)).isEmpty()) {
            return new ArrayLiteral(new long[0]);
        }
        String[] strIds = encodedString.split(",\\s+");
        long[] ids = new long[strIds.length];
        for (int i = 0; i < strIds.length; ++i) {
            ids[i] = Long.parseLong(strIds[i]);
        }
        return new ArrayLiteral(ids);
    }
}

