/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.util;

import com.complexible.common.io.ByteReader;
import com.complexible.memory.accessor.ByteAccessor;
import com.complexible.memory.accessor.impl.ByteOrderUtil;
import com.complexible.memory.memoryblock.MemoryBlock;
import com.complexible.memory.memoryblock.MemoryBlockChain;
import com.complexible.memory.structure.sort.LongComparator;
import com.google.common.math.LongMath;
import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.ExecutionException;

public final class Utilities {
    public static final long KILOBYTE = 1024L;
    public static final int PAGE_SIZE_IN_BYTES = 4096;
    public static final long GIGABYTE = 0x40000000L;
    public static final int BYTE_SIZE_IN_BYTES = 1;
    public static final int BOOLEAN_SIZE_IN_BYTES = 1;
    public static final int SHORT_SIZE_IN_BYTES = 2;
    public static final int CHAR_SIZE_IN_BYTES = 2;
    public static final int INT_SIZE_IN_BYTES = 4;
    public static final int BYTE_SIZE_IN_BITS = 8;
    public static final int INT_SIZE_IN_BITS = 32;
    public static final int FLOAT_SIZE_IN_BYTES = 4;
    public static final int LONG_SIZE_IN_BYTES = 8;
    public static final int DOUBLE_SIZE_IN_BYTES = 8;
    public static final int DOUBLE_LONG_SIZE_IN_BYTES = 16;
    public static final int TRIPLE_LONG_SIZE_IN_BYTES = 24;
    public static final int QUAD_LONG_SIZE_IN_BYTES = 32;
    public static final int BITS_COUNT_BIT_POSITION = 3;
    public static final int INT_BIT_POSITION = 2;
    public static final int LONG_BIT_POSITION = 3;
    public static final int CHAR_BIT_POSITION = 1;
    public static final int DOUBLE_LONG_BIT_POSITION = 4;
    public static final int QUAD_LONG_BIT_POSITION = 5;
    public static final int ONE = 1;
    public static final int TWO = 2;
    public static final int ZERO = 0;
    public static int DUMMY_INDEX = -1;
    public static long PRE_MIN_LONG_VALUE = -9223372036854775807L;

    private Utilities() {
    }

    public static RuntimeException rethrow(Throwable e) {
        while (e instanceof ExecutionException && e.getCause() != null) {
            e = e.getCause();
        }
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        throw new RuntimeException(e);
    }

    public static MemoryBlock[] ensureArray(int theArraySize, MemoryBlock[] theArray) {
        Object[] result = theArray == null || theArray.length < theArraySize ? new MemoryBlock[theArraySize] : theArray;
        Arrays.fill(result, null);
        return result;
    }

    public static int[] ensureArray(int theArraySize, int[] theArray, int theDefaultValue) {
        int[] result = theArray == null || theArray.length < theArraySize ? new int[theArraySize] : theArray;
        Arrays.fill(result, theDefaultValue);
        return result;
    }

    public static boolean toBoolean(byte value) {
        return value != 0;
    }

    public static byte toByte(boolean value) {
        return value ? (byte)1 : 0;
    }

    public static boolean isPositivePowerOfTwo(long x) {
        return x > 0L && LongMath.isPowerOfTwo((long)x);
    }

    public static int modPowerOfTwo(int a, int b) {
        return a & b - 1;
    }

    public static long modPowerOfTwo(long a, int b) {
        return a & (long)(b - 1);
    }

    public static int log2(int value) {
        return 31 - Integer.numberOfLeadingZeros(value);
    }

    public static long log2(long value) {
        return 63 - Long.numberOfLeadingZeros(value);
    }

    public static int ceilingNextPowerOfTwo(int x) {
        return 1 << 32 - Integer.numberOfLeadingZeros(x - 1);
    }

    public static long ceilingNextPowerOfTwo(long x) {
        return 1L << 64 - Long.numberOfLeadingZeros(x - 1L);
    }

    public static long multiplyLongPowerOfTwoAsLong(long theBase, int thePowerPosition) {
        return theBase << thePowerPosition;
    }

    public static long multiplyLongPowerOfTwoAsLong(long theBase, long thePowerPosition) {
        return theBase << (int)thePowerPosition;
    }

    public static char multiplyCharPowerOfTwoAsChar(char theBase, long thePowerPosition) {
        return (char)(theBase << (int)thePowerPosition);
    }

    public static long multiplyIntPowerOfTwoAsLong(int theBase, int thePowerPosition) {
        return (long)theBase << thePowerPosition;
    }

    public static int multiplyIntPowerOfTwoAsInt(int theBase, int thePowerPosition) {
        return theBase << thePowerPosition;
    }

    public static byte divideLongPowerOfTwoAsByte(long theBase, int thePowerPosition) {
        return (byte)(theBase >> thePowerPosition);
    }

    public static int divideIntPowerOfTwoAsInt(int theBase, int thePowerPosition) {
        return theBase >> thePowerPosition;
    }

    public static int divideLongPowerOfTwoAsInt(long theBase, int thePowerPosition) {
        return (int)(theBase >> thePowerPosition);
    }

    public static long divideLongPowerOfTwoAsLong(long theBase, int thePowerPosition) {
        return theBase >> thePowerPosition;
    }

    public static int maskIntPowerOfTwoAsInt(int theBase, int thePowerPosition) {
        return theBase & thePowerPosition;
    }

    public static int maskLongPowerOfTwoAsInt(long theBase, int thePowerPosition) {
        return (int)(theBase & (long)thePowerPosition);
    }

    public static long maskLongPowerOfTwoAsLong(long theBase, long thePowerPosition) {
        return theBase & thePowerPosition;
    }

    public static char maskCharPowerOfTwoAsChar(char theBase, long thePowerPosition) {
        return (char)(theBase & (char)thePowerPosition);
    }

    public static long multiplyBytePowerOfTwoAsLong(byte theBase, int thePowerPosition) {
        return (long)theBase << thePowerPosition;
    }

    public static long calculateAddress(int theIndex, int theOffset, int theBitPosition) {
        return ((long)theIndex << theBitPosition) + (long)theOffset;
    }

    public static <R> long readFromResource(ByteAccessor<R> theStrategy, R theResource, long theSourceOffset, long[] theDestinationArray, long theDstOffset, long theLength, boolean aUseBigEndian) {
        long aLength = theLength;
        if (aLength == 0L) {
            return 0L;
        }
        long aSourceAddress = theSourceOffset;
        int aLastIndex = (int)(theDstOffset >> 3);
        int aLastOffset = (int)Utilities.modPowerOfTwo(theDstOffset, 8);
        if (aLastOffset > 0) {
            int aRemainingBytes = (int)Math.min((long)(8 - aLastOffset), theLength);
            long aLongMask = (Utilities.multiplyLongPowerOfTwoAsLong(1L, (long)aRemainingBytes << 3) ^ 0xFFFFFFFFFFFFFFFFL) - 1L;
            long aSrcLong = ByteOrderUtil.readLong(theStrategy, theResource, aRemainingBytes, (int)aSourceAddress, aUseBigEndian);
            long aDstLong = Utilities.maskLongPowerOfTwoAsLong(theDestinationArray[aLastIndex], aLongMask);
            theDestinationArray[aLastIndex] = aDstLong |= aSrcLong;
            ++aLastIndex;
            aSourceAddress += (long)aRemainingBytes;
            if ((aLength -= (long)aRemainingBytes) == 0L) {
                return theLength;
            }
        }
        long aLongCount = aLength >> 3;
        int aRemainingBytes = (int)Utilities.modPowerOfTwo(aLength, 8);
        int i = 0;
        while ((long)i < aLongCount) {
            theDestinationArray[aLastIndex] = ByteOrderUtil.readLong(theStrategy, theResource, aSourceAddress, aUseBigEndian);
            aSourceAddress += 8L;
            ++aLastIndex;
            ++i;
        }
        if (aRemainingBytes != 0) {
            long aLongMask = (1L << (int)((long)(8 - aRemainingBytes) << 3)) - 1L ^ 0xFFFFFFFFFFFFFFFFL;
            long aSrcLong = ByteOrderUtil.readLong(theStrategy, theResource, aRemainingBytes, (int)aSourceAddress, aUseBigEndian);
            long aDstLong = theDestinationArray[aLastIndex] & aLongMask;
            theDestinationArray[aLastIndex] = aDstLong |= aSrcLong;
        }
        return theLength;
    }

    public static <R> long readFromResource(ByteAccessor<R> theStrategy, R theResource, long theSourceOffset, char[] theDestinationArray, long theDstOffset, long theLength, boolean aUseBigEndian) {
        long aLength = theLength;
        if (aLength == 0L) {
            return 0L;
        }
        long aSourceAddress = theSourceOffset;
        int aLastIndex = (int)(theDstOffset >> 1);
        int aLastOffset = (int)Utilities.modPowerOfTwo(theDstOffset, 2);
        if (aLastOffset > 0) {
            int aRemainingBytes = (int)Math.min((long)(2 - aLastOffset), theLength);
            char aCharMask = (char)((char)(~Utilities.multiplyCharPowerOfTwoAsChar('\u0001', (char)aRemainingBytes << 3)) - '\u0001');
            char aSrcChar = ByteOrderUtil.readChar(theStrategy, theResource, aRemainingBytes, (int)aSourceAddress, aUseBigEndian);
            char aDstChar = Utilities.maskCharPowerOfTwoAsChar(theDestinationArray[aLastIndex], aCharMask);
            theDestinationArray[aLastIndex] = aDstChar = (char)(aDstChar | aSrcChar);
            ++aLastIndex;
            aSourceAddress += (long)aRemainingBytes;
            if ((aLength -= (long)aRemainingBytes) == 0L) {
                return theLength;
            }
        }
        long aLongCount = aLength >> 1;
        int aRemainingBytes = (int)Utilities.modPowerOfTwo(aLength, 2);
        int i = 0;
        while ((long)i < aLongCount) {
            theDestinationArray[aLastIndex] = ByteOrderUtil.readChar(theStrategy, theResource, aSourceAddress, aUseBigEndian);
            aSourceAddress += 2L;
            ++aLastIndex;
            ++i;
        }
        if (aRemainingBytes != 0) {
            char aCharMask = ~((char)((char)(1 << (int)((long)(2 - aRemainingBytes) << 3)) - '\u0001'));
            char aSrcChar = ByteOrderUtil.readChar(theStrategy, theResource, aRemainingBytes, (int)aSourceAddress, aUseBigEndian);
            char aDstChar = (char)(theDestinationArray[aLastIndex] & aCharMask);
            theDestinationArray[aLastIndex] = aDstChar = (char)(aDstChar | aSrcChar);
        }
        return theLength;
    }

    public static <R> long readFromResource(ByteAccessor<R> theStrategy, R theResource, long theSourceOffset, byte[] theDestinationArray, int theDstOffset, long theLength) {
        if (theLength == 0L) {
            return 0L;
        }
        long aSourceAddress = theSourceOffset;
        int aLastIndex = theDstOffset;
        int i = 0;
        while ((long)i < theLength) {
            theDestinationArray[aLastIndex] = theStrategy.getByte(theResource, aSourceAddress);
            ++aSourceAddress;
            ++aLastIndex;
            ++i;
        }
        return theLength;
    }

    public static void resetByteReader(ByteReader theReader) {
        try {
            theReader.setPosition(0L);
        }
        catch (IOException theE) {
            throw Utilities.rethrow(theE);
        }
    }

    public static void copyMemory(long theSourcePosition, long theTargetPosition, long theBytesCount, MemoryBlockChain theSourceMemoryBlockChain, MemoryBlockChain theTargetMemoryBlockChain, int theBlockSizeMask, int theBlockSizeBitPosition, int theBlockSize) {
        if (theBytesCount == 0L) {
            return;
        }
        if (theSourceMemoryBlockChain != theTargetMemoryBlockChain) {
            Utilities.copy(theSourcePosition, theTargetPosition, theBytesCount, theSourceMemoryBlockChain, theTargetMemoryBlockChain, theBlockSizeMask, theBlockSizeBitPosition, theBlockSize);
            return;
        }
        if (theSourcePosition == theTargetPosition) {
            return;
        }
        if (theSourcePosition < theTargetPosition) {
            if (theSourcePosition + theBytesCount <= theTargetPosition) {
                Utilities.copy(theSourcePosition, theTargetPosition, theBytesCount, theSourceMemoryBlockChain, theTargetMemoryBlockChain, theBlockSizeMask, theBlockSizeBitPosition, theBlockSize);
            } else {
                Utilities.moveRight(theSourcePosition, theTargetPosition, theBytesCount, theSourceMemoryBlockChain, theTargetMemoryBlockChain, theBlockSizeMask, theBlockSizeBitPosition, theBlockSize);
            }
        } else if (theSourcePosition > theTargetPosition) {
            if (theSourcePosition - theBytesCount >= theTargetPosition) {
                Utilities.copy(theSourcePosition, theTargetPosition, theBytesCount, theSourceMemoryBlockChain, theTargetMemoryBlockChain, theBlockSizeMask, theBlockSizeBitPosition, theBlockSize);
            } else {
                Utilities.moveLeft(theSourcePosition, theTargetPosition, theBytesCount, theSourceMemoryBlockChain, theTargetMemoryBlockChain, theBlockSizeMask, theBlockSizeBitPosition, theBlockSize);
            }
        }
    }

    private static void copy(long theSourcePosition, long theTargetPosition, long theBytesCount, MemoryBlockChain theSourceMemoryBlockChain, MemoryBlockChain theTargetMemoryBlockChain, int theBlockSizeMask, int theBlockSizeBitPosition, int theBlockSize) {
        int aBytesToCopy;
        int aSourceBlockOffset = Utilities.getOffset(theSourcePosition, theBlockSizeMask);
        int aSourceBlockIndex = Utilities.getIndex(theSourcePosition, theBlockSizeBitPosition);
        int aTargetBlockOffset = Utilities.getOffset(theTargetPosition, theBlockSizeMask);
        int aTargetBlockIndex = Utilities.getIndex(theTargetPosition, theBlockSizeBitPosition);
        for (long aRemainingBytes = theBytesCount; aRemainingBytes > 0L; aRemainingBytes -= (long)aBytesToCopy) {
            MemoryBlock aSourceMemoryBlock = theSourceMemoryBlockChain.get(aSourceBlockIndex);
            MemoryBlock aTargetMemoryBlock = theTargetMemoryBlockChain.get(aTargetBlockIndex);
            aBytesToCopy = (int)Math.min((long)Math.min(theBlockSize - aSourceBlockOffset, theBlockSize - aTargetBlockOffset), aRemainingBytes);
            aTargetMemoryBlock.copyFromMemoryBlock(aSourceMemoryBlock, aSourceBlockOffset, aTargetBlockOffset, aBytesToCopy);
            if ((aSourceBlockOffset += aBytesToCopy) >= theBlockSize) {
                ++aSourceBlockIndex;
                aSourceBlockOffset -= theBlockSize;
            }
            if ((aTargetBlockOffset += aBytesToCopy) < theBlockSize) continue;
            ++aTargetBlockIndex;
            aTargetBlockOffset -= theBlockSize;
        }
    }

    private static void moveRight(long theSourcePosition, long theTargetPosition, long theBytesCount, MemoryBlockChain theSourceMemoryBlockChain, MemoryBlockChain theTargetMemoryBlockChain, int theBlockSizeMask, int theBlockSizeBitPosition, int theBlockSize) {
        long theRightSourcePosition = theSourcePosition + theBytesCount - 1L;
        long theRightTargetPosition = theTargetPosition + theBytesCount - 1L;
        long aRemainingBytes = theBytesCount;
        while (aRemainingBytes > 0L) {
            int aRightSourceBlockOffset = Utilities.getOffset(theRightSourcePosition, theBlockSizeMask);
            int aRightTargetBlockOffset = Utilities.getOffset(theRightTargetPosition, theBlockSizeMask);
            int aBytesToCopy = (int)Math.min((long)Math.min(aRightSourceBlockOffset + 1, aRightTargetBlockOffset + 1), aRemainingBytes);
            long aSourcePosition = theRightSourcePosition - (long)aBytesToCopy + 1L;
            long aTargetPosition = theRightTargetPosition - (long)aBytesToCopy + 1L;
            Utilities.copy(aSourcePosition, aTargetPosition, aBytesToCopy, theSourceMemoryBlockChain, theTargetMemoryBlockChain, theBlockSizeMask, theBlockSizeBitPosition, theBlockSize);
            aRemainingBytes -= (long)aBytesToCopy;
            theRightSourcePosition -= (long)aBytesToCopy;
            theRightTargetPosition -= (long)aBytesToCopy;
        }
    }

    private static void moveLeft(long theSourcePosition, long theTargetPosition, long theBytesCount, MemoryBlockChain theSourceMemoryBlockChain, MemoryBlockChain theTargetMemoryBlockChain, int theBlockSizeMask, int theBlockSizeBitPosition, int theBlockSize) {
        long aDelta = theSourcePosition - theTargetPosition;
        long aCopiedBytes = 0L;
        long aRemainingBytes = theBytesCount;
        while (aCopiedBytes < theBytesCount) {
            long aSourcePosition = theSourcePosition + aCopiedBytes;
            int aSourceBlockOffset = Utilities.getOffset(theSourcePosition, theBlockSizeMask);
            long aBytesToCopy = Math.min(aRemainingBytes, (long)(theBlockSize - aSourceBlockOffset));
            Utilities.copy(aSourcePosition, aSourcePosition - aDelta, aBytesToCopy, theSourceMemoryBlockChain, theTargetMemoryBlockChain, theBlockSizeMask, theBlockSizeBitPosition, theBlockSize);
            aCopiedBytes += aBytesToCopy;
            aRemainingBytes -= aBytesToCopy;
        }
    }

    public static int getOffset(long theSourcePosition, int theBlockSizeMask) {
        return Utilities.maskLongPowerOfTwoAsInt(theSourcePosition, theBlockSizeMask);
    }

    public static int getIndex(long theSourcePosition, int theBlockSizeBitPosition) {
        return Utilities.divideLongPowerOfTwoAsInt(theSourcePosition, theBlockSizeBitPosition);
    }

    public static LongComparator getComparator(LongComparator theComparator) {
        return theComparator == null ? Long::compare : theComparator;
    }
}

