/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.sort.sorters.quick;

import com.complexible.common.base.Disposables;
import com.complexible.memory.structure.OperationTracker;
import com.complexible.memory.structure.sort.SortOrder;
import com.complexible.memory.structure.sort.sorters.quick.BaseQuickSorter;
import com.complexible.memory.structure.sort.sorters.quick.accessor.SourceAccessor;

public abstract class SlotBaseQuickSorter<S>
extends BaseQuickSorter {
    protected final int mSlotSize;
    protected final SortOrder mDirection;
    protected final SourceAccessor<S> mSourceAccessor;

    protected SlotBaseQuickSorter(int theSlotSize, SortOrder theSortOrder) {
        this.mSlotSize = theSlotSize;
        this.mDirection = theSortOrder;
        this.mSourceAccessor = this.createAccessor();
        Disposables.markCreated((Object)this);
    }

    protected final int slotSize() {
        return this.mSlotSize;
    }

    protected int processDirection(int theCmpResult) {
        return this.mDirection == SortOrder.ASC ? theCmpResult : -theCmpResult;
    }

    public void gotoSource(S theMemorySource, OperationTracker theOperationTracker) {
        this.mOperationTracker = theOperationTracker;
        this.mSourceAccessor.setAccessor(theMemorySource);
    }

    public void gotoSource(S theMemorySource) {
        this.gotoSource(theMemorySource, null);
    }

    @Override
    protected boolean isLessThanCurrent(long theIndex) {
        return this.compare0(theIndex) < 0;
    }

    @Override
    protected boolean isGreaterThanCurrent(long theIndex) {
        return this.compare0(theIndex) > 0;
    }

    private int compare0(long theIndex) {
        int aCmpResult = this.compare(theIndex);
        return this.processDirection(aCmpResult);
    }

    @Override
    protected void swap(long theIndex1, long theIndex2) {
        this.mSourceAccessor.swap(this.addressOfIndex(theIndex1), this.addressOfIndex(theIndex2));
    }

    @Override
    public void dispose() {
        super.dispose();
        this.mSourceAccessor.setAccessor(null);
    }

    protected abstract SourceAccessor<S> createAccessor();

    protected abstract long addressOfIndex(long var1);

    protected abstract int compare(long var1);
}

