/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.sort.sorters.quick;

import com.complexible.common.base.AutoCloser;
import com.complexible.common.base.Disposable;
import com.complexible.common.base.Disposables;
import com.complexible.memory.memoryblock.MemoryBlockChain;
import com.complexible.memory.memoryblock.MemoryBlockChainFactory;
import com.complexible.memory.memoryblock.MemoryContext;
import com.complexible.memory.structure.input.TapeElementInput;
import com.complexible.memory.structure.input.impl.DefaultTapeElementInputFactory;
import com.complexible.memory.structure.sort.LongComparator;
import com.complexible.memory.structure.sort.SortOrder;
import com.complexible.memory.structure.sort.sorters.quick.LongOptimizedBaseSorter;
import java.util.function.Supplier;

abstract class ConventionalLongOptimizedBaseSorter<S>
extends LongOptimizedBaseSorter<S> {
    private final DefaultTapeElementInputFactory mLeftTapeElementInputFactory;
    private final DefaultTapeElementInputFactory mRightTapeElementInputFactory;
    private final Supplier<MemoryBlockChain> mDataMemoryBlockChainSupplier;
    private final boolean mIsInlined;

    ConventionalLongOptimizedBaseSorter(MemoryContext theMemoryContext, Supplier<MemoryBlockChain> theDataMemoryBlockChainSupplier, MemoryBlockChainFactory theMemoryBlockChainFactory, SortOrder theSortOrder, LongComparator theLongComparator) {
        this(16, 4, 8, theMemoryContext, theDataMemoryBlockChainSupplier, theMemoryBlockChainFactory, theSortOrder, theLongComparator);
    }

    private ConventionalLongOptimizedBaseSorter(int theSlotSize, int theSlotSizeBitPosition, int theLongValueOffset, MemoryContext theMemoryContext, Supplier<MemoryBlockChain> theDataMemoryBlockChainSupplier, MemoryBlockChainFactory theMemoryBlockChainFactory, SortOrder theSortOrder, LongComparator theLongComparator) {
        super(theSlotSize, theSlotSizeBitPosition, theLongValueOffset, theSortOrder, theLongComparator);
        try {
            this.mDataMemoryBlockChainSupplier = theDataMemoryBlockChainSupplier;
            this.mLeftTapeElementInputFactory = new DefaultTapeElementInputFactory(theMemoryContext, theMemoryBlockChainFactory);
            this.mRightTapeElementInputFactory = new DefaultTapeElementInputFactory(theMemoryContext, theMemoryBlockChainFactory);
            this.mIsInlined = theLongComparator.isInlined();
        }
        catch (Throwable t) {
            this.dispose();
            throw t;
        }
    }

    @Override
    protected int compare(long theIndex) {
        int aResult = this.mComparator.compare(this.longValue(theIndex), this.mPivotLongValue);
        if (aResult == 0 && this.mIsInlined) {
            MemoryBlockChain aMemoryBlockChain = this.mDataMemoryBlockChainSupplier.get();
            long aAddress = this.addressOfIndex(theIndex);
            int aBlockIndex = this.blockIndexAtAddress(aAddress);
            int aBlockOffset = this.blockOffsetAtAddress(aAddress);
            TapeElementInput aLeftTapeElementInput = this.mLeftTapeElementInputFactory.createMemoryInput(aMemoryBlockChain, aBlockOffset, aBlockIndex);
            TapeElementInput aRightTapeElementInput = this.mRightTapeElementInputFactory.createMemoryInput(aMemoryBlockChain, this.mPivotBlockOffset, this.mPivotBlockIndex);
            return this.mComparator.compare(aLeftTapeElementInput, aRightTapeElementInput);
        }
        return aResult;
    }

    @Override
    public void dispose() {
        AutoCloser.close((AutoCloseable[])new AutoCloseable[]{() -> super.dispose(), Disposables.asCloseable((Disposable)this.mLeftTapeElementInputFactory), Disposables.asCloseable((Disposable)this.mRightTapeElementInputFactory)});
    }
}

