/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.sort.sorters.quick;

import com.complexible.common.base.Disposables;
import com.complexible.memory.structure.OperationTracker;
import com.complexible.memory.structure.OperationType;
import com.complexible.memory.structure.sort.sorters.quick.BaseSorter;
import com.complexible.memory.util.Utilities;

public abstract class BaseQuickSorter
extends BaseSorter {
    private static final int SHELL_SORT_INDEX = 3;
    private static final int MAX_STACK_DEPTH = 2048;
    protected OperationTracker mOperationTracker;

    protected BaseQuickSorter() {
        Disposables.markCreated((Object)this);
    }

    public void dispose() {
        Disposables.markReleased((Object)this);
    }

    @Override
    protected void sort0(long lo, long hi) {
        if (this.mOperationTracker == null) {
            if (!this.quickSort0(lo, hi, 0)) {
                this.shellSort(lo, hi);
            }
        } else if (!this.quickSortAndTrack0(lo, hi, 0)) {
            this.shellSortAndTrack(lo, hi);
        }
    }

    private void shellSort(long lo, long hi) {
        long h = lo;
        while (h * 3L <= hi) {
            h = h * 3L + 1L;
        }
        while (h > 0L) {
            block2: for (long i = h; i <= hi; ++i) {
                for (long j = i; j >= h; j -= h) {
                    this.readCurrent(j);
                    if (!this.isGreaterThanCurrent(j - h)) continue block2;
                    this.swap(j, j - h);
                }
            }
            h /= 3L;
        }
    }

    private void shellSortAndTrack(long lo, long hi) {
        long h = lo;
        while (h * 3L <= hi) {
            h = h * 3L + 1L;
        }
        while (h > 0L) {
            for (long i = h; i <= hi; ++i) {
                for (long j = i; j >= h; j -= h) {
                    this.readCurrent(j);
                    if (!this.isGreaterThanCurrent(j - h)) break;
                    this.swap(j, j - h);
                }
                this.mOperationTracker.onNext(OperationType.SORTING);
            }
            h /= 3L;
        }
    }

    private boolean quickSort0(long lo, long hi, int depth) {
        if (depth >= 2048) {
            return false;
        }
        if (lo >= hi) {
            return true;
        }
        long p = this.sortPartition(lo, hi);
        return this.quickSort0(lo, p, depth + 1) && this.quickSort0(p + 1L, hi, depth + 1);
    }

    private boolean quickSortAndTrack0(long lo, long hi, int depth) {
        if (depth >= 2048) {
            this.mOperationTracker.onNext(OperationType.SORTING);
            return false;
        }
        if (lo >= hi) {
            this.mOperationTracker.onNext(OperationType.SORTING);
            return true;
        }
        long p = this.sortPartition(lo, hi);
        return this.quickSortAndTrack0(lo, p, depth + 1) && this.quickSortAndTrack0(p + 1L, hi, depth + 1);
    }

    private long sortPartition(long lo, long hi) {
        this.readCurrent(Utilities.divideLongPowerOfTwoAsLong(lo + hi, 1));
        long i = lo - 1L;
        long j = hi + 1L;
        while (true) {
            if (this.isLessThanCurrent(++i)) {
                continue;
            }
            while (this.isGreaterThanCurrent(--j)) {
            }
            if (i >= j) {
                return j;
            }
            this.swap(i, j);
        }
    }
}

