/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.sort.iterator.impl.longiterator.multiple;

import com.complexible.memory.accessor.MemoryBlockChainByteReaderWriter;
import com.complexible.memory.memoryblock.MemoryBlockChain;
import com.complexible.memory.memoryblock.MemoryContext;
import com.complexible.memory.structure.impl.aggregator.accessor.MemoryBlockChainByteReaderWriterImpl;
import com.complexible.memory.structure.sort.iterator.impl.longiterator.multiple.BaseMemoryMultipleLongInputIterator;
import com.complexible.memory.util.Utilities;
import java.io.IOException;
import java.util.function.Supplier;

public final class TripleLongInputIterator
extends BaseMemoryMultipleLongInputIterator {
    private final int mSlotSizeInBytes;
    private final MemoryBlockChainByteReaderWriter mByteReaderWriter;

    public TripleLongInputIterator(Supplier<MemoryBlockChain> theTapeArea, MemoryContext theMemoryContext) {
        super(theTapeArea);
        this.mByteReaderWriter = new MemoryBlockChainByteReaderWriterImpl(theTapeArea, theMemoryContext);
        this.mSlotSizeInBytes = 24;
    }

    @Override
    public boolean next(int theInputId) {
        ++this.mElementsNumber;
        return this.mElementsNumber < this.mElementsCount;
    }

    @Override
    public long longValue(int theInputId, int theOffset) {
        try {
            this.mByteReaderWriter.setPosition((long)this.mSlotSizeInBytes * this.mElementsNumber + (long)theOffset);
            return this.mByteReaderWriter.readLong();
        }
        catch (IOException theE) {
            throw Utilities.rethrow(theE);
        }
    }

    @Override
    public void reset() {
        this.mElementsNumber = Utilities.DUMMY_INDEX;
        if (this.mTapeArea.get() != null) {
            this.mElementsCount = ((MemoryBlockChain)this.mTapeArea.get()).getMemoryElementsCount();
        }
    }
}

