/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.sort.iterator.impl;

import com.complexible.memory.memoryblock.MemoryBlockChain;
import com.complexible.memory.memoryblock.MemoryContext;
import com.complexible.memory.structure.input.TapeElementInput;
import com.complexible.memory.structure.input.TapeElementInputFactory;
import com.complexible.memory.structure.input.impl.DefaultTapeElementInputFactory;
import com.complexible.memory.structure.sort.iterator.ConventionalMultiInputIterator;
import com.complexible.memory.util.Utilities;
import java.util.function.Supplier;

public final class MemoryChainMultiInputIterator
implements ConventionalMultiInputIterator<TapeElementInput, TapeElementInputFactory<TapeElementInput>> {
    private int mDataBlockIndex;
    private long mElementsCount;
    private int mDataBlockOffset;
    private final int mBlockSize;
    private final int mBlockSizeLog2;
    private final int mBlockSizeMask;
    private TapeElementInput mTapeElementInput;
    private MemoryBlockChain mDataMemoryBlockChain;
    private final TapeElementInputFactory<TapeElementInput> mTapeElementInputFactory;
    private final Supplier<MemoryBlockChain> mDataMemoryBlockChainHolder;

    public MemoryChainMultiInputIterator(Supplier<MemoryBlockChain> theDataMemoryBlockChainHolder, MemoryContext theMemoryContext) {
        this.mBlockSize = theMemoryContext.getBlockSize();
        this.mBlockSizeMask = theMemoryContext.getBlockSizeMask();
        this.mBlockSizeLog2 = theMemoryContext.getBlockSizeBitPosition();
        this.mDataMemoryBlockChainHolder = theDataMemoryBlockChainHolder;
        this.mTapeElementInputFactory = new DefaultTapeElementInputFactory(theMemoryContext);
    }

    @Override
    public boolean next(int theInputId) {
        if (this.mElementsCount <= 0L) {
            return false;
        }
        --this.mElementsCount;
        this.mTapeElementInput = this.createInput(0, this.mTapeElementInputFactory);
        this.step(this.mTapeElementInput.getElementLength() + 8L);
        return true;
    }

    @Override
    public TapeElementInput createInput(int theInputId, TapeElementInputFactory theATapeElementInputFactory) {
        Object aTapeElementInput = theATapeElementInputFactory.createMemoryInput(this.mDataMemoryBlockChain, this.mDataBlockOffset, this.mDataBlockIndex);
        this.mTapeElementInput = aTapeElementInput;
        return aTapeElementInput;
    }

    @Override
    public TapeElementInput getInput(int theInputId) {
        TapeElementInput aTapeElementInput = this.mTapeElementInput;
        if (aTapeElementInput == null) {
            return this.createInput(theInputId, this.mTapeElementInputFactory);
        }
        aTapeElementInput.reset();
        return aTapeElementInput;
    }

    @Override
    public TapeElementInput takeInput(int theInputId) {
        TapeElementInput aTapeElementInput = this.mTapeElementInput;
        if (aTapeElementInput != null) {
            return aTapeElementInput;
        }
        throw new IllegalStateException("No input for take");
    }

    @Override
    public void reset() {
        this.mDataBlockIndex = 0;
        this.mDataBlockOffset = 0;
        this.mDataMemoryBlockChain = this.mDataMemoryBlockChainHolder.get();
        if (this.mDataMemoryBlockChain != null) {
            this.mElementsCount = this.mDataMemoryBlockChain.getMemoryElementsCount();
        }
        this.mTapeElementInput = null;
        this.mTapeElementInputFactory.reset();
    }

    @Override
    public void dispose() {
        this.reset();
        this.mTapeElementInputFactory.dispose();
    }

    protected void step(long theLength) {
        long next = (long)this.mDataBlockOffset + theLength;
        if (next < (long)this.mBlockSize) {
            this.mDataBlockOffset = (int)next;
            return;
        }
        this.mDataBlockOffset = Utilities.maskLongPowerOfTwoAsInt(next, this.mBlockSizeMask);
        this.mDataBlockIndex += Utilities.divideLongPowerOfTwoAsInt(next, this.mBlockSizeLog2);
    }
}

