/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.sort.iterator.impl;

import com.complexible.memory.structure.sort.iterator.MultiInputIterator;

public final class DualMultiInputIterator<I extends MultiInputIterator>
implements MultiInputIterator {
    private final I mLeftInputIterator;
    private final I mRightInputIterator;

    public DualMultiInputIterator(I theLeftProvider, I theRightProvider) {
        this.mLeftInputIterator = theLeftProvider;
        this.mRightInputIterator = theRightProvider;
    }

    @Override
    public int availableInputsCount() {
        return this.mLeftInputIterator.availableInputsCount() + this.mRightInputIterator.availableInputsCount();
    }

    @Override
    public boolean next(int theInputId) {
        if (theInputId == 0) {
            return this.mLeftInputIterator.next(theInputId);
        }
        return this.mRightInputIterator.next(theInputId - 1);
    }

    @Override
    public void reset() {
        this.mLeftInputIterator.reset();
        this.mRightInputIterator.reset();
    }

    @Override
    public void dispose() {
        this.mLeftInputIterator.dispose();
        this.mRightInputIterator.dispose();
    }
}

