/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.sort.iterator.impl;

import com.complexible.memory.file.FileReader;
import com.complexible.memory.structure.input.TapeElementInput;
import com.complexible.memory.structure.input.TapeElementInputFactory;
import com.complexible.memory.structure.sort.iterator.ConventionalMultiInputIterator;

public class DiskMultiInputIterator<T extends TapeElementInput, F extends TapeElementInputFactory<T>>
implements ConventionalMultiInputIterator<T, F> {
    private T mTapeElementInput;
    private final F mTapeElementInputFactory;
    private final FileReader mDiskInput;

    public DiskMultiInputIterator(FileReader theDiskInput, F theTapeElementInputFactory) {
        this.mDiskInput = theDiskInput;
        this.mTapeElementInputFactory = theTapeElementInputFactory;
    }

    @Override
    public boolean next(int theInputId) {
        this.finish();
        this.reset();
        return this.mDiskInput.checkAvailable(8);
    }

    @Override
    public T createInput(int theInputId, F theATapeElementInputFactory) {
        if (this.checkCurrentInput()) {
            return this.mTapeElementInput;
        }
        this.mTapeElementInput = theATapeElementInputFactory.createSpillingInput(this.mDiskInput);
        return this.mTapeElementInput;
    }

    @Override
    public T getInput(int theInputId) {
        if (this.checkCurrentInput()) {
            return this.mTapeElementInput;
        }
        return this.createInput(theInputId, this.mTapeElementInputFactory);
    }

    @Override
    public T takeInput(int theInputId) {
        if (this.mTapeElementInput != null) {
            return this.mTapeElementInput;
        }
        throw new IllegalStateException("No input for take");
    }

    @Override
    public void reset() {
        this.mTapeElementInput = null;
        this.mTapeElementInputFactory.reset();
    }

    @Override
    public void dispose() {
        this.mTapeElementInput = null;
        this.mTapeElementInputFactory.dispose();
    }

    private void finish() {
        if (this.mTapeElementInput != null) {
            this.mTapeElementInput.finish();
        }
    }

    private boolean checkCurrentInput() {
        if (this.mTapeElementInput != null) {
            this.mTapeElementInput.reset();
            return true;
        }
        return false;
    }
}

