/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.sort.iterator.impl;

import com.complexible.memory.memoryblock.DefaultMemoryBlockChain;
import com.complexible.memory.memoryblock.MemoryBlock;
import com.complexible.memory.memoryblock.MemoryBlockChain;
import com.complexible.memory.memoryblock.MemoryContext;
import com.complexible.memory.structure.impl.tape.MemoryBlockAddressArea;
import com.complexible.memory.structure.input.TapeElementInput;
import com.complexible.memory.structure.input.TapeElementInputFactory;
import com.complexible.memory.structure.input.impl.DefaultTapeElementInputFactory;
import com.complexible.memory.structure.sort.iterator.GenericMultiInputIterator;
import com.complexible.memory.util.Utilities;
import java.util.function.Supplier;

public class AddressMultiInputIterator
implements GenericMultiInputIterator {
    protected int mInputsCount;
    private int[] mDataBlockIndexes;
    private int[] mDataBlockOffsets;
    private int[] mAddressBlockOffsets;
    private final MemoryBlockAddressArea mAddressingArea;
    private final Supplier<MemoryBlockChain> mDataMemoryBlockChainHolder;
    private final TapeElementInputFactory<TapeElementInput> mTapeElementInputFactory;

    public AddressMultiInputIterator(Supplier<MemoryBlockChain> mDataMemoryBlockChainHolder, MemoryBlockAddressArea theAddressingArea, MemoryContext theMemoryContext) {
        this.mAddressingArea = theAddressingArea;
        this.mDataMemoryBlockChainHolder = mDataMemoryBlockChainHolder;
        this.mTapeElementInputFactory = new DefaultTapeElementInputFactory(theMemoryContext);
    }

    @Override
    public int availableInputsCount() {
        return this.mInputsCount;
    }

    @Override
    public boolean next(int theInputId) {
        int aLimit;
        int aOffset = this.mAddressBlockOffsets[theInputId];
        DefaultMemoryBlockChain aMemoryBlockChain = this.mAddressingArea.get();
        MemoryBlock aMemoryBlock = aMemoryBlockChain.get(theInputId);
        int n = aLimit = theInputId == aMemoryBlockChain.getActualBlocksCount() - 1 ? aMemoryBlockChain.currentBlockOffset() : aMemoryBlock.getBlockSize();
        if (aOffset >= aLimit) {
            return false;
        }
        this.handleOffset(aOffset, theInputId, aMemoryBlock);
        return true;
    }

    @Override
    public TapeElementInput createInput(int theInputId, TapeElementInputFactory theATapeElementInputFactory) {
        return theATapeElementInputFactory.createMemoryInput(this.mDataMemoryBlockChainHolder.get(), this.mDataBlockOffsets[theInputId], this.mDataBlockIndexes[theInputId]);
    }

    @Override
    public TapeElementInput getInput(int theInputId) {
        return this.createInput(theInputId, this.mTapeElementInputFactory);
    }

    @Override
    public void reset() {
        DefaultMemoryBlockChain aMemoryBlockChain = this.mAddressingArea.get();
        if (aMemoryBlockChain == null) {
            return;
        }
        this.mInputsCount = Math.min(aMemoryBlockChain.getActualBlocksCount(), aMemoryBlockChain.size());
        this.mDataBlockIndexes = Utilities.ensureArray(this.mInputsCount, this.mDataBlockIndexes, 0);
        this.mDataBlockOffsets = Utilities.ensureArray(this.mInputsCount, this.mDataBlockOffsets, 0);
        this.mAddressBlockOffsets = Utilities.ensureArray(this.mInputsCount, this.mAddressBlockOffsets, 0);
    }

    @Override
    public void dispose() {
        this.reset();
        this.mTapeElementInputFactory.dispose();
    }

    protected void handleOffset(int theOffset, int theInputId, MemoryBlock theMemoryBlock) {
        int aDataBlockIndex = theMemoryBlock.getInt(theOffset);
        int aDataBlockOffset = theMemoryBlock.getInt(theOffset + 4);
        this.mDataBlockIndexes[theInputId] = aDataBlockIndex;
        this.mDataBlockOffsets[theInputId] = aDataBlockOffset;
        int n = theInputId;
        this.mAddressBlockOffsets[n] = this.mAddressBlockOffsets[n] + this.slotSize();
    }

    protected int slotSize() {
        return 8;
    }
}

