/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.search.multiple;

import com.complexible.memory.accessor.ByteAccessor;
import com.complexible.memory.accessor.impl.ByteOrderUtil;
import com.complexible.memory.structure.search.BaseBinarySearcher;
import com.complexible.memory.structure.search.multiple.DoubleLongSortedArrayBinarySearcher;
import com.complexible.memory.structure.sort.DoubleLongSortOrder;
import com.complexible.memory.structure.sort.SortOrder;
import com.complexible.memory.util.Utilities;
import java.io.IOException;

public class DoubleLongBinarySearcher
extends BaseBinarySearcher
implements DoubleLongSortedArrayBinarySearcher {
    private final int mOffset;
    private final int mOffset1;
    private long mPivot;
    private long mPivot1;
    private final byte[] mBuffer = new byte[16];

    public DoubleLongBinarySearcher(SortOrder theDirection, DoubleLongSortOrder theSortOrder) {
        super(theDirection);
        this.mOffset = theSortOrder.getOffset();
        this.mOffset1 = theSortOrder.getOffset1();
    }

    @Override
    protected int compare(long theSlotNumber) {
        try {
            int aOffset1;
            long aPosition = Utilities.multiplyLongPowerOfTwoAsLong(theSlotNumber, 4);
            this.mIndex.getSource().setPosition(aPosition + (long)this.mOffset);
            int aComp = Long.compare(this.mPivot, this.mIndex.getSource().readLong());
            if (aComp == 0 && (aOffset1 = this.mOffset1) >= 0) {
                this.mIndex.getSource().setPosition(aPosition + (long)aOffset1);
                aComp = Long.compare(this.mPivot1, this.mIndex.getSource().readLong());
            }
            return aComp;
        }
        catch (IOException theE) {
            throw Utilities.rethrow(theE);
        }
    }

    @Override
    public long search(long theStartSlotNumber, long theLongValue, long theLongValue1, long theSlotCount, boolean theReturnIfOutOfRange) {
        boolean theUseBigEndian = ByteOrderUtil.IS_SYSTEM_BIG_ENDIAN;
        ByteOrderUtil.writeLong(ByteAccessor.BYTE_ARRAY_BYTE_ACCESSOR, this.mBuffer, 0L, theLongValue, theUseBigEndian);
        ByteOrderUtil.writeLong(ByteAccessor.BYTE_ARRAY_BYTE_ACCESSOR, this.mBuffer, 8L, theLongValue1, theUseBigEndian);
        this.mPivot = ByteOrderUtil.readLong(ByteAccessor.BYTE_ARRAY_BYTE_ACCESSOR, this.mBuffer, this.mOffset, theUseBigEndian);
        this.mPivot1 = ByteOrderUtil.readLong(ByteAccessor.BYTE_ARRAY_BYTE_ACCESSOR, this.mBuffer, this.mOffset1, theUseBigEndian);
        return this.binarySearch(theStartSlotNumber, theSlotCount, theReturnIfOutOfRange, this.mBinarySlotComparator);
    }
}

