/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.search;

import com.complexible.memory.structure.search.BaseBinarySearcher;
import com.complexible.memory.structure.search.multiple.LongSortedArrayBinarySearcher;
import com.complexible.memory.structure.sort.LongComparator;
import com.complexible.memory.structure.sort.SortOrder;
import com.complexible.memory.util.Utilities;
import java.io.IOException;

public class LongOptimizedBinarySearcher
extends BaseBinarySearcher
implements LongSortedArrayBinarySearcher {
    private long mPivot;
    private final LongComparator mComparator;
    private static final int SLOT_SIZE_BIT_POSITION = 4;

    public LongOptimizedBinarySearcher(SortOrder theDirection, LongComparator comp) {
        super(theDirection);
        this.mComparator = comp;
    }

    @Override
    public long search(long theStartSlotNumber, long theValue, long theSlotCount, boolean theReturnIfOutOfRange) {
        this.mPivot = theValue;
        return this.binarySearch(theStartSlotNumber, theSlotCount, theReturnIfOutOfRange, this.mBinarySlotComparator);
    }

    @Override
    protected int compare(long theSlotNumber) {
        try {
            long aPosition = Utilities.multiplyLongPowerOfTwoAsLong(theSlotNumber, 4) + 8L;
            this.mIndex.getSource().setPosition(aPosition);
            return this.mComparator.compare(this.mPivot, this.mIndex.getSource().readLong());
        }
        catch (IOException theE) {
            throw Utilities.rethrow(theE);
        }
    }
}

