/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.search;

import com.complexible.common.io.ByteReader;
import com.complexible.memory.file.FileReader;
import com.complexible.memory.memoryblock.MemoryBlockChain;
import com.complexible.memory.memoryblock.MemoryBlockChainFactory;
import com.complexible.memory.memoryblock.MemoryContext;
import com.complexible.memory.structure.Comparator;
import com.complexible.memory.structure.impl.array.sorted.index.BinaryIndex;
import com.complexible.memory.structure.impl.hashtable.context.ConventionalHashTableContext;
import com.complexible.memory.structure.input.TapeElementInput;
import com.complexible.memory.structure.search.BaseConventionalDiskBinarySearcher;
import com.complexible.memory.structure.search.ConventionalHashTableBinarySearcher;
import com.complexible.memory.structure.sort.SortOrder;
import com.complexible.memory.util.Utilities;
import java.io.IOException;
import java.util.function.Supplier;

public final class HashTableDiskBinarySearcher
extends BaseConventionalDiskBinarySearcher
implements ConventionalHashTableBinarySearcher {
    private final ByteReader mMemoryIndex;
    private TapeElementInput mTapeElementInput;
    private ConventionalHashTableContext mHashTableContext;

    public HashTableDiskBinarySearcher(MemoryContext theMemoryContext, FileReader theDataFileReader, ByteReader theMemoryIndex, Supplier<MemoryBlockChain> theDataMemoryBlockChainSupplier, MemoryBlockChainFactory theMemoryBlockChainFactory, Comparator theComparator) {
        super(theMemoryContext, theDataFileReader, theDataMemoryBlockChainSupplier, theMemoryBlockChainFactory, SortOrder.ASC, theComparator);
        this.mMemoryIndex = theMemoryIndex;
    }

    @Override
    public void init(BinaryIndex theIndex) {
        this.mIndex = theIndex;
    }

    @Override
    public long search(ConventionalHashTableContext theHashTableContext, long theSlotCount) {
        this.mHashTableContext = theHashTableContext;
        return super.search0(0L, theHashTableContext.getKeyReader(), theSlotCount, true, false);
    }

    @Override
    public boolean equal(ConventionalHashTableContext theHashTableContext, long theSlotNumber) {
        this.mHashTableContext = theHashTableContext;
        return this.compare(theSlotNumber) == 0;
    }

    @Override
    public TapeElementInput getActualTapeElementInput() {
        return this.mTapeElementInput;
    }

    @Override
    protected int compare(long theSlotNumber) {
        long aDiskPosition = this.getPartitionDiskIndexPosition(theSlotNumber);
        long aMemoryPosition = this.getPartitionMemoryIndexPosition(theSlotNumber);
        try {
            int aPartitionHashCode = this.readPartitionHashCode(aMemoryPosition, aDiskPosition);
            int aCmpResult = Integer.compare(this.mHashTableContext.getCachedPartitionHashCode(), aPartitionHashCode);
            if (aCmpResult != 0) {
                return aCmpResult;
            }
            int aHashCode = this.readHashCode(aMemoryPosition, aDiskPosition);
            aCmpResult = Integer.compare(this.mHashTableContext.getCachedHashCode(), aHashCode);
            if (aCmpResult != 0) {
                return aCmpResult;
            }
            this.mIndex.getSource().setPosition(aDiskPosition);
            long aAddress = this.mIndex.getSource().readLong();
            this.mTapeElementInput = this.mIndexResourceProvider.getDataInput(aAddress + 16L);
            this.mPivot.setPosition(0L);
            return this.mComparator.compare(this.mPivot, this.mTapeElementInput);
        }
        catch (IOException theE) {
            throw Utilities.rethrow(theE);
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.mTapeElementInput = null;
    }

    private int readHashCode(long theMemoryPosition, long theDiskPosition) throws IOException {
        if (theMemoryPosition < this.mMemoryIndex.length()) {
            this.mMemoryIndex.setPosition(theMemoryPosition);
            return this.mMemoryIndex.readInt();
        }
        this.mIndex.getSource().setPosition(theDiskPosition + 8L);
        return this.mIndex.getSource().readInt();
    }

    private int readPartitionHashCode(long theMemoryPosition, long theDiskPosition) throws IOException {
        if (theMemoryPosition < this.mMemoryIndex.length()) {
            this.mMemoryIndex.setPosition(theMemoryPosition + 4L);
            return this.mMemoryIndex.readInt();
        }
        this.mIndex.getSource().setPosition(theDiskPosition + 12L);
        return this.mIndex.getSource().readInt();
    }

    private long getPartitionMemoryIndexPosition(long theSlotNumber) {
        long aPreviouslySpilledBytes = this.getTotalSpilledBytesPerPartition();
        long aDiskSlotCount = aPreviouslySpilledBytes / 24L;
        return Utilities.multiplyLongPowerOfTwoAsLong(aDiskSlotCount + theSlotNumber, 3);
    }

    private long getPartitionDiskIndexPosition(long theSlotNumber) {
        return this.getTotalSpilledBytesPerPartition() + theSlotNumber * 24L;
    }

    private long getTotalSpilledBytesPerPartition() {
        if (this.mHashTableContext.getPartition() != null) {
            return this.mHashTableContext.getPartition().getHeader().getLong(16L);
        }
        return 0L;
    }
}

