/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.search;

import com.complexible.common.io.ByteReader;
import com.complexible.common.io.ObjectReader;
import com.complexible.memory.memoryblock.MemoryBlockChain;
import com.complexible.memory.memoryblock.MemoryContext;
import com.complexible.memory.structure.Comparator;
import com.complexible.memory.structure.input.TapeElementInput;
import com.complexible.memory.structure.input.TapeElementInputFactory;
import com.complexible.memory.structure.input.impl.DefaultTapeElementInputFactory;
import com.complexible.memory.structure.search.ConventionalBinarySearcher;
import com.complexible.memory.structure.search.SortedArrayBinarySearcher;
import com.complexible.memory.structure.sort.SortOrder;
import com.complexible.memory.util.Utilities;
import java.io.IOException;
import java.util.function.Supplier;

public final class ConventionalMemoryBinarySearcher
extends ConventionalBinarySearcher
implements SortedArrayBinarySearcher {
    private final TapeElementInputFactory mTapeElementInputFactory;
    private final Supplier<MemoryBlockChain> mMemoryBlockChainObjectSupplier;

    public ConventionalMemoryBinarySearcher(MemoryContext theMemoryContext, Supplier<MemoryBlockChain> theMemoryBlockChainObjectSupplier, SortOrder theSortOrder, Comparator theComparator) {
        super(theMemoryContext, theSortOrder, theComparator);
        this.mMemoryBlockChainObjectSupplier = theMemoryBlockChainObjectSupplier;
        this.mTapeElementInputFactory = new DefaultTapeElementInputFactory(theMemoryContext);
    }

    @Override
    public long search(long theStartSlotNumber, ByteReader theByteReader, long theSlotCount, boolean theReturnIfOutOfRange) {
        return super.search0(theStartSlotNumber, theByteReader, theSlotCount, theReturnIfOutOfRange);
    }

    @Override
    public <T> long search(long theStartSlotNumber, T theElement, java.util.Comparator<T> theComparator, ObjectReader theObjectReader, long theSlotCount, boolean theReturnIfOutOfRange) {
        return this.search0(theStartSlotNumber, theElement, theComparator, theObjectReader, theSlotCount, theReturnIfOutOfRange);
    }

    @Override
    protected TapeElementInput getDataInput(long theIndexPosition) {
        try {
            this.mIndex.getSource().setPosition(theIndexPosition);
            int aIndex = this.mIndex.getSource().readInt();
            int aOffset = this.mIndex.getSource().readInt();
            return this.mTapeElementInputFactory.createMemoryInput(this.mMemoryBlockChainObjectSupplier.get(), aOffset, aIndex);
        }
        catch (IOException theE) {
            throw Utilities.rethrow(theE);
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.mTapeElementInputFactory.dispose();
    }
}

