/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.input.impl;

import com.complexible.common.base.Disposable;
import com.complexible.common.base.Disposables;
import com.complexible.common.io.ByteReader;
import com.complexible.memory.structure.input.TapeElementInput;
import com.complexible.memory.structure.input.TapeElementInputFactory;
import com.complexible.memory.util.Utilities;
import java.io.IOException;

public final class ByteReaderInput
implements TapeElementInput,
Disposable {
    private ByteReader mByteReader;

    public ByteReaderInput() {
        Disposables.markCreated((Object)this);
    }

    @Override
    public long getElementLength() {
        try {
            return this.mByteReader.length();
        }
        catch (IOException theE) {
            throw Utilities.rethrow(theE);
        }
    }

    public int read(byte[] theData, int offset, int length) throws IOException {
        return this.mByteReader.read(theData, offset, length);
    }

    public int readNative(long address, int length) throws IOException {
        return this.mByteReader.readNative(address, length);
    }

    @Override
    public int readInt() {
        try {
            return this.mByteReader.readInt();
        }
        catch (IOException theE) {
            throw Utilities.rethrow(theE);
        }
    }

    @Override
    public byte readByte() {
        try {
            return this.mByteReader.readByte();
        }
        catch (IOException theE) {
            throw Utilities.rethrow(theE);
        }
    }

    @Override
    public long readLong() {
        try {
            return this.mByteReader.readLong();
        }
        catch (IOException theE) {
            throw Utilities.rethrow(theE);
        }
    }

    @Override
    public int readInt(long offset) {
        try {
            this.mByteReader.setPosition(this.mByteReader.getPosition() + offset);
            return this.mByteReader.readInt();
        }
        catch (IOException theE) {
            throw Utilities.rethrow(theE);
        }
    }

    @Override
    public byte readByte(long offset) {
        try {
            this.mByteReader.setPosition(this.mByteReader.getPosition() + offset);
            return this.mByteReader.readByte();
        }
        catch (IOException theE) {
            throw Utilities.rethrow(theE);
        }
    }

    @Override
    public long readLong(long offset) {
        try {
            this.mByteReader.setPosition(this.mByteReader.getPosition() + offset);
            return this.mByteReader.readLong();
        }
        catch (IOException theE) {
            throw Utilities.rethrow(theE);
        }
    }

    @Override
    public long readBuffer(long[] theBuffer, long offset, long length) {
        try {
            return this.mByteReader.readBuffer(theBuffer, offset, length);
        }
        catch (IOException theE) {
            throw Utilities.rethrow(theE);
        }
    }

    @Override
    public long readBuffer(char[] theBuffer, long offset, long length) {
        return this.mByteReader.readBuffer(theBuffer, offset, length);
    }

    @Override
    public int readBuffer(byte[] theHeader, int length) {
        return this.readBuffer(theHeader, 0, length);
    }

    @Override
    public int readBuffer(byte[] theHeader, int offset, int length) {
        try {
            return this.mByteReader.read(theHeader, offset, length);
        }
        catch (IOException theE) {
            throw Utilities.rethrow(theE);
        }
    }

    @Override
    public long address() {
        return 0L;
    }

    public long getPosition() throws IOException {
        return this.mByteReader.getPosition();
    }

    public void setPosition(long thePosition) throws IOException {
        this.mByteReader.setPosition(thePosition);
    }

    @Override
    public void reset() {
        try {
            this.mByteReader.setPosition(0L);
        }
        catch (IOException theE) {
            throw Utilities.rethrow(theE);
        }
    }

    @Override
    public <T extends TapeElementInput> T cloneInput(TapeElementInputFactory<T> theTapeElementInputFactory) {
        throw new UnsupportedOperationException("unsupported");
    }

    public void init(ByteReader theByteReader) {
        this.mByteReader = theByteReader;
        this.reset();
    }

    public void dispose() {
        Disposables.markReleased((Object)this);
        this.mByteReader = null;
    }
}

