/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.input;

import com.complexible.common.io.ByteReader;
import com.complexible.memory.accessor.ByteAccessor;
import com.complexible.memory.accessor.impl.ByteOrderUtil;
import com.complexible.memory.structure.input.TapeElementInputFactory;

public interface TapeElementInput
extends ByteReader {
    public long getElementLength();

    public int readInt();

    public byte readByte();

    public long readLong();

    public int readInt(long var1);

    public byte readByte(long var1);

    public long readLong(long var1);

    public long readBuffer(long[] var1, long var2, long var4);

    public long readBuffer(char[] var1, long var2, long var4);

    public int readBuffer(byte[] var1, int var2);

    public int readBuffer(byte[] var1, int var2, int var3);

    public long address();

    public void reset();

    default public void finish() {
    }

    default public long length() {
        return this.getElementLength();
    }

    default public int read(byte[] theData) {
        return this.readBuffer(theData, 0, theData.length);
    }

    default public int readVInt() {
        return this.readInt();
    }

    default public long readVLong() {
        return this.readLong();
    }

    default public double readDouble() {
        return ByteOrderUtil.readDouble(ByteAccessor.BYTE_READER_BYTE_ACCESSOR, this, 0L, ByteOrderUtil.IS_SYSTEM_BIG_ENDIAN);
    }

    default public float readFloat() {
        return ByteOrderUtil.readFloat(ByteAccessor.BYTE_READER_BYTE_ACCESSOR, this, 0L, ByteOrderUtil.IS_SYSTEM_BIG_ENDIAN);
    }

    default public short readShort() {
        return ByteOrderUtil.readShort(ByteAccessor.BYTE_READER_BYTE_ACCESSOR, this, 0L, ByteOrderUtil.IS_SYSTEM_BIG_ENDIAN);
    }

    default public String readString() {
        throw new UnsupportedOperationException();
    }

    default public long readBuffer(long[] theBuffer, long length) {
        return this.readBuffer(theBuffer, 0L, length);
    }

    public <T extends TapeElementInput> T cloneInput(TapeElementInputFactory<T> var1);
}

