/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.impl.tape.addressing.sort.impl;

import com.complexible.common.base.AutoCloser;
import com.complexible.common.base.Disposables;
import com.complexible.memory.accessor.MemoryAccessor;
import com.complexible.memory.accessor.MemoryBlockChainByteReaderWriter;
import com.complexible.memory.memoryblock.MemoryBlock;
import com.complexible.memory.memoryblock.MemoryBlockChainFactory;
import com.complexible.memory.memoryblock.MemoryContext;
import com.complexible.memory.structure.DataArea;
import com.complexible.memory.structure.OperationTracker;
import com.complexible.memory.structure.OperationType;
import com.complexible.memory.structure.impl.aggregator.accessor.MemoryBlockChainByteReaderWriterImpl;
import com.complexible.memory.structure.impl.tape.BaseDataMemoryTape;
import com.complexible.memory.structure.impl.tape.addressing.sort.MemorySortableTape;
import com.complexible.memory.structure.sort.sorters.quick.BaseSorter;
import com.complexible.memory.structure.sort.sorters.quick.SlotBaseQuickSorter;
import com.complexible.memory.util.SpillingUtil;
import com.complexible.memory.util.Utilities;

abstract class BaseSortableMemoryTape<TQ extends SlotBaseQuickSorter<MemoryBlockChainByteReaderWriter>, D extends DataArea>
extends BaseDataMemoryTape<D>
implements MemorySortableTape<D> {
    protected volatile boolean mBarrier = true;
    protected final MemoryBlockChainByteReaderWriterImpl mDataMemoryBlockChainAccessor = new MemoryBlockChainByteReaderWriterImpl(this.mTapeArea, this.mMemoryContext);

    protected BaseSortableMemoryTape(D theDataArea, MemoryContext theMemoryContext, MemoryBlockChainFactory theMemoryBlockChainFactory) {
        super(theDataArea, theMemoryContext, theMemoryBlockChainFactory);
    }

    protected abstract TQ getTogetherQuickSorter();

    protected abstract long getMemoryElementsCount();

    protected MemoryAccessor getHeaderMemoryAccessor() {
        return this.mTapeArea.get().get(0).getHeader();
    }

    @Override
    public void buildMemorySortedIndex(OperationTracker theOperationTracker) {
        try {
            theOperationTracker.onStart(OperationType.SORTING);
            this.sortMemoryBlocksDataTogether(theOperationTracker);
        }
        finally {
            this.mBarrier = true;
            theOperationTracker.onDone(OperationType.SORTING);
        }
    }

    @Override
    public boolean isDiskIndexBuilt() {
        return this.mBarrier && this.mTapeArea.get().getSpilledFile() != null && this.mTapeArea.get().getMemoryElementsCount() == 0L;
    }

    @Override
    public void disposeMemoryIndex() {
        this.unsetMemoryIndexByte(this.mTapeArea.get().get(0));
        this.mBarrier = true;
    }

    @Override
    public void disposeDiskIndex() {
        SpillingUtil.deleteFile(this.mTapeArea.get().getSpilledFile());
        this.mTapeArea.get().setSpilledFile(null);
        this.mBarrier = true;
    }

    @Override
    public void setMemoryIndexByte() {
        this.getHeaderMemoryAccessor().putByte(0L, Utilities.toByte(true));
        this.mBarrier = true;
    }

    @Override
    public void unsetMemoryIndexByte(MemoryBlock theMemoryBlock) {
        theMemoryBlock.getHeader().putByte(0L, Utilities.toByte(false));
        this.mBarrier = true;
    }

    @Override
    public boolean isMemoryIndexBuilt() {
        return this.mBarrier && !this.mTapeArea.isEmpty() && this.getHeaderMemoryAccessor().getByte(0L) == Utilities.toByte(true);
    }

    @Override
    public void checkIndex() {
        if (this.mBarrier && this.isMemoryIndexBuilt()) {
            this.disposeMemoryIndex();
        }
        if (this.isDiskIndexBuilt()) {
            this.disposeDiskIndex();
        }
    }

    @Override
    public void sortMemoryBlocksDataTogether(OperationTracker theOperationTracker) {
        if (this.isEmpty()) {
            return;
        }
        if (!this.isMemoryIndexBuilt()) {
            long aMemoryElementsCount = this.getMemoryElementsCount();
            if (aMemoryElementsCount > 0L) {
                TQ theQuickSorter = this.getTogetherQuickSorter();
                ((SlotBaseQuickSorter)theQuickSorter).gotoSource((MemoryBlockChainByteReaderWriterImpl)this.mDataMemoryBlockChainAccessor, theOperationTracker);
                ((BaseSorter)theQuickSorter).sort(0L, aMemoryElementsCount);
                this.setMemoryIndexByte();
            }
            this.mBarrier = true;
        }
    }

    @Override
    public void dispose() {
        AutoCloser.close((AutoCloseable[])new AutoCloseable[]{Disposables.asCloseable(this.getTogetherQuickSorter())});
    }

    @Override
    public void markDiskIndexBuilt() {
        this.mBarrier = true;
    }
}

