/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.impl.tape.addressing.hashtape.impl;

import com.complexible.memory.memoryblock.MemoryBlock;
import com.complexible.memory.memoryblock.MemoryBlockChain;
import com.complexible.memory.memoryblock.MemoryContext;
import com.complexible.memory.structure.impl.hashtable.PartitionsArea;
import com.complexible.memory.structure.impl.hashtable.context.HashTableContext;
import com.complexible.memory.structure.impl.tape.addressing.hashtape.MemoryHashTape;
import com.complexible.memory.structure.openaddressing.OpenAddressingTable;
import com.complexible.memory.util.Utilities;

public final class HashTableUtil {
    public static final int RESIZE_LOAD_FACTOR = 2;
    public static final int DEFAULT_PARTITIONS_COUNT = 1;
    public static final int MAX_PARTITIONS_COUNT = 32768;

    private HashTableUtil() {
    }

    private static int calculatePartitionCountBasedOnMemory(MemoryContext theMemoryContext) {
        long aAvailableMemory = theMemoryContext.getAvailableMemory();
        if (aAvailableMemory >= 0x80000000L && (long)theMemoryContext.getBlockSize() <= 131072L) {
            return 32768;
        }
        int aResultLogarithm = Utilities.divideLongPowerOfTwoAsInt(Utilities.log2(aAvailableMemory), 2) + 1;
        return Math.min(Utilities.multiplyIntPowerOfTwoAsInt(1, aResultLogarithm), 32768);
    }

    public static int calculatePartitionCount(MemoryContext theMemoryContext, int theEstimatedKeysCount, int theOpenAddressingSlotSize) {
        int aMemoryBasedPartitionCount = HashTableUtil.calculatePartitionCountBasedOnMemory(theMemoryContext);
        if (theEstimatedKeysCount > 0) {
            int aMaxSlotsPerBlock = (int)((float)(theMemoryContext.getBlockSize() / theOpenAddressingSlotSize) * 1.0f);
            int aPartitionCount = Utilities.multiplyIntPowerOfTwoAsInt(1, Utilities.log2(theEstimatedKeysCount / aMaxSlotsPerBlock) + 1);
            return Math.max(Math.min(aPartitionCount, aMemoryBasedPartitionCount), 1);
        }
        return 1;
    }

    public static int calculateIntPartition(int thePartitionHashCode, int thePartitionCount) {
        if (thePartitionCount == 0) {
            return 0;
        }
        return (int)(Integer.toUnsignedLong(thePartitionHashCode) * Integer.toUnsignedLong(thePartitionCount) >>> 32);
    }

    public static int calculateLongPartition(long theValue, int aPartitionCount) {
        long aPartitionHash = HashTableUtil.jenkinsHash(theValue);
        return aPartitionCount > 0 ? (int)(Math.abs(aPartitionHash) % (long)aPartitionCount) : 0;
    }

    public static <M extends OpenAddressingTable<MemoryBlock>, H extends HashTableContext> boolean resizeHashTable(PartitionsArea thePartitionsArea, MemoryBlockChain theMemoryBlockChain, MemoryHashTape<M, H> theMemoryHashTape) {
        if (thePartitionsArea.isEmpty()) {
            return theMemoryHashTape.resize();
        }
        return theMemoryBlockChain.getTotalSpilledBytes() <= 0L && theMemoryHashTape.resize();
    }

    public static void markPartitionSlot(MemoryBlock thePartition, long theSlotCellAddress, long theSegmentAddress) {
        long aNegativeSegmentAddress = -theSegmentAddress;
        if (aNegativeSegmentAddress == -1L) {
            thePartition.putLong(theSlotCellAddress, Utilities.PRE_MIN_LONG_VALUE);
        } else if (theSegmentAddress > 0L) {
            thePartition.putLong(theSlotCellAddress, -theSegmentAddress);
        } else {
            thePartition.putLong(theSlotCellAddress, Long.MIN_VALUE);
        }
    }

    private static long rot(int x, int distance) {
        return x << distance | x >> 32 - distance;
    }

    private static long jenkinsHash(long theValue) {
        int c = -559038729;
        int b = -559038729;
        int a = -559038729;
        b += (byte)(theValue >> 56) << 24;
        b += (byte)(theValue >> 48) << 16;
        b += (byte)(theValue >> 40) << 8;
        a += (byte)(theValue >> 24) << 24;
        a += (byte)(theValue >> 16) << 16;
        a += (byte)(theValue >> 8) << 8;
        a += (byte)theValue;
        c ^= (b += (byte)(theValue >> 32));
        c = (int)((long)c - HashTableUtil.rot(b, 14));
        a ^= c;
        a = (int)((long)a - HashTableUtil.rot(c, 11));
        b ^= a;
        b = (int)((long)b - HashTableUtil.rot(a, 25));
        c ^= b;
        c = (int)((long)c - HashTableUtil.rot(b, 16));
        a ^= c;
        a = (int)((long)a - HashTableUtil.rot(c, 4));
        b ^= a;
        b = (int)((long)b - HashTableUtil.rot(a, 14));
        c ^= b;
        c = (int)((long)c - HashTableUtil.rot(b, 24));
        return (long)c | (long)b << 32;
    }
}

