/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.impl.tape.addressing.hashtape.impl;

import com.complexible.common.io.ByteReader;
import com.complexible.memory.memoryblock.DefaultMemoryBlockChain;
import com.complexible.memory.memoryblock.MemoryBlock;
import com.complexible.memory.memoryblock.MemoryBlockChain;
import com.complexible.memory.memoryblock.MemoryBlockChainFactory;
import com.complexible.memory.memoryblock.MemoryContext;
import com.complexible.memory.structure.Comparator;
import com.complexible.memory.structure.DataAreaAccessor;
import com.complexible.memory.structure.ObjectSupplier;
import com.complexible.memory.structure.impl.hashtable.PartitionsArea;
import com.complexible.memory.structure.impl.hashtable.comparator.HashComparator;
import com.complexible.memory.structure.impl.hashtable.comparator.MemoryHashComparator;
import com.complexible.memory.structure.impl.hashtable.context.ConventionalHashTableContext;
import com.complexible.memory.structure.impl.hashtable.context.impl.ConventionalHashTableContextImpl;
import com.complexible.memory.structure.impl.hashtable.input.DefaultHashTableTapeElementInput;
import com.complexible.memory.structure.impl.hashtable.openaddressing.DefaultOpenAddressingTable;
import com.complexible.memory.structure.impl.tape.addressing.hashtape.ConventionalMemoryHashTape;
import com.complexible.memory.structure.impl.tape.addressing.hashtape.impl.BaseMemoryHashTape;
import com.complexible.memory.structure.impl.tape.addressing.hashtape.impl.HashTableUtil;
import com.complexible.memory.structure.input.TapeElementInput;
import com.complexible.memory.structure.input.impl.DefaultTapeElementInputFactory;
import com.complexible.memory.structure.openaddressing.ConventionalOpenAddressingTable;
import com.complexible.memory.util.Utilities;
import java.io.IOException;
import java.util.function.Supplier;

public final class ConventionalMemoryHashTapeImpl
extends BaseMemoryHashTape<ConventionalOpenAddressingTable<MemoryBlock>, ConventionalHashTableContext>
implements ConventionalMemoryHashTape {
    private int mCachedHashCode;
    private boolean mKeyUniqueness;
    private int mPartitionCachedHashCode;
    private final Comparator mDefaultComparator;
    private final HashComparator mMemoryHashComparator;
    private final DataAreaAccessor mDataMemoryBlockChainAccessor;
    private final ObjectSupplier<Comparator> mComparatorHolder = new ObjectSupplier();
    private final DefaultOpenAddressingTable mOpenAddressingTable;
    private final DefaultOpenAddressingTable mDstOpenAddressingTable;
    private final DefaultOpenAddressingTable mSrcOpenAddressingTable;

    public ConventionalMemoryHashTapeImpl(PartitionsArea thePartitionsArea, MemoryContext theMemoryContext, int thePartitionCount, Comparator theDefaultComparator, DataAreaAccessor theDataAreaAccessor, MemoryBlockChainFactory theMemoryBlockChainFactory) {
        super(thePartitionsArea, theMemoryContext, thePartitionCount, theMemoryBlockChainFactory);
        this.mDefaultComparator = theDefaultComparator;
        this.mDataMemoryBlockChainAccessor = theDataAreaAccessor;
        this.mMemoryHashComparator = new MemoryHashComparator(this.mDataMemoryBlockChainAccessor, this.mDefaultComparator, this.mComparatorHolder, theMemoryContext);
        this.mOpenAddressingTable = this.createOpenAddressingTable();
        this.mDstOpenAddressingTable = this.createOpenAddressingTable();
        this.mSrcOpenAddressingTable = this.createOpenAddressingTable();
    }

    @Override
    public void calculateDefaultPartitionCount(int theEstimatedKeysCount) {
        super.calculateDefaultPartitionCount(theEstimatedKeysCount, 16);
    }

    private DefaultOpenAddressingTable createOpenAddressingTable() {
        return new DefaultOpenAddressingTable(this.mMemoryHashComparator, this.mMemoryContext.getBlockSize());
    }

    @Override
    public ConventionalOpenAddressingTable<MemoryBlock> getOpenAddressingTable() {
        return this.mOpenAddressingTable;
    }

    @Override
    protected ConventionalOpenAddressingTable<MemoryBlock> getDstOpenAddressingTable() {
        return this.mDstOpenAddressingTable;
    }

    @Override
    protected ConventionalOpenAddressingTable<MemoryBlock> getSourceOpenAddressingTable() {
        return this.mSrcOpenAddressingTable;
    }

    @Override
    protected boolean resizeSlot(int theSlotAddress, int theOldPartitionCount, int theOldOverFlowBlocksCount, int theNewPartitionCount, MemoryBlock theSourcePartition) {
        int aHashCodeCellAddress = this.mSrcOpenAddressingTable.getHashCodeCellAddress(theSlotAddress);
        int aPartitionHashCodeCellAddress = this.mSrcOpenAddressingTable.getPartitionHashCodeCellAddress(aHashCodeCellAddress);
        int aPartitionHashCode = theSourcePartition.getInt(aPartitionHashCodeCellAddress);
        int aDstPartitionId = HashTableUtil.calculateIntPartition(aPartitionHashCode, theNewPartitionCount);
        int aRealPartitionIdx = theOldPartitionCount + aDstPartitionId;
        MemoryBlock aDstPartition = this.checkPartitionSlotAvailable(this.mDstOpenAddressingTable, this.mPartitionsArea.getPartition(aRealPartitionIdx), aRealPartitionIdx, theOldOverFlowBlocksCount);
        if (aDstPartition == null) {
            return false;
        }
        int aHashCode = theSourcePartition.getInt(aHashCodeCellAddress);
        int aDstSlotAddress = this.mDstOpenAddressingTable.findAvailableSlot(aHashCode);
        aDstPartition.copyFromMemoryBlock(theSourcePartition, theSlotAddress, aDstSlotAddress, 16);
        this.mDstOpenAddressingTable.incrementSlotCount();
        return true;
    }

    @Override
    public int getHashCode() {
        return this.mCachedHashCode;
    }

    @Override
    public int getPartitionHashCode() {
        return this.mPartitionCachedHashCode;
    }

    @Override
    public void updatePartitionHashCode(MemoryBlock thePartition, int theHashCodeCellAddress) {
        if (theHashCodeCellAddress > 0) {
            int aPartitionHashCodeCellAddress = this.mOpenAddressingTable.getPartitionHashCodeCellAddress(theHashCodeCellAddress);
            thePartition.putInt(aPartitionHashCodeCellAddress, ((ConventionalHashTableContext)this.mHashTableContext).getCachedPartitionHashCode());
        }
    }

    @Override
    public void restoreHashTableContext() {
        super.restoreHashTableContext();
        ((ConventionalHashTableContext)this.mHashTableContext).setCachedHashCode(this.mCachedHashCode);
        ((ConventionalHashTableContext)this.mHashTableContext).setPartitionHashCode(this.mPartitionCachedHashCode);
    }

    @Override
    protected boolean isAddressingBasedResizePossible(int theAcquiredPartitionCount, int theNewPartitionCount) {
        return this.mOverFlowPartitionsArea.getMemoryBlocksCount() == 0 && theAcquiredPartitionCount >= theNewPartitionCount;
    }

    @Override
    protected boolean resizeUsingDataSpace(int theOldPartitionCount, int theOldOverFlowBlocksCount, int theNewPartitionCount, int theAcquiredPartitionCount) {
        this.releaseLastBlocks(this.mPartitionsArea, this.mPartitionsArea.getPartitionsCount() - theNewPartitionCount);
        this.resetArea(this.mPartitionsArea);
        this.resetArea(this.mOverFlowPartitionsArea);
        this.mOverFlowPartitionsArea.disposeMemory();
        boolean aResult = this.insertElements();
        if (!aResult) {
            this.restoreHashTable(theOldOverFlowBlocksCount, theAcquiredPartitionCount);
        }
        return aResult;
    }

    @Override
    public void initContext(ByteReader theKeyReader) {
        this.calculateHashCodes(theKeyReader);
        this.restoreHashTableContext();
        ((ConventionalHashTableContext)this.mHashTableContext).setKeyReader(theKeyReader);
    }

    @Override
    public void setComparator(Comparator theComparator) {
        this.mComparatorHolder.set(theComparator);
    }

    @Override
    public int calculatePartitionId() {
        return HashTableUtil.calculateIntPartition(this.mPartitionCachedHashCode, this.mPartitionsArea.getPartitionsCount());
    }

    @Override
    public Comparator getDefaultComparator() {
        return this.mDefaultComparator;
    }

    @Override
    public HashComparator getHashComparator() {
        return this.mMemoryHashComparator;
    }

    @Override
    public Supplier<Comparator> getComparatorHolder() {
        return this.mComparatorHolder;
    }

    @Override
    public Supplier<MemoryBlockChain> getDataMemoryBlockChainSupplier() {
        return this.mDataMemoryBlockChainAccessor;
    }

    @Override
    public void setUniquenessMode(boolean theKeyUniqueness) {
        this.mKeyUniqueness = theKeyUniqueness;
        this.mMemoryHashComparator.setUniquenessMode(theKeyUniqueness);
    }

    @Override
    protected ConventionalHashTableContext createHashTableContext() {
        return new ConventionalHashTableContextImpl();
    }

    @Override
    public void dispose() {
        super.dispose();
        this.mComparatorHolder.set(null);
        this.mMemoryHashComparator.dispose();
        this.mOpenAddressingTable.setMemoryAccessor(null);
        this.mDstOpenAddressingTable.setMemoryAccessor(null);
    }

    private boolean insertElements() {
        Comparator aComparator = this.mComparatorHolder.get(this.mDefaultComparator);
        DefaultTapeElementInputFactory factory = new DefaultTapeElementInputFactory(this.mMemoryContext);
        DefaultHashTableTapeElementInput hashInput = new DefaultHashTableTapeElementInput();
        hashInput.setUniquenessMode(this.mKeyUniqueness);
        DefaultMemoryBlockChain data = this.mDataMemoryBlockChainAccessor.get();
        long elementsCount = data.getMemoryElementsCount();
        long offset = 0L;
        while (elementsCount-- > 0L) {
            long length;
            TapeElementInput input = factory.createMemoryInput(data, Utilities.maskLongPowerOfTwoAsInt(offset, this.mMemoryContext.getBlockSizeMask()), Utilities.divideLongPowerOfTwoAsInt(offset, this.mMemoryContext.getBlockSizeBitPosition()));
            byte isHeader = input.readByte((length = input.getElementLength()) - 1L);
            hashInput.setElementHeader(isHeader == 1);
            hashInput.setDelegate(input);
            if (!this.insertNextResized(aComparator, hashInput)) {
                return false;
            }
            offset += length + 8L;
        }
        return true;
    }

    private boolean insertNextResized(Comparator theComparator, TapeElementInput theTapeElementInput) {
        Utilities.resetByteReader(theTapeElementInput);
        int aHashCode = theComparator.getHasher().hash(theTapeElementInput);
        Utilities.resetByteReader(theTapeElementInput);
        int aPartitionHashCode = theComparator.getPartitionHasher().hash(theTapeElementInput);
        int aPartitionId = HashTableUtil.calculateIntPartition(aPartitionHashCode, this.mPartitionsArea.getPartitionsCount());
        long aElementAddress = theTapeElementInput.address();
        MemoryBlock aCurrentPartition = this.checkPartitionSlotAvailable(this.mOpenAddressingTable, this.mPartitionsArea.getPartition(aPartitionId), aPartitionId, 0);
        if (aCurrentPartition == null) {
            return false;
        }
        int aHashCodeCellAddress = this.mOpenAddressingTable.putIfAbsent(aElementAddress, aHashCode);
        if (aHashCodeCellAddress < 0) {
            if (this.mKeyUniqueness) {
                return true;
            }
            this.mergeResizingElements(aElementAddress, aCurrentPartition, aHashCodeCellAddress);
            return true;
        }
        int aPartitionHashCodeCellAddress = this.mOpenAddressingTable.getPartitionHashCodeCellAddress(aHashCodeCellAddress);
        aCurrentPartition.putInt(aPartitionHashCodeCellAddress, aPartitionHashCode);
        return true;
    }

    private void mergeResizingElements(long theElementAddress, MemoryBlock theCurrentPartition, int theHashCodeCellAddress) {
        long aSegmentCellAddress = ConventionalOpenAddressingTable.getSegmentCellAddress(Math.abs(theHashCodeCellAddress));
        long aElementLength = this.mDataMemoryBlockChainAccessor.readLong(theElementAddress);
        long aModeAddress = this.getHeaderAddress(theElementAddress, aElementLength);
        byte isHeader = this.mDataMemoryBlockChainAccessor.readByte(aModeAddress);
        if (isHeader != 1) {
            return;
        }
        long aHeadElementCountElementAddress = this.mergeElements(theElementAddress, theCurrentPartition, aSegmentCellAddress, aElementLength);
        this.mDataMemoryBlockChainAccessor.writeByte(aModeAddress, (byte)2);
        long aRealElementLength = aElementLength - 24L - 1L;
        long aElementCountElementAddress = theElementAddress + aRealElementLength + 24L;
        long aNewValueCount = this.mDataMemoryBlockChainAccessor.readLong(aHeadElementCountElementAddress) + this.mDataMemoryBlockChainAccessor.readLong(aElementCountElementAddress);
        this.mDataMemoryBlockChainAccessor.writeLong(aHeadElementCountElementAddress, aNewValueCount);
    }

    private long getHeaderAddress(long theElementAddress, long theElementLength) {
        return theElementAddress + 8L + theElementLength - 1L;
    }

    @Override
    public long mergeElements(long theElementAddress, MemoryBlock theCurrentPartition, long theSegmentCellAddress, long theElementLength) {
        long aHeadElementAddress = theCurrentPartition.getLong(theSegmentCellAddress);
        long aRealHeadElementLength = this.mDataMemoryBlockChainAccessor.readLong(aHeadElementAddress) - 24L - 1L;
        long aHeadElementLastElementAddress = aHeadElementAddress + aRealHeadElementLength + 16L;
        long aLastElementAddress = this.mDataMemoryBlockChainAccessor.readLong(aHeadElementLastElementAddress);
        long aLastElementLength = this.mDataMemoryBlockChainAccessor.readLong(aLastElementAddress);
        byte aHeaderMode = this.mDataMemoryBlockChainAccessor.readByte(this.getHeaderAddress(aLastElementAddress, aLastElementLength));
        boolean isHeadLast = aLastElementAddress == aHeadElementAddress;
        long aRealLastElementLength = this.getLastElementLength(aRealHeadElementLength, aLastElementAddress, aHeaderMode, isHeadLast);
        this.mDataMemoryBlockChainAccessor.writeLong(aLastElementAddress + aRealLastElementLength + 8L, theElementAddress);
        this.mDataMemoryBlockChainAccessor.writeLong(aHeadElementAddress + aRealHeadElementLength + 16L, theElementAddress);
        return aHeadElementAddress + aRealHeadElementLength + 24L;
    }

    private long getLastElementLength(long theRealHeadElementLength, long theLastElementAddress, byte theHeaderMode, boolean theIsHeadLast) {
        if (theIsHeadLast) {
            return theRealHeadElementLength;
        }
        if (theHeaderMode == 2) {
            return this.mDataMemoryBlockChainAccessor.readLong(theLastElementAddress) - 24L - 1L;
        }
        return this.mDataMemoryBlockChainAccessor.readLong(theLastElementAddress) - 8L - 1L;
    }

    private void restoreHashTable(int theOldOverFlowBlocksCount, int theAcquiredPartitionCount) {
        this.releaseLastBlocks(this.mPartitionsArea, theAcquiredPartitionCount);
        this.releaseLastBlocks(this.mOverFlowPartitionsArea, this.mOverFlowPartitionsArea.getMemoryBlocksCount() - theOldOverFlowBlocksCount);
        this.resetArea(this.mPartitionsArea);
        this.resetArea(this.mOverFlowPartitionsArea);
        if (!this.insertElements()) {
            throw new IllegalStateException("Fatal error: unable to restore HashTable");
        }
    }

    private static void assertPosZero(ByteReader theByteReader) {
        try {
            assert (theByteReader.getPosition() == 0L);
        }
        catch (IOException e) {
            throw Utilities.rethrow(e);
        }
    }

    private void calculateHashCodes(ByteReader theReader) {
        int aCachedPartitionHashCode;
        ConventionalMemoryHashTapeImpl.assertPosZero(theReader);
        Comparator aComparator = this.mComparatorHolder.get(this.mDefaultComparator);
        this.mCachedHashCode = aComparator.getHasher().hash(theReader);
        Utilities.resetByteReader(theReader);
        this.mPartitionCachedHashCode = aCachedPartitionHashCode = aComparator.getPartitionHasher().hash(theReader);
        this.mPartitionId = HashTableUtil.calculateIntPartition(aCachedPartitionHashCode, this.mPartitionsArea.getPartitionsCount());
        this.mCurrentPartition = this.getPartition(this.mPartitionId);
        this.mOpenAddressingTable.setMemoryAccessor(this.mCurrentPartition);
    }

    @Override
    public PartitionsArea getTapeArea() {
        return this.mPartitionsArea;
    }
}

