/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.impl.tape.addressing.hashtape;

import com.complexible.memory.memoryblock.MemoryBlock;
import com.complexible.memory.structure.impl.hashtable.PartitionsArea;
import com.complexible.memory.structure.impl.hashtable.context.HashTableContext;
import com.complexible.memory.structure.impl.tape.MemoryBlockAddressArea;
import com.complexible.memory.structure.impl.tape.addressing.MemoryAddressingTape;
import com.complexible.memory.structure.openaddressing.OpenAddressingTable;

public interface MemoryHashTape<M extends OpenAddressingTable<MemoryBlock>, H extends HashTableContext>
extends MemoryAddressingTape<PartitionsArea> {
    public boolean resize();

    public int calculatePartitionId();

    public int getPartitionId();

    public MemoryBlock getPartition();

    public M getOpenAddressingTable();

    default public M getInitiatedOpenAddressingTable() {
        MemoryBlock aOpenAddressingTable = this.getOpenAddressingTable();
        aOpenAddressingTable.setMemoryAccessor((MemoryBlock)this.getPartition());
        return (M)aOpenAddressingTable;
    }

    public void resetPartition(MemoryBlock var1);

    public void resetPartitions();

    public H getHashTableContext();

    public void restoreHashTableContext();

    public MemoryBlock getPartition(int var1);

    public MemoryBlockAddressArea getOverFlowPartitionsArea();

    public void calculateDefaultPartitionCount(int var1);

    default public boolean checkExpansionThreshold() {
        MemoryBlock aPartition = this.getPartition();
        if (aPartition == null) {
            return false;
        }
        MemoryBlock aOpenAddressingTable = this.getOpenAddressingTable();
        aOpenAddressingTable.setMemoryAccessor((MemoryBlock)aPartition);
        return aOpenAddressingTable.checkExpansionThreshold();
    }

    default public void resetPartitionPayLoad(MemoryBlock theAddressPartition) {
        MemoryBlock aOpenAddressingTable = this.getOpenAddressingTable();
        aOpenAddressingTable.setMemoryAccessor((MemoryBlock)theAddressPartition);
        aOpenAddressingTable.setPayLoad(-1L);
    }
}

