/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.impl.tape;

import com.complexible.common.io.ByteReader;
import com.complexible.common.io.ByteWriter;
import com.complexible.common.io.ObjectWriter;
import com.complexible.common.io.ObjectWriterFactory;
import com.complexible.memory.accessor.ByteAccessor;
import com.complexible.memory.accessor.impl.ByteOrderUtil;
import com.complexible.memory.memoryblock.MemoryBlock;
import com.complexible.memory.memoryblock.MemoryBlockChain;
import com.complexible.memory.memoryblock.MemoryBlockChainFactory;
import com.complexible.memory.memoryblock.MemoryContext;
import com.complexible.memory.structure.DataAreaAccessor;
import com.complexible.memory.structure.impl.tape.BaseBlockArea;
import com.complexible.memory.structure.impl.tape.BlockListener;
import com.complexible.memory.structure.impl.tape.OutOfMemoryException;
import com.complexible.memory.util.Utilities;
import com.google.common.base.Charsets;
import java.io.IOException;

public final class MemoryBlocksDataArea
extends BaseBlockArea
implements DataAreaAccessor {
    private final int mBlockSize;
    private final int mBlockSizeMask;
    private final boolean mUseBigEndian;
    private final int mBlockSizeBitPosition;
    private final byte[] mBuffer = new byte[8];
    private final BlockListener mListener;

    public MemoryBlocksDataArea(MemoryBlockChainFactory theMemoryBlockChainFactory, BlockListener theListener) {
        super(theMemoryBlockChainFactory);
        MemoryContext ctx = theMemoryBlockChainFactory.context();
        this.mBlockSize = ctx.getBlockSize();
        this.mUseBigEndian = ctx.isUseBigEndian();
        this.mBlockSizeMask = ctx.getBlockSizeMask();
        this.mBlockSizeBitPosition = ctx.getBlockSizeBitPosition();
        this.mListener = theListener;
    }

    public MemoryBlocksDataArea(MemoryBlockChainFactory theMemoryBlockChainFactory) {
        this(theMemoryBlockChainFactory, null);
    }

    @Override
    public void appendBytes(ByteReader theReader) throws IOException {
        int aBytesToCopy;
        long aRemaining;
        theReader.setPosition(0L);
        this.appendLong(aRemaining);
        if (aRemaining <= 0L) {
            return;
        }
        int aDstOffset = this.mMemoryBlockChain.currentBlockOffset();
        for (aRemaining = theReader.length(); aRemaining > 0L; aRemaining -= (long)aBytesToCopy) {
            MemoryBlock aMemoryBlock = this.mMemoryBlockChain.current();
            if (aMemoryBlock == null) {
                aMemoryBlock = this.acquireNextBlockForWrite();
            }
            aBytesToCopy = (int)Math.min(aRemaining, (long)(this.blockSize() - aDstOffset));
            aMemoryBlock.copyFromReader(theReader, aDstOffset, aBytesToCopy);
            if ((aDstOffset += aBytesToCopy) < this.blockSize()) continue;
            aDstOffset = Utilities.maskIntPowerOfTwoAsInt(aDstOffset, this.blockSizeMask());
            this.mMemoryBlockChain.incrementCurrentBlockIndex();
        }
        this.mMemoryBlockChain.setCurrentBlockOffset(aDstOffset);
        this.refreshActualBlocks(this.mMemoryBlockChain);
    }

    @Override
    public <T> void appendBytes(T theObject, ObjectWriterFactory<T> theFactory) throws IOException {
        long aPosition = this.getPosition();
        this.appendLong(0L);
        ObjectWriter aObjectWriter = theFactory.writer((ByteWriter)this);
        aObjectWriter.write(theObject);
        long elemLength = this.getPosition() - aPosition - 8L;
        this.writeLong(aPosition, elemLength);
        this.refreshActualBlocks(this.mMemoryBlockChain);
    }

    @Override
    public void appendByte(byte theValue) {
        int aDstOffset = this.mMemoryBlockChain.currentBlockOffset();
        MemoryBlock aMemoryBlock = this.mMemoryBlockChain.current();
        if (aMemoryBlock == null) {
            this.acquireNextBlockForWrite().putByte(aDstOffset, theValue);
            this.setAcquiredBlockOffset(1);
            return;
        }
        int availableForBlock = this.blockSize() - aDstOffset;
        if (availableForBlock > 0) {
            aMemoryBlock.putByte(aDstOffset, theValue);
            this.stepToNextOffset(this.mMemoryBlockChain, 1);
            return;
        }
        this.acquireNextBlockForWrite().putByte(0L, theValue);
        this.setAcquiredBlockOffset(1);
    }

    @Override
    public byte readByte(long theLocalMemoryAddress) {
        int aSrcBlockOffset = Utilities.maskLongPowerOfTwoAsInt(theLocalMemoryAddress, this.blockSizeMask());
        int aSrcBlockIndex = Utilities.divideLongPowerOfTwoAsInt(theLocalMemoryAddress, this.blockSizeBitPosition());
        return this.readByte(aSrcBlockIndex, aSrcBlockOffset);
    }

    @Override
    public byte readByte(int theBlockIndex, int theBlockOffset) {
        MemoryBlock aMemoryBlock = this.mMemoryBlockChain.get(theBlockIndex);
        return aMemoryBlock.getByte(theBlockOffset);
    }

    @Override
    public void appendLong(long theValue) {
        int aDstOffset = this.mMemoryBlockChain.currentBlockOffset();
        MemoryBlock aMemoryBlock = this.mMemoryBlockChain.current();
        if (aMemoryBlock == null) {
            this.acquireNextBlockForWrite().putLong(aDstOffset, theValue);
            this.setAcquiredBlockOffset(8);
            return;
        }
        int availableForBlock = this.blockSize() - aDstOffset;
        if (availableForBlock >= 8) {
            aMemoryBlock.putLong(aDstOffset, theValue);
            this.stepToNextOffset(this.mMemoryBlockChain, 8);
            return;
        }
        ByteOrderUtil.writeLong(ByteAccessor.BYTE_ARRAY_BYTE_ACCESSOR, this.mBuffer, 0L, theValue, this.mUseBigEndian);
        aMemoryBlock.copyFromByteArray(this.mBuffer, 0, aDstOffset, availableForBlock);
        this.acquireNextBlockForWrite().copyFromByteArray(this.mBuffer, availableForBlock, 0L, 8 - availableForBlock);
        this.setAcquiredBlockOffset(8);
    }

    @Override
    public final void appendChar(char theValue) {
        int aDstOffset = this.mMemoryBlockChain.currentBlockOffset();
        MemoryBlock aMemoryBlock = this.mMemoryBlockChain.current();
        if (aMemoryBlock == null) {
            this.acquireNextBlockForWrite().putChar(aDstOffset, theValue);
            this.setAcquiredBlockOffset(2);
            return;
        }
        int availableForBlock = this.blockSize() - aDstOffset;
        if (availableForBlock >= 2) {
            aMemoryBlock.putChar(aDstOffset, theValue);
            this.stepToNextOffset(this.mMemoryBlockChain, 2);
            return;
        }
        ByteOrderUtil.writeChar(ByteAccessor.BYTE_ARRAY_BYTE_ACCESSOR, this.mBuffer, 0L, theValue, this.mUseBigEndian);
        aMemoryBlock.copyFromByteArray(this.mBuffer, 0, aDstOffset, availableForBlock);
        this.acquireNextBlockForWrite().copyFromByteArray(this.mBuffer, availableForBlock, 0L, 2 - availableForBlock);
        this.setAcquiredBlockOffset(2);
    }

    @Override
    public final void writeLong(int theBlockIndex, int theBlockOffset, long theValue) {
        MemoryBlock aMemoryBlock = this.mMemoryBlockChain.get(theBlockIndex);
        int availableForBlock = this.blockSize() - theBlockOffset;
        if (availableForBlock < 8) {
            ByteOrderUtil.writeLong(ByteAccessor.BYTE_ARRAY_BYTE_ACCESSOR, this.mBuffer, 0L, theValue, this.mUseBigEndian);
            aMemoryBlock.copyFromByteArray(this.mBuffer, 0, theBlockOffset, availableForBlock);
            aMemoryBlock = this.mMemoryBlockChain.get(theBlockIndex + 1);
            aMemoryBlock.copyFromByteArray(this.mBuffer, availableForBlock, 0L, 8 - availableForBlock);
            return;
        }
        aMemoryBlock.putLong(theBlockOffset, theValue);
    }

    @Override
    public final long readLong(int theBlockIndex, int theBlockOffset) {
        MemoryBlock aMemoryBlock = this.mMemoryBlockChain.get(theBlockIndex);
        int availableForBlock = this.blockSize() - theBlockOffset;
        if (availableForBlock < 8) {
            aMemoryBlock.copyToByteArray(theBlockOffset, this.mBuffer, 0, availableForBlock);
            aMemoryBlock = this.mMemoryBlockChain.get(theBlockIndex + 1);
            aMemoryBlock.copyToByteArray(0L, this.mBuffer, availableForBlock, 8 - availableForBlock);
            return ByteOrderUtil.readLong(ByteAccessor.BYTE_ARRAY_BYTE_ACCESSOR, this.mBuffer, 0L, this.mUseBigEndian);
        }
        return aMemoryBlock.getLong(theBlockOffset);
    }

    @Override
    public final long readLong(long theAddress) {
        int aSrcBlockOffset = Utilities.maskLongPowerOfTwoAsInt(theAddress, this.blockSizeMask());
        int aSrcBlockIndex = Utilities.divideLongPowerOfTwoAsInt(theAddress, this.blockSizeBitPosition());
        return this.readLong(aSrcBlockIndex, aSrcBlockOffset);
    }

    @Override
    public final void writeLong(long theAddress, long theValue) {
        int aSrcBlockOffset = Utilities.maskLongPowerOfTwoAsInt(theAddress, this.blockSizeMask());
        int aSrcBlockIndex = Utilities.divideLongPowerOfTwoAsInt(theAddress, this.blockSizeBitPosition());
        this.writeLong(aSrcBlockIndex, aSrcBlockOffset, theValue);
    }

    @Override
    public final int readInt(int theBlockIndex, int theBlockOffset) {
        MemoryBlock aMemoryBlock = this.mMemoryBlockChain.get(theBlockIndex);
        int availableForBlock = this.blockSize() - theBlockOffset;
        if (availableForBlock < 4) {
            aMemoryBlock.copyToByteArray(theBlockOffset, this.mBuffer, 0, availableForBlock);
            aMemoryBlock = this.mMemoryBlockChain.get(theBlockIndex + 1);
            aMemoryBlock.copyToByteArray(0L, this.mBuffer, availableForBlock, 4 - availableForBlock);
            return ByteOrderUtil.readInt(ByteAccessor.BYTE_ARRAY_BYTE_ACCESSOR, this.mBuffer, 0L, this.mUseBigEndian);
        }
        return aMemoryBlock.getInt(theBlockOffset);
    }

    @Override
    public final int readInt(long theAddress) {
        int aSrcBlockOffset = Utilities.maskLongPowerOfTwoAsInt(theAddress, this.blockSizeMask());
        int aSrcBlockIndex = Utilities.divideLongPowerOfTwoAsInt(theAddress, this.blockSizeBitPosition());
        return this.readInt(aSrcBlockIndex, aSrcBlockOffset);
    }

    @Override
    public final void writeInt(long theAddress, int theValue) {
        int aSrcBlockOffset = Utilities.maskLongPowerOfTwoAsInt(theAddress, this.blockSizeMask());
        int aSrcBlockIndex = Utilities.divideLongPowerOfTwoAsInt(theAddress, this.blockSizeBitPosition());
        this.writeInt(aSrcBlockIndex, aSrcBlockOffset, theValue);
    }

    @Override
    public final void writeInt(int theBlockIndex, int theBlockOffset, int theValue) {
        MemoryBlock aMemoryBlock = this.mMemoryBlockChain.get(theBlockIndex);
        int availableForBlock = this.blockSize() - theBlockOffset;
        if (availableForBlock < 4) {
            ByteOrderUtil.writeLong(ByteAccessor.BYTE_ARRAY_BYTE_ACCESSOR, this.mBuffer, 0L, theValue, this.mUseBigEndian);
            aMemoryBlock.copyFromByteArray(this.mBuffer, 0, theBlockOffset, availableForBlock);
            aMemoryBlock = this.mMemoryBlockChain.get(theBlockIndex + 1);
            aMemoryBlock.copyFromByteArray(this.mBuffer, availableForBlock, 0L, 4 - availableForBlock);
            return;
        }
        aMemoryBlock.putInt(theBlockOffset, theValue);
    }

    @Override
    public final void set(MemoryBlockChain theMemoryBlockChain) {
    }

    @Override
    public final void writeByte(long theAddress, byte theValue) {
        int aSrcBlockOffset = Utilities.maskLongPowerOfTwoAsInt(theAddress, this.blockSizeMask());
        int aSrcBlockIndex = Utilities.divideLongPowerOfTwoAsInt(theAddress, this.blockSizeBitPosition());
        this.writeByte(aSrcBlockIndex, aSrcBlockOffset, theValue);
    }

    @Override
    public final void writeByte(int theBlockIndex, int theBlockOffset, byte theValue) {
        MemoryBlock aMemoryBlock = this.mMemoryBlockChain.get(theBlockIndex);
        aMemoryBlock.putByte(theBlockOffset, theValue);
    }

    private void refreshActualBlocks(MemoryBlockChain theDataMemoryBlockChain) {
        if (theDataMemoryBlockChain.currentIndex() >= theDataMemoryBlockChain.getActualBlocksCount()) {
            theDataMemoryBlockChain.setActualBlocksCount(theDataMemoryBlockChain.currentIndex() + 1);
        }
    }

    protected MemoryBlock acquireNextBlockForWrite() {
        if (!this.mMemoryBlockChain.obtainNext()) {
            throw new OutOfMemoryException("Not enough memory");
        }
        if (this.mListener != null && this.mMemoryBlockChain.size() == 1) {
            this.mListener.call(this.mMemoryBlockChain.current());
        }
        return this.mMemoryBlockChain.current();
    }

    private void setAcquiredBlockOffset(int theAcquiredBytesCount) {
        int aNextOffset = this.mMemoryBlockChain.currentBlockOffset() + theAcquiredBytesCount;
        this.mMemoryBlockChain.setCurrentBlockOffset(Utilities.maskIntPowerOfTwoAsInt(aNextOffset, this.blockSizeMask()));
    }

    private void stepToNextOffset(MemoryBlockChain theMemoryBlockChain, int theSizeInBytes) {
        int aNextOffset = theMemoryBlockChain.currentBlockOffset() + theSizeInBytes;
        if (aNextOffset >= this.blockSize()) {
            theMemoryBlockChain.incrementCurrentBlockIndex();
            theMemoryBlockChain.setCurrentBlockOffset(Utilities.maskIntPowerOfTwoAsInt(aNextOffset, this.blockSizeMask()));
            return;
        }
        theMemoryBlockChain.setCurrentBlockOffset(aNextOffset);
    }

    private int blockSizeMask() {
        return this.mBlockSizeMask;
    }

    private int blockSizeBitPosition() {
        return this.mBlockSizeBitPosition;
    }

    public final long length() throws IOException {
        throw new UnsupportedOperationException("unsupported");
    }

    public final boolean isOverflowed() {
        throw new UnsupportedOperationException("unsupported");
    }

    public final long getPosition() throws IOException {
        return Utilities.calculateAddress(this.mMemoryBlockChain.currentIndex(), this.mMemoryBlockChain.currentBlockOffset(), this.mBlockSizeBitPosition);
    }

    public void setPosition(long thePosition) throws IOException {
        throw new UnsupportedOperationException("unsupported");
    }

    public final void write(byte[] theData) throws IOException {
        this.write(theData, 0, theData.length);
    }

    public final void write(byte[] theData, int theOffset, int theLength) throws IOException {
        long aRemaining = theLength;
        if (aRemaining <= 0L) {
            return;
        }
        int aSrcOffset = theOffset;
        int aDstOffset = this.mMemoryBlockChain.currentBlockOffset();
        while (aRemaining > 0L) {
            MemoryBlock aMemoryBlock = this.mMemoryBlockChain.current();
            if (aMemoryBlock == null) {
                aMemoryBlock = this.acquireNextBlockForWrite();
            }
            int aBytesToCopy = (int)Math.min(aRemaining, (long)(this.blockSize() - aDstOffset));
            aMemoryBlock.copyFromByteArray(theData, aSrcOffset, aDstOffset, aBytesToCopy);
            aSrcOffset += aBytesToCopy;
            aRemaining -= (long)aBytesToCopy;
            if ((aDstOffset += aBytesToCopy) < this.blockSize()) continue;
            aDstOffset = Utilities.maskIntPowerOfTwoAsInt(aDstOffset, this.blockSizeMask());
            this.mMemoryBlockChain.incrementCurrentBlockIndex();
        }
        this.setAcquiredBlockOffset(theLength);
    }

    public void writeByte(byte theValue) throws IOException {
        this.appendByte(theValue);
    }

    public void writeInt(int theValue) throws IOException {
        int aDstOffset = this.mMemoryBlockChain.currentBlockOffset();
        MemoryBlock aMemoryBlock = this.mMemoryBlockChain.current();
        if (aMemoryBlock == null) {
            this.acquireNextBlockForWrite().putInt(aDstOffset, theValue);
            this.setAcquiredBlockOffset(4);
            return;
        }
        int aAvailableForBlock = this.blockSize() - aDstOffset;
        if (aAvailableForBlock >= 4) {
            aMemoryBlock.putInt(aDstOffset, theValue);
            this.stepToNextOffset(this.mMemoryBlockChain, 4);
            return;
        }
        ByteOrderUtil.writeInt(ByteAccessor.BYTE_ARRAY_BYTE_ACCESSOR, this.mBuffer, 0L, theValue, this.mUseBigEndian);
        aMemoryBlock.copyFromByteArray(this.mBuffer, 0, aDstOffset, aAvailableForBlock);
        this.acquireNextBlockForWrite().copyFromByteArray(this.mBuffer, aAvailableForBlock, 0L, 4 - aAvailableForBlock);
        this.setAcquiredBlockOffset(4);
    }

    public final void writeVInt(int theValue) throws IOException {
        this.writeInt(theValue);
    }

    public final void writeLong(long theValue) throws IOException {
        this.appendLong(theValue);
    }

    public final void writeShort(short theValue) throws IOException {
        int aDstOffset = this.mMemoryBlockChain.currentBlockOffset();
        MemoryBlock aMemoryBlock = this.mMemoryBlockChain.current();
        if (aMemoryBlock == null) {
            this.acquireNextBlockForWrite().putShort(aDstOffset, theValue);
            this.setAcquiredBlockOffset(2);
            return;
        }
        int aAvailableForBlock = this.blockSize() - aDstOffset;
        if (aAvailableForBlock >= 2) {
            aMemoryBlock.putShort(aDstOffset, theValue);
            this.stepToNextOffset(this.mMemoryBlockChain, 2);
            return;
        }
        ByteOrderUtil.writeShort(ByteAccessor.BYTE_ARRAY_BYTE_ACCESSOR, this.mBuffer, 0L, theValue, this.mUseBigEndian);
        aMemoryBlock.copyFromByteArray(this.mBuffer, 0, aDstOffset, aAvailableForBlock);
        this.acquireNextBlockForWrite().copyFromByteArray(this.mBuffer, aAvailableForBlock, 0L, 2 - aAvailableForBlock);
        this.setAcquiredBlockOffset(2);
    }

    public final void writeChar(char theChar) throws IOException {
        this.appendChar(theChar);
    }

    public final void writeVLong(long theValue) throws IOException {
        this.appendLong(theValue);
    }

    public final void writeDouble(double theValue) throws IOException {
        int aDstOffset = this.mMemoryBlockChain.currentBlockOffset();
        MemoryBlock aMemoryBlock = this.mMemoryBlockChain.current();
        if (aMemoryBlock == null) {
            this.acquireNextBlockForWrite().putDouble(aDstOffset, theValue);
            this.setAcquiredBlockOffset(8);
            return;
        }
        int aAvailableForBlock = this.blockSize() - aDstOffset;
        if (aAvailableForBlock >= 8) {
            aMemoryBlock.putDouble(aDstOffset, theValue);
            this.stepToNextOffset(this.mMemoryBlockChain, 8);
            return;
        }
        ByteOrderUtil.writeDouble(ByteAccessor.BYTE_ARRAY_BYTE_ACCESSOR, this.mBuffer, 0L, theValue, this.mUseBigEndian);
        aMemoryBlock.copyFromByteArray(this.mBuffer, 0, aDstOffset, aAvailableForBlock);
        this.acquireNextBlockForWrite().copyFromByteArray(this.mBuffer, aAvailableForBlock, 0L, 8 - aAvailableForBlock);
        this.setAcquiredBlockOffset(8);
    }

    public final void writeFloat(float theValue) throws IOException {
        int aDstOffset = this.mMemoryBlockChain.currentBlockOffset();
        MemoryBlock aMemoryBlock = this.mMemoryBlockChain.current();
        if (aMemoryBlock == null) {
            this.acquireNextBlockForWrite().putFloat(aDstOffset, theValue);
            this.setAcquiredBlockOffset(4);
            return;
        }
        int aAvailableForBlock = this.blockSize() - aDstOffset;
        if (aAvailableForBlock >= 4) {
            aMemoryBlock.putFloat(aDstOffset, theValue);
            this.stepToNextOffset(this.mMemoryBlockChain, 4);
            return;
        }
        ByteOrderUtil.writeFloat(ByteAccessor.BYTE_ARRAY_BYTE_ACCESSOR, this.mBuffer, 0L, theValue, this.mUseBigEndian);
        aMemoryBlock.copyFromByteArray(this.mBuffer, 0, aDstOffset, aAvailableForBlock);
        this.acquireNextBlockForWrite().copyFromByteArray(this.mBuffer, aAvailableForBlock, 0L, 4 - aAvailableForBlock);
        this.setAcquiredBlockOffset(4);
    }

    @Override
    public final void copyMemory(long theSourcePosition, long theTargetPosition, long theBytesCount, DataAreaAccessor theSourceDataAreaAccessor) {
        Utilities.copyMemory(theSourcePosition, theTargetPosition, theBytesCount, theSourceDataAreaAccessor.get(), this.mMemoryBlockChain, this.mBlockSizeMask, this.mBlockSizeBitPosition, this.mBlockSize);
    }

    public final void writeString(String theValue) throws IOException {
        byte[] aBytes = theValue.getBytes(Charsets.UTF_8);
        this.writeInt(aBytes.length);
        this.write(aBytes);
    }

    public final void writeBuffer(long[] theData, int theOffset, int theLength) {
        long aRemaining = theLength;
        if (aRemaining <= 0L) {
            return;
        }
        int aSrcOffset = theOffset;
        int aDstOffset = this.mMemoryBlockChain.currentBlockOffset();
        while (aRemaining > 0L) {
            MemoryBlock aMemoryBlock = this.mMemoryBlockChain.current();
            if (aMemoryBlock == null) {
                aMemoryBlock = this.acquireNextBlockForWrite();
            }
            int aBytesToCopy = (int)Math.min(aRemaining, (long)(this.blockSize() - aDstOffset));
            aMemoryBlock.copyFromLongArray(theData, aSrcOffset, aDstOffset, aBytesToCopy);
            aSrcOffset += aBytesToCopy;
            aRemaining -= (long)aBytesToCopy;
            if ((aDstOffset += aBytesToCopy) < this.blockSize()) continue;
            aDstOffset = Utilities.maskIntPowerOfTwoAsInt(aDstOffset, this.blockSizeMask());
            this.mMemoryBlockChain.incrementCurrentBlockIndex();
        }
        this.setAcquiredBlockOffset(theLength);
    }

    public final int blockSize() {
        return this.mBlockSize;
    }
}

