/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.impl.tape;

import com.complexible.common.base.AutoCloser;
import com.complexible.common.base.Disposable;
import com.complexible.common.base.Disposables;
import com.complexible.memory.factory.CollectionFactory;
import com.complexible.memory.file.impl.DefaultFileReader;
import com.complexible.memory.file.impl.DefaultFileWriter;
import com.complexible.memory.memoryblock.MemoryBlock;
import com.complexible.memory.memoryblock.MemoryBlockChain;
import com.complexible.memory.memoryblock.MemoryContext;
import com.complexible.memory.structure.Collection;
import com.complexible.memory.structure.OperationTracker;
import com.complexible.memory.structure.impl.tape.ConventionalSpillingSupportedTape;
import com.complexible.memory.structure.impl.tape.OutOfMemoryException;
import java.io.IOException;

public abstract class ConventionalSpillingSupportedAddressingTape<T extends Collection>
extends ConventionalSpillingSupportedTape<T> {
    protected final DefaultFileWriter mAddressingSpaceDefaultFileWriter;
    protected final DefaultFileReader mAddressingSpaceDefaultFileReader;

    protected ConventionalSpillingSupportedAddressingTape(int spillingBufferSize, MemoryContext theMemoryContext, CollectionFactory<T> theCollectionFactory, OperationTracker theOperationTracker) {
        super(spillingBufferSize, theMemoryContext, theCollectionFactory, theOperationTracker);
        try {
            this.mAddressingSpaceDefaultFileWriter = new DefaultFileWriter(spillingBufferSize, theMemoryContext.getMaxSpillingFileLength(), theMemoryContext.getSpillingSyncChunkSize());
            this.mAddressingSpaceDefaultFileReader = new DefaultFileReader(spillingBufferSize);
        }
        catch (Throwable t) {
            this.dispose();
            throw t;
        }
    }

    @Override
    protected void append(ConventionalSpillingSupportedTape.ElementAppender theElementAppender) throws IOException {
        block9: {
            boolean aSpillFailure = false;
            boolean aHasAvailableAddressSpace = this.checkAvailableAddressSpace();
            if (!aHasAvailableAddressSpace) {
                try {
                    this.spillTapeToTheDisk();
                    aHasAvailableAddressSpace = this.checkAvailableAddressSpace();
                    aSpillFailure = !aHasAvailableAddressSpace;
                }
                catch (OutOfMemoryException theE) {
                    aSpillFailure = true;
                }
            }
            int aOffset = this.getDataChainOffset();
            int aBlockIndex = this.getDataBlockCurrentIndex();
            try {
                if (aSpillFailure) {
                    throw new OutOfMemoryException("Not enough memory");
                }
                theElementAppender.appendElement();
                this.writeDataAddressToAddressSpace(aBlockIndex, aOffset);
            }
            catch (OutOfMemoryException theE) {
                boolean aIsMemoryEnoughForElement = false;
                this.mDataMemoryBlockChain.setCurrentBlock(aBlockIndex);
                this.mDataMemoryBlockChain.setCurrentBlockOffset(aOffset);
                if (aHasAvailableAddressSpace) {
                    this.spillTapeToTheDisk();
                    try {
                        aOffset = this.getDataChainOffset();
                        aBlockIndex = this.getDataBlockCurrentIndex();
                        theElementAppender.appendElement();
                        this.writeDataAddressToAddressSpace(aBlockIndex, aOffset);
                        aIsMemoryEnoughForElement = true;
                    }
                    catch (OutOfMemoryException ee) {
                        aIsMemoryEnoughForElement = false;
                    }
                }
                if (aIsMemoryEnoughForElement) break block9;
                this.logBlobSpilling();
                theElementAppender.spillElement();
                this.mDataMemoryBlockChain.setCurrentBlock(0);
                this.mDataMemoryBlockChain.setCurrentBlockOffset(0);
                this.mDataMemoryBlockChain.incrementTotalElementsCount();
                return;
            }
        }
        this.incrementElementsCount();
    }

    @Override
    public void dispose() {
        AutoCloser.close((AutoCloseable[])new AutoCloseable[]{() -> super.dispose(), Disposables.asCloseable((Disposable)this.mAddressingSpaceDefaultFileWriter), this.mAddressingSpaceDefaultFileReader});
    }

    protected boolean checkAvailableAddressSpace(MemoryBlockChain theMemoryBlockChain) {
        MemoryBlock aMemoryBlock = theMemoryBlockChain.current();
        if (aMemoryBlock == null) {
            return this.obtainNextBlock(theMemoryBlockChain);
        }
        long aAvailableForBlock = this.mMemoryContext.getBlockSize() - theMemoryBlockChain.currentBlockOffset();
        return aAvailableForBlock >= 8L || this.obtainNextBlock(theMemoryBlockChain);
    }

    protected abstract boolean checkAvailableAddressSpace();

    protected abstract void writeDataAddressToAddressSpace(int var1, int var2) throws IOException;

    protected boolean obtainNextBlock(MemoryBlockChain theMemoryBlockChain) {
        return theMemoryBlockChain.obtainNext();
    }

    private int getDataBlockCurrentIndex() {
        return !this.mDataMemoryBlockChain.isEmpty() ? this.mDataMemoryBlockChain.currentIndex() : 0;
    }

    private int getDataChainOffset() {
        return !this.mDataMemoryBlockChain.isEmpty() ? this.mDataMemoryBlockChain.currentBlockOffset() : 0;
    }

    public void allocateMinMemoryBlocks() {
        this.checkAvailableAddressSpace();
    }
}

