/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.impl.tape;

import com.complexible.common.base.AutoCloser;
import com.complexible.common.base.Disposable;
import com.complexible.common.base.Disposables;
import com.complexible.common.io.ByteReader;
import com.complexible.common.io.ObjectWriterFactory;
import com.complexible.memory.factory.CollectionFactory;
import com.complexible.memory.memoryblock.MemoryBlock;
import com.complexible.memory.memoryblock.MemoryContext;
import com.complexible.memory.structure.Collection;
import com.complexible.memory.structure.Comparator;
import com.complexible.memory.structure.OperationTracker;
import com.complexible.memory.structure.impl.hashtable.PartitionsArea;
import com.complexible.memory.structure.impl.tape.ConventionalSpillingSupportedAddressingTape;
import com.complexible.memory.structure.impl.tape.MemoryBlockAddressArea;
import com.complexible.memory.structure.impl.tape.OutOfMemoryException;
import com.complexible.memory.structure.impl.tape.addressing.hashtape.impl.ConventionalMemoryHashTapeImpl;
import com.complexible.memory.structure.openaddressing.ConventionalOpenAddressingTable;
import com.complexible.memory.structure.openaddressing.OpenAddressingTable;
import com.complexible.memory.util.Utilities;
import java.io.IOException;

public abstract class ConventionalSpillingSupportedAddressingHashTape<T extends Collection>
extends ConventionalSpillingSupportedAddressingTape<T> {
    protected final ConventionalMemoryHashTapeImpl mMemoryHashTape;
    protected final PartitionsArea mPartitionsArea;
    protected final MemoryBlockAddressArea mOverFlowPartitionsArea;

    protected ConventionalSpillingSupportedAddressingHashTape(int theSpillingBufferSize, MemoryContext theMemoryContext, int theDefaultPartitionCount, Comparator theDefaultComparator, CollectionFactory<T> theCollectionFactory, OperationTracker theOperationTracker) {
        super(theSpillingBufferSize, theMemoryContext, theCollectionFactory, theOperationTracker);
        this.mPartitionsArea = new PartitionsArea(this.mMemoryBlockChainFactory);
        try {
            this.mOverFlowPartitionsArea = this.mPartitionsArea.getOverFlowPartitionsArea();
            this.mMemoryHashTape = new ConventionalMemoryHashTapeImpl(this.mPartitionsArea, this.mMemoryContext, theDefaultPartitionCount, theDefaultComparator, this.mDataAreaAccessor, this.mMemoryBlockChainFactory);
        }
        catch (Throwable t) {
            this.dispose();
            throw t;
        }
    }

    public void put(ByteReader theReader) throws IOException {
        this.mMemoryHashTape.initContext(theReader);
        this.append(theReader);
    }

    protected void handleOpenAddressingPut(MemoryBlock theAddressBlock, long theSegmentDataAddress, int theHashCodeCellAddress) {
        if (theHashCodeCellAddress < 0) {
            this.appendElement(theAddressBlock, theSegmentDataAddress, theHashCodeCellAddress);
        } else {
            this.addNewElement(theAddressBlock, theSegmentDataAddress, theHashCodeCellAddress);
        }
    }

    @Override
    protected boolean checkAvailableAddressSpace() {
        return this.mMemoryHashTape.checkExpansionThreshold() || this.resize();
    }

    @Override
    public void dispose() {
        AutoCloser.close((AutoCloseable[])new AutoCloseable[]{() -> super.dispose(), Disposables.asCloseable((Disposable)this.mPartitionsArea), Disposables.asCloseable((Disposable)this.mMemoryHashTape)});
    }

    protected boolean putUnique(ByteReader theReader) throws IOException {
        try {
            boolean bl = this.ensureUnique(theReader);
            return bl;
        }
        finally {
            ((ConventionalOpenAddressingTable)this.mMemoryHashTape.getInitiatedOpenAddressingTable()).setPayLoad(-1L);
        }
    }

    protected boolean ensureUnique(ByteReader theReader) throws IOException {
        if (this.mMemoryHashTape.getPartition() == null) {
            super.append(theReader);
            return true;
        }
        OpenAddressingTable oaTable = this.mMemoryHashTape.getOpenAddressingTable();
        MemoryBlock partition = this.mMemoryHashTape.getPartition();
        int hashCode = this.mMemoryHashTape.getHashCode();
        int overFlowBlockId = partition.getHeader().getInt(32L);
        if (this.searchOverflowBlocks(theReader, overFlowBlockId, (ConventionalOpenAddressingTable<MemoryBlock>)oaTable, hashCode)) {
            return false;
        }
        oaTable.setMemoryAccessor(partition);
        int aSlotHashCodeAddress = this.searchSlot((ConventionalOpenAddressingTable<MemoryBlock>)oaTable, theReader, hashCode);
        if (aSlotHashCodeAddress > 0) {
            if (!oaTable.checkExpansionThreshold()) {
                if (!this.resize()) {
                    this.spillTapeToTheDisk();
                }
                Utilities.resetByteReader(theReader);
                this.mMemoryHashTape.initContext(theReader);
                oaTable.setMemoryAccessor(this.mMemoryHashTape.getPartition());
                this.searchSlot((ConventionalOpenAddressingTable<MemoryBlock>)oaTable, theReader, hashCode);
            }
            super.append(theReader);
            return true;
        }
        return false;
    }

    private boolean searchOverflowBlocks(ByteReader theReader, int overFlowBlockId, ConventionalOpenAddressingTable<MemoryBlock> oaTable, int hashCode) {
        while (overFlowBlockId >= 0) {
            MemoryBlock block = this.mOverFlowPartitionsArea.getMemoryBlock(overFlowBlockId);
            oaTable.setMemoryAccessor(block);
            int aSlotHashCodeAddress = this.searchSlot(oaTable, theReader, hashCode);
            if (aSlotHashCodeAddress <= 0) {
                return true;
            }
            overFlowBlockId = block.getHeader().getInt(32L);
        }
        return false;
    }

    private void addNewElement(MemoryBlock theAddressBlock, long theSegmentAddress, int theHashCodeCellAddress) {
        if (!this.isKeyUnique()) {
            this.writeLong(theSegmentAddress, this.readLong(theSegmentAddress) + 24L + 1L);
            this.appendLong(-1L);
            this.appendLong(theSegmentAddress);
            this.appendLong(1L);
            this.appendByte((byte)1);
        }
        this.updatePartitionHashCode(theAddressBlock, theHashCodeCellAddress);
    }

    private void appendElement(MemoryBlock theAddressBlock, long theSegmentAddress, int theHashCodeAddress) {
        long aSegmentCellAddress = ConventionalOpenAddressingTable.getSegmentCellAddress(Math.abs(theHashCodeAddress));
        long aElementLength = this.readLong(theSegmentAddress);
        long aHeadElementCountElementAddress = this.mMemoryHashTape.mergeElements(theSegmentAddress, theAddressBlock, aSegmentCellAddress, aElementLength);
        long aNewValueCount = this.readLong(aHeadElementCountElementAddress) + 1L;
        this.writeLong(aHeadElementCountElementAddress, aNewValueCount);
        this.writeLong(theSegmentAddress, this.readLong(theSegmentAddress) + 8L + 1L);
        this.appendLong(-1L);
        this.appendByte((byte)0);
    }

    public void setComparator(Comparator theComparator) {
        this.mMemoryHashTape.setComparator(theComparator);
    }

    protected void create() {
        this.mMemoryHashTape.createTape();
        super.createTape();
    }

    protected boolean resize() {
        return this.mMemoryHashTape.resize();
    }

    private int searchSlot(ConventionalOpenAddressingTable<MemoryBlock> theOA, ByteReader theReader, int hashCode) {
        int aSlotHashCodeAddress = theOA.searchSlot(theReader, hashCode);
        theOA.setPayLoad(aSlotHashCodeAddress);
        return aSlotHashCodeAddress;
    }

    protected final void updatePartitionHashCode(MemoryBlock theAddressBlock, int theHashCodeCellAddress) {
        this.mMemoryHashTape.updatePartitionHashCode(theAddressBlock, theHashCodeCellAddress);
    }

    protected boolean isKeyUnique() {
        return false;
    }

    public void calculateDefaultPartitionCount(int theEstimatedKeysCount) {
        this.mMemoryHashTape.calculateDefaultPartitionCount(theEstimatedKeysCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void writeDataAddressToAddressSpace(int theBlockIndex, int theOffset) throws IOException {
        ConventionalOpenAddressingTable aOpenAddressingTable = (ConventionalOpenAddressingTable)this.mMemoryHashTape.getInitiatedOpenAddressingTable();
        long aElementAddress = Utilities.calculateAddress(theBlockIndex, theOffset, this.blockSizeBitPosition());
        if (!this.isKeyUnique()) {
            this.checkBytesAvailable(25L);
        }
        boolean aUniqueness = this.mMemoryHashTape.getHashComparator().getUniquenessMode();
        try {
            this.mMemoryHashTape.getHashComparator().setRightUniquenessMode(true);
            int aHashCodeCellAddress = aOpenAddressingTable.putIfAbsent(aElementAddress, this.mMemoryHashTape.getHashCode());
            this.handleOpenAddressingPut(this.mMemoryHashTape.getPartition(), aElementAddress, aHashCodeCellAddress);
        }
        finally {
            this.mMemoryHashTape.getHashComparator().setRightUniquenessMode(aUniqueness);
        }
    }

    @Override
    protected <TT> void spillBlob(TT theObject, ObjectWriterFactory<TT> theFactory) throws IOException {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    protected void spillBlob(ByteReader theDataReader) throws IOException {
        throw new UnsupportedOperationException("not implemented");
    }

    protected void checkBytesAvailable(long theBytesCount) {
        int aAvailable;
        int aDstOffset = this.mDataMemoryBlockChain.currentBlockOffset();
        int n = aAvailable = this.mDataMemoryBlockChain.current() == null ? -aDstOffset : this.blockSize() - aDstOffset;
        if ((long)aAvailable >= theBytesCount) {
            return;
        }
        long aRemaining = theBytesCount - (long)aAvailable;
        do {
            if (this.mDataMemoryBlockChain.checkNext()) continue;
            throw new OutOfMemoryException("not enough memory");
        } while ((aRemaining -= (long)this.blockSize()) > 0L);
    }
}

