/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.impl.tape;

import com.complexible.memory.factory.CollectionFactory;
import com.complexible.memory.memoryblock.MemoryBlockChainFactory;
import com.complexible.memory.memoryblock.MemoryContext;
import com.complexible.memory.structure.Collection;
import com.complexible.memory.structure.OperationTracker;
import com.complexible.memory.util.SpillingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseTape<T extends Collection> {
    protected final Logger mLogger = LoggerFactory.getLogger(this.getClass());
    protected final MemoryContext mMemoryContext;
    private final CollectionFactory<T> mCollectionFactory;
    protected final OperationTracker mOperationTracker;
    protected final MemoryBlockChainFactory mMemoryBlockChainFactory;

    BaseTape(MemoryContext theMemoryContext, CollectionFactory<T> theCollectionFactory, OperationTracker theOperationTracker) {
        this.mMemoryContext = theMemoryContext;
        this.mCollectionFactory = theCollectionFactory;
        this.mOperationTracker = SpillingUtil.resolveTracker(theOperationTracker);
        this.mMemoryBlockChainFactory = new MemoryBlockChainFactory(theMemoryContext, this.mOperationTracker);
    }

    protected abstract T getCollection();

    public void dispose() {
        if (this.mCollectionFactory != null) {
            this.mCollectionFactory.releaseCollection(this.getCollection());
        }
    }
}

