/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.impl.queue;

import com.complexible.common.base.AutoCloser;
import com.complexible.memory.factory.CollectionFactory;
import com.complexible.memory.memoryblock.MemoryBlock;
import com.complexible.memory.memoryblock.MemoryContext;
import com.complexible.memory.structure.LongQueue;
import com.complexible.memory.structure.OperationTracker;
import com.complexible.memory.structure.OperationType;
import com.complexible.memory.structure.impl.queue.BaseQueue;
import com.complexible.memory.util.SpillingUtil;
import com.complexible.memory.util.Utilities;
import java.io.IOException;

public final class LongQueueImpl
extends BaseQueue<LongQueue>
implements LongQueue {
    public LongQueueImpl(int theSpillingBufferSize, MemoryContext theMemoryContext, CollectionFactory<LongQueue> theCollectionFactory, OperationTracker theOperationTracker) {
        super(theSpillingBufferSize, theMemoryContext, theCollectionFactory, theOperationTracker);
    }

    @Override
    public void spillTapeToTheDisk() {
        if (this.mDataMemoryBlockChain.getMemoryElementsCount() > 0L) {
            try {
                this.mOperationTracker.onStart(OperationType.SPILLING);
                boolean aOnlyMemory = this.mDataMemoryBlockChain.getTotalSpilledBytes() == 0L;
                try {
                    super.spillTapeToTheDisk();
                }
                finally {
                    if (aOnlyMemory) {
                        this.mDataMemoryBlockChain.setPayLoad(0L);
                    }
                }
            }
            finally {
                this.mOperationTracker.onDone(OperationType.SPILLING);
            }
        }
    }

    @Override
    protected void spillLong(long theValue) {
        try {
            this.mOperationTracker.onStart(OperationType.SPILLING);
            super.spillLong(theValue);
        }
        finally {
            this.mOperationTracker.onDone(OperationType.SPILLING);
        }
    }

    @Override
    protected int getEndBlockIndex() {
        long aLastAddress = this.calculateLastAddress();
        return Utilities.getIndex(aLastAddress, this.mMemoryContext.getBlockSizeBitPosition());
    }

    @Override
    protected int getEndBlockOffset() {
        long aLastAddress = this.calculateLastAddress();
        return Utilities.getOffset(aLastAddress, this.mMemoryContext.getBlockSizeMask());
    }

    @Override
    protected int getStartBlockIndex() {
        return this.mDataMemoryBlockChain.getTotalSpilledBytes() == 0L ? Utilities.getIndex(this.mDataMemoryBlockChain.getPayLoad(), this.mMemoryContext.getBlockSizeBitPosition()) : 0;
    }

    @Override
    protected int getStartBlockOffset() {
        return this.mDataMemoryBlockChain.getTotalSpilledBytes() == 0L ? Utilities.getOffset(this.mDataMemoryBlockChain.getPayLoad(), this.mMemoryContext.getBlockSizeMask()) : 0;
    }

    private long poolFromMemory(long theWaterMark, long theTotalSpilledBytes, boolean theMoveWaterMark) {
        int aMemoryBlockIndex = Utilities.getIndex(theWaterMark, this.mMemoryContext.getBlockSizeBitPosition());
        int aMemoryBlockOffset = Utilities.getOffset(theWaterMark, this.mMemoryContext.getBlockSizeMask());
        MemoryBlock aMemoryBlock = this.mDataMemoryBlockChain.get(aMemoryBlockIndex);
        long aValue = aMemoryBlock.getLong(aMemoryBlockOffset);
        if (!theMoveWaterMark) {
            return aValue;
        }
        if (this.mDataMemoryBlockChain.getTotalElementsCount() == 1L) {
            this.mDataMemoryBlockChain.setPayLoad(0L);
            this.mDataMemoryBlockChain.setCurrentBlock(0);
            this.mDataMemoryBlockChain.setCurrentBlockOffset(0);
            this.mDataMemoryBlockChain.setMemoryElementsCount(this.mDataMemoryBlockChain.getMemoryElementsCount() - 1L);
            this.mDataMemoryBlockChain.setTotalElementsCount(this.mDataMemoryBlockChain.getTotalElementsCount() - 1L);
            return aValue;
        }
        long aNextWaterMark = theWaterMark + 8L;
        if (aNextWaterMark >= (long)this.mMemoryContext.getBlockSize() && this.mDataMemoryBlockChain.size() > 1) {
            this.mDataMemoryBlockChain.add(this.mDataMemoryBlockChain.pop());
            this.mDataMemoryBlockChain.setCurrentBlock(this.mDataMemoryBlockChain.currentIndex() - 1);
            aNextWaterMark = theTotalSpilledBytes;
        }
        this.mDataMemoryBlockChain.setMemoryElementsCount(this.mDataMemoryBlockChain.getMemoryElementsCount() - 1L);
        this.mDataMemoryBlockChain.setTotalElementsCount(this.mDataMemoryBlockChain.getTotalElementsCount() - 1L);
        this.mDataMemoryBlockChain.setPayLoad(aNextWaterMark);
        return aValue;
    }

    private long poolFromDisk(long theWaterMark, long theTotalSpilledBytes, boolean theMoveWaterMark) {
        long aValue;
        this.checkReader();
        try {
            this.mDiskDataBlocksReader.setPosition(theWaterMark);
            aValue = this.mDiskDataBlocksReader.readLong();
            if (!theMoveWaterMark) {
                return aValue;
            }
        }
        catch (IOException theE) {
            throw Utilities.rethrow(theE);
        }
        long aNextWaterMark = theWaterMark + 8L;
        if (aNextWaterMark >= theTotalSpilledBytes) {
            AutoCloser.close((AutoCloseable[])new AutoCloseable[]{this.mDiskDataBlocksReader, () -> SpillingUtil.deleteFile(this.mDataMemoryBlockChain.getSpilledFile())});
            this.mDataMemoryBlockChain.setTotalSpilledBytes(0L);
            this.mDataMemoryBlockChain.setTotalSpilledElementsCount(0L);
            this.mDataMemoryBlockChain.setSpilledFile(null);
            this.mDataMemoryBlockChain.setTotalElementsCount(this.mDataMemoryBlockChain.getTotalElementsCount() - 1L);
            this.mDataMemoryBlockChain.setPayLoad(0L);
            return aValue;
        }
        this.mDataMemoryBlockChain.setTotalElementsCount(this.mDataMemoryBlockChain.getTotalElementsCount() - 1L);
        this.mDataMemoryBlockChain.setPayLoad(aNextWaterMark);
        return aValue;
    }

    @Override
    protected long fetch(boolean theMoveWaterMark) {
        this.checkSize();
        long aWaterMark = this.mDataMemoryBlockChain.getPayLoad();
        long aTotalSpilledBytes = this.mDataMemoryBlockChain.getTotalSpilledBytes();
        return aWaterMark < aTotalSpilledBytes ? this.poolFromDisk(aWaterMark, aTotalSpilledBytes, theMoveWaterMark) : this.poolFromMemory(aWaterMark, aTotalSpilledBytes, theMoveWaterMark);
    }

    @Override
    protected LongQueue getCollection() {
        return this;
    }

    private long calculateLastAddress() {
        return this.mDataMemoryBlockChain.getPayLoad() + Utilities.multiplyLongPowerOfTwoAsLong(this.mDataMemoryBlockChain.getMemoryElementsCount() - 1L, 3);
    }
}

