/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.impl.queue;

import com.complexible.common.base.AutoCloser;
import com.complexible.memory.factory.CollectionFactory;
import com.complexible.memory.memoryblock.DefaultMemoryBlockChain;
import com.complexible.memory.memoryblock.MemoryBlock;
import com.complexible.memory.memoryblock.MemoryContext;
import com.complexible.memory.structure.LongQueue;
import com.complexible.memory.structure.OperationTracker;
import com.complexible.memory.structure.impl.tape.DataAreaSpillingSupportedTape;
import com.complexible.memory.structure.impl.tape.MemoryBlocksDataArea;
import com.complexible.memory.structure.impl.tape.OutOfMemoryException;
import com.complexible.memory.util.SpillingUtil;
import java.util.NoSuchElementException;

abstract class BaseQueue<T extends LongQueue>
extends DataAreaSpillingSupportedTape<T> {
    protected final MemoryBlocksDataArea mDataAreaAccessor;

    protected BaseQueue(int theSpillingBufferSize, MemoryContext theMemoryContext, CollectionFactory<T> theCollectionFactory, OperationTracker theOperationTracker) {
        super(theSpillingBufferSize, theMemoryContext, theCollectionFactory, theOperationTracker);
        this.mDataAreaAccessor = new MemoryBlocksDataArea(this.mMemoryBlockChainFactory);
    }

    public void add(long theValue) {
        try {
            this.mDataAreaAccessor.appendLong(theValue);
            this.onSuccess();
        }
        catch (OutOfMemoryException theE) {
            this.spillTapeToTheDisk();
            try {
                this.mDataAreaAccessor.appendLong(theValue);
                this.onSuccess();
            }
            catch (OutOfMemoryException theEE) {
                this.spillLong(theValue);
            }
        }
    }

    public long size() {
        return this.mDataMemoryBlockChain.getTotalElementsCount();
    }

    @Override
    protected MemoryBlocksDataArea getDataArea() {
        return this.mDataAreaAccessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void spillTapeToTheDisk() {
        int aStartBlockIndex = this.getStartBlockIndex();
        int aStartBlockOffset = this.getStartBlockOffset();
        int aEndBlockIndex = this.getEndBlockIndex();
        int aEndBlockOffset = this.getEndBlockOffset();
        AutoCloser.close((AutoCloseable[])new AutoCloseable[]{this.mDiskDataBlocksReader});
        SpillingUtil.openDiskWriter(this.mMemoryContext.getSpillingDirectory(), this.mDiskDataBlocksWriter, this.mDataMemoryBlockChain);
        try {
            int aCurrentOffset = aStartBlockOffset;
            for (int aBlockIndex = aStartBlockIndex; aBlockIndex <= aEndBlockIndex; ++aBlockIndex) {
                int aLength = aEndBlockIndex > aBlockIndex ? this.mMemoryContext.getBlockSize() - aCurrentOffset : 8 + aEndBlockOffset - aCurrentOffset;
                MemoryBlock aMemoryBlock = this.mDataMemoryBlockChain.get(aBlockIndex);
                this.mDiskDataBlocksWriter.writeBlob(aMemoryBlock, aCurrentOffset, aLength);
                this.mDataMemoryBlockChain.incrementTotalSpilledBytes(aLength);
                this.mOperationTracker.onSpilling(aLength);
                aCurrentOffset = 0;
            }
            this.mDataMemoryBlockChain.resetMemoryAfterSpill(true);
        }
        catch (Throwable throwable) {
            this.mDataMemoryBlockChain.resetMemoryAfterSpill(true);
            AutoCloser.close((AutoCloseable[])new AutoCloseable[]{this.mDiskDataBlocksWriter});
            throw throwable;
        }
        AutoCloser.close((AutoCloseable[])new AutoCloseable[]{this.mDiskDataBlocksWriter});
    }

    protected void spillLong(long theValue) {
        AutoCloser.close((AutoCloseable[])new AutoCloseable[]{this.mDiskDataBlocksReader});
        SpillingUtil.openDiskWriter(this.mMemoryContext.getSpillingDirectory(), this.mDiskDataBlocksWriter, this.mDataMemoryBlockChain);
        try {
            this.mDiskDataBlocksWriter.writeLong(theValue);
            this.mDataMemoryBlockChain.incrementTotalElementsCount();
            this.mDataMemoryBlockChain.incrementTotalSpilledBytes(8L);
            this.mOperationTracker.onSpilling(8L);
        }
        catch (Throwable throwable) {
            AutoCloser.close((AutoCloseable[])new AutoCloseable[]{this.mDiskDataBlocksWriter});
            throw throwable;
        }
        AutoCloser.close((AutoCloseable[])new AutoCloseable[]{this.mDiskDataBlocksWriter});
    }

    private void onSuccess() {
        DefaultMemoryBlockChain aMemoryBlockChain = this.mDataAreaAccessor.get();
        aMemoryBlockChain.incrementTotalElementsCount();
        aMemoryBlockChain.incrementMemoryElementsCount();
    }

    protected void checkSize() {
        if (this.size() <= 0L) {
            throw new NoSuchElementException();
        }
    }

    public long poll() {
        return this.fetch(true);
    }

    public long peek() {
        return this.fetch(false);
    }

    protected void checkReader() {
        if (!this.mDiskDataBlocksReader.isActive()) {
            SpillingUtil.openDiskReader(this.mDiskDataBlocksReader, this.mDataMemoryBlockChain);
        }
    }

    public void reset() {
        AutoCloser.close((AutoCloseable[])new AutoCloseable[]{this.mDiskDataBlocksWriter, this.mDiskDataBlocksReader, () -> SpillingUtil.deleteFile(this.mDataMemoryBlockChain.getSpilledFile())});
        this.mDataMemoryBlockChain.setSpilledFile(null);
        this.mDataMemoryBlockChain.reset();
    }

    protected abstract int getEndBlockIndex();

    protected abstract int getEndBlockOffset();

    protected abstract int getStartBlockIndex();

    protected abstract int getStartBlockOffset();

    public void createQueue() {
        this.createTape();
    }

    protected abstract long fetch(boolean var1);
}

