/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.impl.hashtable.spilling.impl;

import com.complexible.common.base.AutoCloser;
import com.complexible.common.base.Disposable;
import com.complexible.common.base.Disposables;
import com.complexible.common.io.ByteReader;
import com.complexible.memory.file.FileReader;
import com.complexible.memory.file.FileWriter;
import com.complexible.memory.memoryblock.MemoryBlock;
import com.complexible.memory.memoryblock.MemoryBlockChain;
import com.complexible.memory.memoryblock.MemoryBlockChainFactory;
import com.complexible.memory.memoryblock.MemoryContext;
import com.complexible.memory.structure.HashTable;
import com.complexible.memory.structure.ObjectSupplier;
import com.complexible.memory.structure.OperationTracker;
import com.complexible.memory.structure.impl.aggregator.iterator.memory.AggregatorMemoryTapeIterator;
import com.complexible.memory.structure.impl.hashtable.iterator.DiskTapeIterator;
import com.complexible.memory.structure.impl.hashtable.iterator.HashTableDiskTapeIterator;
import com.complexible.memory.structure.impl.hashtable.iterator.HashTableMemoryTapeIterator;
import com.complexible.memory.structure.impl.hashtable.iterator.HashTableTapeIterator;
import com.complexible.memory.structure.impl.hashtable.iterator.MemoryTapeIterator;
import com.complexible.memory.structure.impl.hashtable.iterator.sort.ConventionalHashTableMultiInputIterator;
import com.complexible.memory.structure.impl.hashtable.iterator.sort.HashTableMemoryInputIterator;
import com.complexible.memory.structure.impl.hashtable.iterator.sort.HashTableMultiInputIterator;
import com.complexible.memory.structure.impl.hashtable.openaddressing.DefaultOpenAddressingTable;
import com.complexible.memory.structure.impl.hashtable.spilling.ConventionalSpillingSupportedHashTable;
import com.complexible.memory.structure.impl.hashtable.spilling.impl.BaseConventionalSpillingSupportedHashTable;
import com.complexible.memory.structure.impl.tape.addressing.hashtape.ConventionalMemoryHashTape;
import com.complexible.memory.structure.iterator.ConventionalSegmentedTapeIterator;
import com.complexible.memory.structure.openaddressing.ConventionalOpenAddressingTable;
import com.complexible.memory.structure.openaddressing.OpenAddressingTable;
import com.complexible.memory.structure.sort.sorters.heap.HashTableHeapSorter;
import com.complexible.memory.structure.sort.sorters.quick.HashTableSorter;
import java.util.function.Supplier;

public final class SpillingSupportedHashTableImpl
extends BaseConventionalSpillingSupportedHashTable
implements ConventionalSpillingSupportedHashTable {
    private final HashTableSorter mQuickSorter;
    private final DiskTapeIterator mDiskIterator;
    private final MemoryTapeIterator mMemoryIterator;
    private final HashTableTapeIterator mCombinedIterator;

    public SpillingSupportedHashTableImpl(int theSpillingBufferSize, FileWriter theDiskDataBlocksWriter, FileReader theDiskDataBlocksReader, FileWriter theAddressingSpaceDefaultFileWriter, FileReader theAddressingSpaceDefaultFileReader, ConventionalMemoryHashTape theMemoryHashTable, MemoryContext theMemoryContext, MemoryBlockChainFactory theMemoryBlockChainFactory, OperationTracker theOperationTracker) {
        super(theSpillingBufferSize, theDiskDataBlocksWriter, theDiskDataBlocksReader, theAddressingSpaceDefaultFileWriter, theAddressingSpaceDefaultFileReader, theMemoryHashTable, theMemoryContext, theMemoryBlockChainFactory, theOperationTracker);
        try {
            this.mDiskIterator = this.createDiskIterator(theMemoryContext);
            this.mMemoryIterator = this.createMemoryIterator(theMemoryContext);
            this.mCombinedIterator = new HashTableTapeIterator(this.mDiskIterator, this.mMemoryIterator);
            this.mQuickSorter = new HashTableSorter(false, this.mDataMemoryBlockChainHolder, theMemoryHashTable.getDefaultComparator(), this.mMemoryContext, this.mMemoryBlockChainFactory);
            this.mAggregatorMainIterator.setUniquenessMode(true);
        }
        catch (Throwable t) {
            this.dispose();
            throw t;
        }
    }

    @Override
    public boolean contains(ByteReader theKeyReader) {
        this.checkTableForLookUp();
        ((ConventionalMemoryHashTape)this.mMemoryHashTape).initContext(theKeyReader);
        try {
            if (this.mMemoryIterator.hasNext()) {
                boolean bl = true;
                return bl;
            }
            boolean bl = this.mSpilled && this.mDiskIterator.hasNext();
            return bl;
        }
        finally {
            if (this.mSpilled) {
                this.mDiskIterator.close();
            }
            this.mMemoryIterator.close();
        }
    }

    @Override
    public HashTableTapeIterator lookUpByKey(ByteReader theKeyReader) {
        this.checkTableForLookUp();
        if (this.mSpilled) {
            this.mDiskIterator.resetSearcher();
        }
        ((ConventionalMemoryHashTape)this.mMemoryHashTape).initContext(theKeyReader);
        this.mCombinedIterator.reset();
        return this.mCombinedIterator;
    }

    @Override
    public void spillToTheDisk() {
        super.spillToTheDisk();
        this.mCombinedIterator.setUseDisk(this.mSpilled);
    }

    @Override
    public void start() {
        super.start();
        if (this.mSpilled) {
            this.mDiskIterator.openResources();
        }
    }

    @Override
    public void stop() {
        super.stop();
        if (this.mSpilled) {
            this.mDiskIterator.closeResources();
        }
    }

    @Override
    protected boolean isKeyUnique() {
        return false;
    }

    @Override
    public void reset() {
        super.reset();
        this.mCombinedIterator.setUseDisk(false);
        AutoCloser.close((AutoCloseable[])new AutoCloseable[]{this.mDiskIterator, this.mMemoryIterator});
    }

    @Override
    public void dispose() {
        AutoCloser.close((AutoCloseable[])new AutoCloseable[]{() -> super.dispose(), Disposables.asCloseable((Disposable)this.mQuickSorter), Disposables.asCloseable((Disposable)this.mDiskIterator), Disposables.asCloseable((Disposable)this.mMemoryIterator)});
    }

    @Override
    protected HashTableHeapSorter createHeapSorter(MemoryContext theMemoryContext) {
        return new HashTableHeapSorter(theMemoryContext, ((ConventionalMemoryHashTape)this.mMemoryHashTape).getDefaultComparator(), false);
    }

    @Override
    protected AggregatorMemoryTapeIterator createMemoryAggregatorIterator(MemoryContext theMemoryContext) {
        return new HashTableMemoryTapeIterator(new DefaultOpenAddressingTable(this.mMemoryHashComparator, theMemoryContext.getBlockSize()), this.mPartitionsArea, this.mOverFlowPartitionsArea, this.mDataMemoryBlockChainHolder, this.mHashTableContext, theMemoryContext);
    }

    @Override
    protected ConventionalSegmentedTapeIterator createDiskAggregatorIterator(HashTableMultiInputIterator theDiskMultiInputIterator) {
        return new HashTableDiskTapeIterator(this.mDiskDataBlocksReader, this.mAddressingSpaceDefaultFileReader, this.mDataMemoryBlockChainHolder, this.mPartitionsArea, theDiskMultiInputIterator);
    }

    @Override
    protected Class<?> getCollectionClass() {
        return HashTable.class;
    }

    @Override
    protected HashTableSorter quickSorter() {
        return this.mQuickSorter;
    }

    private MemoryTapeIterator createMemoryIterator(MemoryContext theMemoryContext) {
        return new MemoryTapeIterator(this.mPartitionsArea, this.mOverFlowPartitionsArea, this.mMemoryHashComparator, (ConventionalOpenAddressingTable)this.mOpenAddressingTable, this.mDataMemoryBlockChainHolder, this.mHashTableContext, theMemoryContext, false);
    }

    @Override
    protected ConventionalHashTableMultiInputIterator createMemoryInputIterator() {
        return new HashTableMemoryInputIterator(16, 4, (ObjectSupplier<MemoryBlock>)this.mPartitionSupplier, this.mOverFlowPartitionsArea, this.mMemoryContext, (Supplier<MemoryBlockChain>)this.mDataMemoryBlockChainHolder, (OpenAddressingTable<MemoryBlock>)this.mOpenAddressingTable);
    }
}

