/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.impl.hashtable.spilling.impl;

import com.complexible.common.base.Disposable;
import com.complexible.memory.accessor.MemoryBlockChainByteReaderWriter;
import com.complexible.memory.memoryblock.DefaultMemoryBlockChain;
import com.complexible.memory.memoryblock.MemoryBlock;
import com.complexible.memory.memoryblock.MemoryBlockChain;
import com.complexible.memory.memoryblock.MemoryBlockChainFactory;
import com.complexible.memory.memoryblock.MemoryContext;
import com.complexible.memory.structure.ObjectSupplier;
import com.complexible.memory.structure.impl.aggregator.accessor.MemoryBlockChainByteReaderWriterImpl;
import com.complexible.memory.util.Utilities;
import java.io.IOException;

final class MemoryIndex
implements MemoryBlockChainByteReaderWriter,
Disposable {
    private final DefaultMemoryBlockChain mMemoryIndexBlockChain;
    private final MemoryBlockChainByteReaderWriter mByteReaderWriter;

    MemoryIndex(MemoryBlockChainFactory theMemoryBlockChainFactory, MemoryContext theMemoryContext) {
        this.mMemoryIndexBlockChain = theMemoryBlockChainFactory.createMemoryBlockChain();
        this.mByteReaderWriter = new MemoryBlockChainByteReaderWriterImpl(new ObjectSupplier<MemoryBlockChain>(this.mMemoryIndexBlockChain), theMemoryContext);
    }

    @Override
    public MemoryBlockChain get() {
        return this.mByteReaderWriter.get();
    }

    @Override
    public void copyMemory(long theSourcePosition, long theTargetPosition, long theBytesCount) {
        this.mByteReaderWriter.copyMemory(theSourcePosition, theTargetPosition, theBytesCount);
    }

    @Override
    public void copyMemory(long theSourcePosition, long theTargetPosition, long theBytesCount, MemoryBlockChain theSourceMemoryBlockChain) {
        this.mByteReaderWriter.copyMemory(theSourcePosition, theTargetPosition, theBytesCount, theSourceMemoryBlockChain);
    }

    public long length() throws IOException {
        return this.mByteReaderWriter.length();
    }

    public boolean isOverflowed() {
        return this.mByteReaderWriter.isOverflowed();
    }

    public long getPosition() throws IOException {
        return this.mByteReaderWriter.getPosition();
    }

    public void setPosition(long thePosition) throws IOException {
        this.mByteReaderWriter.setPosition(thePosition);
    }

    public void write(byte[] theData) throws IOException {
        this.mByteReaderWriter.write(theData);
    }

    public void write(byte[] theData, int theOffset, int theLength) throws IOException {
        this.mByteReaderWriter.write(theData, theOffset, theLength);
    }

    public void writeByte(byte theValue) throws IOException {
        this.mByteReaderWriter.writeByte(theValue);
    }

    public void writeInt(int theValue) throws IOException {
        this.mByteReaderWriter.writeInt(theValue);
    }

    public void writeVInt(int theValue) throws IOException {
        this.mByteReaderWriter.writeVInt(theValue);
    }

    public void writeLong(long theValue) throws IOException {
        this.mByteReaderWriter.writeLong(theValue);
    }

    public void writeShort(short theValue) throws IOException {
        this.mByteReaderWriter.writeShort(theValue);
    }

    public void writeChar(char theChar) throws IOException {
        this.mByteReaderWriter.writeChar(theChar);
    }

    public void writeVLong(long theValue) throws IOException {
        this.mByteReaderWriter.writeVLong(theValue);
    }

    public void writeDouble(double theValue) throws IOException {
        this.mByteReaderWriter.writeDouble(theValue);
    }

    public void writeFloat(float theValue) throws IOException {
        this.mByteReaderWriter.writeFloat(theValue);
    }

    public void writeString(String theValue) throws IOException {
        this.mByteReaderWriter.writeString(theValue);
    }

    public void writeBuffer(long[] theData, int theOffset, int theLength) throws IOException {
        this.mByteReaderWriter.writeBuffer(theData, theOffset, theLength);
    }

    public int read(byte[] theData) throws IOException {
        return this.mByteReaderWriter.read(theData);
    }

    public byte readByte() throws IOException {
        return this.mByteReaderWriter.readByte();
    }

    public int readInt() throws IOException {
        return this.mByteReaderWriter.readInt();
    }

    public int readVInt() throws IOException {
        return this.mByteReaderWriter.readVInt();
    }

    public long readLong() throws IOException {
        return this.mByteReaderWriter.readLong();
    }

    public long readVLong() throws IOException {
        return this.mByteReaderWriter.readVLong();
    }

    public double readDouble() throws IOException {
        return this.mByteReaderWriter.readDouble();
    }

    public float readFloat() throws IOException {
        return this.mByteReaderWriter.readFloat();
    }

    public String readString() throws IOException {
        return this.mByteReaderWriter.readString();
    }

    public short readShort() throws IOException {
        return this.mByteReaderWriter.readShort();
    }

    public int size() {
        return this.mMemoryIndexBlockChain.size();
    }

    public void reset() {
        try {
            this.mByteReaderWriter.setPosition(0L);
        }
        catch (IOException theE) {
            throw Utilities.rethrow(theE);
        }
        this.mMemoryIndexBlockChain.reset();
    }

    public boolean obtainNext() {
        return this.mMemoryIndexBlockChain.obtainNext();
    }

    public void add(MemoryBlock theMemoryBlock) {
        this.mMemoryIndexBlockChain.add(theMemoryBlock);
    }

    public void setCurrentBlockOffset(int theOffset) {
        this.mMemoryIndexBlockChain.setCurrentBlockOffset(theOffset);
    }

    public void dispose() {
        this.mMemoryIndexBlockChain.dispose();
    }
}

