/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.impl.hashtable.spilling.impl;

import com.complexible.common.base.AutoCloser;
import com.complexible.common.base.Disposable;
import com.complexible.common.base.Disposables;
import com.complexible.memory.file.FileReader;
import com.complexible.memory.file.FileWriter;
import com.complexible.memory.memoryblock.MemoryBlock;
import com.complexible.memory.memoryblock.MemoryBlockChainFactory;
import com.complexible.memory.memoryblock.MemoryContext;
import com.complexible.memory.structure.DataArea;
import com.complexible.memory.structure.ObjectSupplier;
import com.complexible.memory.structure.OperationTracker;
import com.complexible.memory.structure.OperationType;
import com.complexible.memory.structure.OutputCollector;
import com.complexible.memory.structure.impl.hashtable.PartitionsArea;
import com.complexible.memory.structure.impl.hashtable.context.HashTableContext;
import com.complexible.memory.structure.impl.hashtable.spilling.SpillingSupportedHashTable;
import com.complexible.memory.structure.impl.hashtable.spilling.impl.MemoryIndex;
import com.complexible.memory.structure.impl.tape.MemoryBlockAddressArea;
import com.complexible.memory.structure.impl.tape.addressing.hashtape.MemoryHashTape;
import com.complexible.memory.structure.openaddressing.OpenAddressingTable;
import com.complexible.memory.structure.sort.iterator.MultiInputIterator;
import com.complexible.memory.structure.sort.sorters.Sorter;
import com.complexible.memory.structure.sort.sorters.quick.BasePower2SlotSorter;
import com.complexible.memory.structure.sort.sorters.quick.BaseSorter;
import com.complexible.memory.structure.sort.sorters.quick.SlotBaseQuickSorter;
import com.complexible.memory.util.SpillingUtil;
import com.complexible.memory.util.Utilities;
import java.io.File;
import org.apache.commons.lang3.mutable.MutableLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class BaseSpillingSupportedHashTable<I extends MultiInputIterator, S extends BasePower2SlotSorter<MemoryBlock>, O extends OutputCollector, H extends Sorter<I, O>, OT extends OpenAddressingTable<MemoryBlock>, HC extends HashTableContext, M extends MemoryHashTape<OT, HC>>
implements SpillingSupportedHashTable {
    private final Logger mLogger = LoggerFactory.getLogger(this.getCollectionClass());
    private STATUS mStatus = STATUS.ACTIVE;
    protected final File mBaseDir;
    protected final H mHeapSorter;
    protected final M mMemoryHashTape;
    protected final int mSortingChunkSize;
    protected final OT mOpenAddressingTable;
    protected final MemoryIndex mMemoryIndex;
    protected final OperationTracker mOperationTracker;
    protected final PartitionsArea mPartitionsArea;
    protected final MemoryContext mMemoryContext;
    protected final MemoryBlockAddressArea mOverFlowPartitionsArea;
    protected final MemoryBlockChainFactory mMemoryBlockChainFactory;
    protected final FileWriter mAddressingSpaceDefaultFileWriter;
    protected final FileReader mAddressingSpaceDefaultFileReader;
    protected final MutableLong mSpilledBytesCount = new MutableLong(0L);
    protected final MutableLong mPartitionSpilledElementsCount = new MutableLong(0L);
    protected final ObjectSupplier<MemoryBlock> mPartitionSupplier = new ObjectSupplier();
    protected boolean mSpilled = false;

    protected abstract Class<?> getCollectionClass();

    public BaseSpillingSupportedHashTable(int theSpillingBufferSize, FileWriter theAddressingSpaceDefaultFileWriter, FileReader theAddressingSpaceDefaultFileReader, M theMemoryHashTape, MemoryContext theMemoryContext, MemoryBlockChainFactory theMemoryBlockChainFactory, OperationTracker theOperationTracker) {
        this.mOperationTracker = SpillingUtil.resolveTracker(theOperationTracker);
        this.mBaseDir = theMemoryContext.getSpillingDirectory();
        this.mMemoryHashTape = theMemoryHashTape;
        this.mSortingChunkSize = theSpillingBufferSize;
        this.mMemoryContext = theMemoryHashTape.getMemoryContext();
        this.mMemoryBlockChainFactory = theMemoryBlockChainFactory;
        this.mAddressingSpaceDefaultFileReader = theAddressingSpaceDefaultFileReader;
        this.mAddressingSpaceDefaultFileWriter = theAddressingSpaceDefaultFileWriter;
        this.mHeapSorter = this.createHeapSorter(theMemoryContext);
        this.mPartitionsArea = (PartitionsArea)theMemoryHashTape.getTapeArea();
        this.mOverFlowPartitionsArea = theMemoryHashTape.getOverFlowPartitionsArea();
        this.mOpenAddressingTable = theMemoryHashTape.getOpenAddressingTable();
        this.mMemoryIndex = new MemoryIndex(theMemoryBlockChainFactory, theMemoryContext);
    }

    protected abstract I createBlobIterator();

    protected abstract I createMemoryDiskIterator();

    protected abstract boolean hasMemoryElements();

    protected abstract I getDualMultiInputIterator();

    protected abstract I getBlobMultiInputIterator();

    private void acquireMemoryForIndex(long theRequiredBlocksCount) {
        this.mMemoryIndex.reset();
        while ((long)this.mMemoryIndex.size() < theRequiredBlocksCount && this.mMemoryIndex.obtainNext()) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadIndexToMemory() {
        block10: {
            try {
                long aTotalSegmentCount = 0L;
                if (this.mPartitionsArea.isEmpty()) {
                    aTotalSegmentCount = this.mPartitionsArea.get().getTotalSpilledElementsCount();
                } else {
                    for (MemoryBlock aAddressPartition : this.mPartitionsArea) {
                        aTotalSegmentCount += aAddressPartition.getHeader().getLong(24L);
                    }
                }
                if (aTotalSegmentCount == 0L) {
                    return;
                }
                long aTotalRequiredMemory = Utilities.multiplyLongPowerOfTwoAsLong(aTotalSegmentCount, 3);
                long aRequiredBlocksCount = Utilities.divideLongPowerOfTwoAsLong(aTotalRequiredMemory, this.mMemoryContext.getBlockSizeBitPosition()) + (Utilities.maskLongPowerOfTwoAsLong(aTotalRequiredMemory, this.mMemoryContext.getBlockSizeMask()) == 0L ? 0L : 1L);
                this.acquireMemoryForIndex(aRequiredBlocksCount);
                if (this.mMemoryIndex.size() == 0) {
                    this.tryAcquireFromDataBlocks(aRequiredBlocksCount);
                }
                if (this.mMemoryIndex.size() <= 0) break block10;
                SpillingUtil.openDiskReader(this.mAddressingSpaceDefaultFileReader, this.mPartitionsArea.get());
                try {
                    long aRequiredSegmentCount = Math.min(aTotalSegmentCount, Utilities.divideLongPowerOfTwoAsLong(this.mMemoryIndex.length(), 3));
                    this.mMemoryIndex.reset();
                    this.loadIndex(this.mMemoryIndex, aRequiredSegmentCount);
                }
                finally {
                    this.mAddressingSpaceDefaultFileReader.close();
                }
            }
            catch (Throwable theThrowable) {
                throw Utilities.rethrow(theThrowable);
            }
        }
    }

    protected abstract void tryAcquireFromDataBlocks(long var1);

    protected abstract void loadIndex(MemoryIndex var1, long var2);

    @Override
    public void spillToTheDisk() {
        this.mSpilled = true;
        if (this.hasMemoryElements()) {
            try {
                this.mOperationTracker.onStart(OperationType.SPILLING);
                this.logTapeSpilling();
                try {
                    this.mOperationTracker.onStart(OperationType.SORTING);
                    this.sortDataInBlocks();
                }
                finally {
                    this.mOperationTracker.onDone(OperationType.SORTING);
                }
                this.sortAndSpill(this.getDualMultiInputIterator());
                this.loadIndexToMemory();
            }
            finally {
                this.mMemoryHashTape.restoreHashTableContext();
                this.mOperationTracker.onDone(OperationType.SPILLING);
            }
        }
    }

    protected void sortAndSpill(I theDualMultiInputIterator) {
        this.openIndexReader();
        File aIndexFile = this.openIndexWriter();
        try {
            this.doSortAndSpill(theDualMultiInputIterator);
        }
        finally {
            this.onSpillingDone(aIndexFile);
        }
    }

    protected void openIndexReader() {
        SpillingUtil.openDiskReader(this.mAddressingSpaceDefaultFileReader, this.mPartitionsArea.get());
    }

    protected File openIndexWriter() {
        return SpillingUtil.openDiskWriter(this.mAddressingSpaceDefaultFileWriter, this.mBaseDir);
    }

    protected void doSortAndSpill(I theDualMultiInputIterator) {
        long aSpilledBytesCount = 0L;
        this.mSpilledBytesCount.setValue(0L);
        this.mHeapSorter.setChunkSize(this.mSortingChunkSize);
        if (this.mPartitionsArea.getPartitionsCount() == 0) {
            this.spillPartition(theDualMultiInputIterator, aSpilledBytesCount, 0);
            return;
        }
        for (int aPartitionId = 0; aPartitionId < this.mPartitionsArea.getPartitionsCount(); ++aPartitionId) {
            aSpilledBytesCount = this.spillPartition(theDualMultiInputIterator, aSpilledBytesCount, aPartitionId);
        }
        this.mOverFlowPartitionsArea.disposeMemory();
    }

    protected void onSpillingDone(File theIndexFile) {
        AutoCloser.close((AutoCloseable[])new AutoCloseable[]{this.mAddressingSpaceDefaultFileWriter, this.mAddressingSpaceDefaultFileReader, () -> SpillingUtil.deleteFile(this.mPartitionsArea.get().getSpilledFile()), () -> this.mPartitionsArea.get().setSpilledFile(theIndexFile)});
    }

    protected final long spillPartition(I theDualMultiInputIterator, long theSpilledBytesCount, int thePartitionId) {
        this.mMemoryHashTape.getHashTableContext().setPartitionId(thePartitionId == this.mMemoryHashTape.getPartitionId() ? this.mMemoryHashTape.getPartitionId() : Utilities.DUMMY_INDEX);
        this.mPartitionSpilledElementsCount.setValue(0L);
        MemoryBlock aAddressPartition = this.mMemoryHashTape.getPartition(thePartitionId);
        this.doSpillPartition(theDualMultiInputIterator, aAddressPartition);
        if (aAddressPartition != null) {
            this.mMemoryHashTape.resetPartition(aAddressPartition);
        }
        long aPartitionSpilledElementsCount = this.mPartitionSpilledElementsCount.getValue();
        if (aAddressPartition != null) {
            aAddressPartition.getHeader().putLong(16L, theSpilledBytesCount);
            aAddressPartition.getHeader().putLong(24L, aPartitionSpilledElementsCount);
        } else {
            this.mPartitionsArea.get().setMemoryElementsCount(0L);
            this.mPartitionsArea.get().setTotalSpilledElementsCount(aPartitionSpilledElementsCount);
        }
        long aPartitionSpilledBytesCount = this.calculateSpilledPartitionBytes(aPartitionSpilledElementsCount);
        return theSpilledBytesCount + aPartitionSpilledBytesCount;
    }

    protected abstract long calculateSpilledPartitionBytes(long var1);

    protected abstract S quickSorter();

    protected void doSpillPartition(I mDualMultiInputIterator, MemoryBlock theAddressPartition) {
        this.mPartitionSupplier.set(theAddressPartition);
        this.mHeapSorter.assembleAll(mDualMultiInputIterator, this.getOutputCollector());
    }

    private void sortDataInBlocks() {
        this.sortBlocksInArea(this.mPartitionsArea);
        this.sortBlocksInArea(this.mOverFlowPartitionsArea);
    }

    private void sortBlocksInArea(DataArea theDataArea) {
        MemoryBlock aQuickSorter = this.quickSorter();
        for (MemoryBlock aAddressPartition : theDataArea) {
            this.mOpenAddressingTable.setMemoryAccessor((MemoryBlock)aAddressPartition);
            int aSlotCount = this.mOpenAddressingTable.getSlotsCount();
            if (aSlotCount <= 0) continue;
            this.mOperationTracker.onNext(OperationType.SORTING);
            ((SlotBaseQuickSorter)((Object)aQuickSorter)).gotoSource((MemoryBlock)aAddressPartition);
            this.mOpenAddressingTable.compactTable();
            ((BaseSorter)((Object)aQuickSorter)).sort(0L, aSlotCount);
        }
    }

    protected abstract O getOutputCollector();

    protected abstract I createMemoryInputIterator();

    @Override
    public void reset() {
        if (this.mStatus == STATUS.DISPOSED) {
            throw new IllegalStateException("Collection has already been disposed");
        }
        this.mSpilled = false;
        this.setActive();
        this.mMemoryHashTape.resetPartitions();
        this.getDualMultiInputIterator().reset();
        this.getBlobMultiInputIterator().reset();
        AutoCloser.close((AutoCloseable[])new AutoCloseable[]{this.mAddressingSpaceDefaultFileWriter, this.mAddressingSpaceDefaultFileReader});
    }

    public void dispose() {
        this.setDisposed();
        AutoCloser.close((AutoCloseable[])new AutoCloseable[]{Disposables.asCloseable(this.mHeapSorter), Disposables.asCloseable((Disposable)this.mMemoryIndex), () -> this.mPartitionSupplier.set(null), Disposables.asCloseable(this.getDualMultiInputIterator()), Disposables.asCloseable(this.getBlobMultiInputIterator())});
    }

    private void logTapeSpilling() {
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug("Collection " + String.valueOf(this.getCollectionClass()) + " started spilling process ... ");
        }
    }

    protected void checkTableForLookUp() {
        if (!this.isOpened()) {
            throw new IllegalStateException("HashTable should be opened for lookup - use start method");
        }
    }

    protected abstract H createHeapSorter(MemoryContext var1);

    @Override
    public void setOpened() {
        this.mStatus = STATUS.OPENED;
    }

    @Override
    public void setDisposed() {
        this.mStatus = STATUS.DISPOSED;
    }

    @Override
    public void setActive() {
        this.mStatus = STATUS.ACTIVE;
    }

    @Override
    public void setIterating() {
        this.mStatus = STATUS.ITERATING;
    }

    @Override
    public boolean isActive() {
        return this.mStatus == STATUS.ACTIVE;
    }

    @Override
    public boolean isDisposed() {
        return this.mStatus == STATUS.DISPOSED;
    }

    @Override
    public boolean isOpened() {
        return this.mStatus == STATUS.OPENED;
    }

    @Override
    public boolean isIterating() {
        return this.mStatus == STATUS.ITERATING;
    }

    private static enum STATUS {
        ACTIVE,
        DISPOSED,
        OPENED,
        ITERATING;

    }
}

