/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.impl.hashtable.openaddressing;

import com.complexible.common.io.ByteReader;
import com.complexible.memory.memoryblock.MemoryBlock;
import com.complexible.memory.structure.impl.hashtable.comparator.HashComparator;
import com.complexible.memory.structure.impl.hashtable.openaddressing.BaseOpenAddressingTable;
import com.complexible.memory.structure.impl.hashtable.openaddressing.DefaultOpenAddressingIterator;
import com.complexible.memory.structure.openaddressing.ConventionalOpenAddressingTable;
import com.complexible.memory.structure.openaddressing.OpenAddressingIterator;
import com.complexible.memory.util.Utilities;

public final class DefaultOpenAddressingTable
extends BaseOpenAddressingTable<MemoryBlock>
implements ConventionalOpenAddressingTable<MemoryBlock> {
    static final byte UNASSIGNED_BYTE = -1;
    private final HashComparator mHashComparator;

    public DefaultOpenAddressingTable(HashComparator theHashComparator, int theActualBlockSize) {
        super(16, theActualBlockSize / 16);
        this.mHashComparator = theHashComparator;
    }

    @Override
    public int putIfAbsent(long theSegmentDataAddress, int theHashCode) {
        this.checkTableInitiated();
        int aSlot = Utilities.maskIntPowerOfTwoAsInt(theHashCode, this.mask());
        int aHashCodeCellAddress = this.getHashCodeCellAddress0(aSlot);
        while (this.isSlotUsed(aSlot)) {
            if (this.equal(aSlot, aHashCodeCellAddress, theHashCode, theSegmentDataAddress)) {
                return -aHashCodeCellAddress;
            }
            aSlot = this.nextProbe(aSlot);
            aHashCodeCellAddress = this.getHashCodeCellAddress0(aSlot);
        }
        this.incrementSlotCount();
        ((MemoryBlock)this.mMemoryAccessor).putLong(this.getSegmentCellAddress0(aSlot), theSegmentDataAddress);
        ((MemoryBlock)this.mMemoryAccessor).putInt(aHashCodeCellAddress, theHashCode);
        return aHashCodeCellAddress;
    }

    @Override
    public long lookUp(ByteReader theKeyReader, int theHashCode) {
        this.checkTableInitiated();
        int aSlot = Utilities.maskIntPowerOfTwoAsInt(theHashCode, this.mask());
        long wrappedAround = aSlot;
        int aHashCodeCellAddress = this.getHashCodeCellAddress0(aSlot);
        while (this.isSlotUsed(aSlot)) {
            long aSegmentDataAddress;
            long aSlotHashCode = ((MemoryBlock)this.mMemoryAccessor).getInt(aHashCodeCellAddress);
            if (aSlotHashCode == (long)theHashCode && (aSegmentDataAddress = this.getSegmentDataAddress0(this.mTableAddress, aSlot)) >= 0L && this.mHashComparator.equal(theKeyReader, aSegmentDataAddress)) {
                return aSegmentDataAddress;
            }
            if ((long)(aSlot = this.nextProbe(aSlot)) == wrappedAround) break;
            aHashCodeCellAddress = this.getHashCodeCellAddress0(aSlot);
        }
        return -1L;
    }

    @Override
    public int lookUpSlot(ByteReader theKeyReader, int theHashCode) {
        this.checkTableInitiated();
        int aSlot = Utilities.maskIntPowerOfTwoAsInt(theHashCode, this.mask());
        long wrappedAround = aSlot;
        int aHashCodeCellAddress = this.getHashCodeCellAddress0(aSlot);
        while (this.isSlotUsed(aSlot)) {
            long aSegmentDataAddress;
            long slotHashCode = ((MemoryBlock)this.mMemoryAccessor).getInt(aHashCodeCellAddress);
            if (slotHashCode == (long)theHashCode && (aSegmentDataAddress = this.getSegmentDataAddress0(this.mTableAddress, aSlot)) >= 0L && this.mHashComparator.equal(theKeyReader, aSegmentDataAddress)) {
                return this.getSegmentCellAddress0(aSlot);
            }
            aSlot = this.nextProbe(aSlot);
            aHashCodeCellAddress = this.getHashCodeCellAddress0(aSlot);
            if ((long)aSlot != wrappedAround) continue;
            break;
        }
        return -1;
    }

    @Override
    public int searchSlot(ByteReader theKeyReader, int theHashCode) {
        this.checkTableInitiated();
        int aSlot = Utilities.maskIntPowerOfTwoAsInt(theHashCode, this.mask());
        long wrappedAround = aSlot;
        int aHashCodeCellAddress = this.getHashCodeCellAddress0(aSlot);
        while (this.isSlotUsed(aSlot)) {
            long slotElementAddress;
            long slotHashCode = ((MemoryBlock)this.mMemoryAccessor).getInt(aHashCodeCellAddress);
            if (slotHashCode == (long)theHashCode && (slotElementAddress = ((MemoryBlock)this.mMemoryAccessor).getLong(this.getSegmentCellAddress0(aSlot))) >= 0L && this.mHashComparator.equal(theKeyReader, slotElementAddress)) {
                return -aHashCodeCellAddress;
            }
            if ((long)(aSlot = this.nextProbe(aSlot)) == wrappedAround) break;
            aHashCodeCellAddress = this.getHashCodeCellAddress0(aSlot);
        }
        return aHashCodeCellAddress;
    }

    @Override
    public int findAvailableSlot(int theHashCode) {
        this.checkTableInitiated();
        if (!this.checkExpansionThreshold()) {
            return -1;
        }
        int aSlot = Utilities.maskIntPowerOfTwoAsInt(theHashCode, this.mask());
        while (this.isSlotUsed(aSlot)) {
            aSlot = this.nextProbe(aSlot);
        }
        return this.slotBase(this.mTableAddress, aSlot);
    }

    @Override
    public void assign(long payload, long theSegmentDataAddress, int theCachedHashCode) {
        int aHashCodeCellAddress = (int)payload;
        long aSegmentCellAddress = ConventionalOpenAddressingTable.getSegmentCellAddress(aHashCodeCellAddress);
        ((MemoryBlock)this.mMemoryAccessor).putLong(aSegmentCellAddress, theSegmentDataAddress);
        ((MemoryBlock)this.mMemoryAccessor).putInt(aHashCodeCellAddress, theCachedHashCode);
        this.incrementSlotCount();
    }

    @Override
    protected void createTable(int theTableCapacity) {
        this.mTableAddress = 0;
        this.setSlotCount(0);
        this.releaseAllSlots();
    }

    @Override
    protected void setSlotCount(int theNewSize) {
        ((MemoryBlock)this.mMemoryAccessor).getHeader().putLong(0L, theNewSize);
    }

    @Override
    public void incrementSlotCount() {
        this.setSlotCount(this.getSlotsCount() + 1);
    }

    @Override
    public void decrementSlotCount() {
        this.setSlotCount(this.getSlotsCount() - 1);
    }

    @Override
    public OpenAddressingIterator iterator() {
        return new DefaultOpenAddressingIterator(this);
    }

    @Override
    public int getSlotsCount() {
        return (int)((MemoryBlock)this.mMemoryAccessor).getHeader().getLong(0L);
    }

    @Override
    public long payload() {
        return ((MemoryBlock)this.mMemoryAccessor).getHeader().getLong(8L);
    }

    @Override
    public void setPayLoad(long thePayLoad) {
        if (this.mMemoryAccessor != null) {
            ((MemoryBlock)this.mMemoryAccessor).getHeader().putLong(8L, thePayLoad);
        }
    }

    @Override
    public void restoreTable() {
        long aCapacity = this.getTableCapacity();
        int aSlotNumber = 0;
        while ((long)aSlotNumber < aCapacity) {
            long aSlotBaseAddress;
            long aSegmentAddress;
            if (this.isSlotUsed(aSlotNumber) && (aSegmentAddress = ((MemoryBlock)this.mMemoryAccessor).getLong(aSlotBaseAddress = (long)this.slotBase(this.mTableAddress, aSlotNumber))) < 0L) {
                if (aSegmentAddress == Long.MIN_VALUE) {
                    ((MemoryBlock)this.mMemoryAccessor).putLong(aSlotBaseAddress, 0L);
                } else if (aSegmentAddress == Utilities.PRE_MIN_LONG_VALUE) {
                    ((MemoryBlock)this.mMemoryAccessor).putLong(aSlotBaseAddress, 0L);
                } else {
                    ((MemoryBlock)this.mMemoryAccessor).putLong(aSlotBaseAddress, -aSegmentAddress);
                }
                this.incrementSlotCount();
            }
            ++aSlotNumber;
        }
    }

    @Override
    protected boolean isSlotUsed(int theSlot) {
        return this.isSlotUsed(this.mTableAddress, theSlot);
    }

    private boolean equal(int theSlot, int theHashCodeCellAddress, int theHashCode, long theSegmentDataAddress) {
        return ((MemoryBlock)this.mMemoryAccessor).getInt(theHashCodeCellAddress) == theHashCode && this.mHashComparator.equal(this.getSegmentDataAddress0(this.mTableAddress, theSlot), theSegmentDataAddress);
    }

    private boolean isSlotUsed(int theBaseAddress, int theSlot) {
        return ((MemoryBlock)this.mMemoryAccessor).getLong(this.slotBase(theBaseAddress, theSlot)) != -1L;
    }

    private int getSegmentCellAddress0(int theSlot) {
        return this.slotBase(this.mTableAddress, theSlot) + 0;
    }

    private int getHashCodeCellAddress0(int theSlot) {
        return this.slotBase(this.mTableAddress, theSlot) + 8;
    }

    private long getSegmentDataAddress0(int theBaseAddress, int theSlot) {
        return ((MemoryBlock)this.mMemoryAccessor).getLong(this.slotBase(theBaseAddress, theSlot));
    }

    private void releaseAllSlots() {
        ((MemoryBlock)this.mMemoryAccessor).setMemory(this.mTableAddress, ((MemoryBlock)this.mMemoryAccessor).getBlockSize(), (byte)-1);
    }
}

