/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.impl.hashtable.openaddressing;

import com.complexible.memory.structure.impl.hashtable.openaddressing.BaseOpenAddressingTable;
import com.complexible.memory.structure.openaddressing.OpenAddressingIterator;
import com.complexible.memory.util.Utilities;

class DefaultOpenAddressingIterator
implements OpenAddressingIterator {
    int mCurrentSlot;
    private final BaseOpenAddressingTable mTableBase;

    public DefaultOpenAddressingIterator(BaseOpenAddressingTable theTableBase) {
        this.mTableBase = theTableBase;
        this.reset();
    }

    @Override
    public final void reset() {
        this.mCurrentSlot = Utilities.DUMMY_INDEX;
    }

    @Override
    public final boolean hasNext() {
        this.mTableBase.checkTableInitiated();
        if (this.checkNext()) {
            return true;
        }
        this.mCurrentSlot = Integer.MIN_VALUE;
        return false;
    }

    @Override
    public final int slotAddress() {
        return this.mTableBase.slotBase(this.mTableBase.baseTableAddress(), this.mCurrentSlot);
    }

    private boolean checkNext() {
        int capacity = this.mTableBase.getTableCapacity();
        for (int slot = this.mCurrentSlot + 1; slot < capacity; ++slot) {
            if (!this.mTableBase.isSlotUsed(slot)) continue;
            this.mCurrentSlot = slot;
            return true;
        }
        return false;
    }
}

