/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.impl.hashtable.iterator.sort;

import com.complexible.memory.file.FileReader;
import com.complexible.memory.memoryblock.MemoryBlock;
import com.complexible.memory.structure.ObjectSupplier;
import com.complexible.memory.structure.impl.hashtable.PartitionsArea;
import com.complexible.memory.structure.sort.iterator.LongOptimizedMultiInputIterator;
import com.complexible.memory.util.Utilities;
import java.io.IOException;

public final class LongHashSetDiskIterator
implements LongOptimizedMultiInputIterator {
    private long mLongValue;
    private long mSlotsCounter;
    private final PartitionsArea mPartitionsArea;
    private final FileReader mFileReader;
    private final ObjectSupplier<MemoryBlock> mPartitionHolder;

    public LongHashSetDiskIterator(PartitionsArea thePartitionsArea, ObjectSupplier<MemoryBlock> thePartitionHolder, FileReader theFileReader) {
        this.mFileReader = theFileReader;
        this.mPartitionsArea = thePartitionsArea;
        this.mPartitionHolder = thePartitionHolder;
    }

    @Override
    public long longValue(int theInputId, int theOffset) {
        return this.mLongValue;
    }

    @Override
    public boolean next(int theInputId) {
        if (this.mSlotsCounter <= 0L) {
            return false;
        }
        if (!this.mFileReader.checkAvailable(8)) {
            throw new IllegalStateException("Can't read next long value - end of file");
        }
        --this.mSlotsCounter;
        try {
            this.mLongValue = this.mFileReader.readLong();
        }
        catch (IOException theE) {
            throw Utilities.rethrow(theE);
        }
        return true;
    }

    @Override
    public void reset() {
        this.mSlotsCounter = this.mPartitionHolder.get() != null ? this.mPartitionHolder.get().getHeader().getLong(24L) : (this.mPartitionsArea.get() != null ? this.mPartitionsArea.get().getTotalSpilledElementsCount() : 0L);
    }

    @Override
    public void dispose() {
        this.mFileReader.close();
    }
}

