/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.impl.hashtable.iterator.sort;

import com.complexible.common.base.AutoCloser;
import com.complexible.memory.file.FileReader;
import com.complexible.memory.memoryblock.MemoryBlock;
import com.complexible.memory.memoryblock.MemoryBlockChainFactory;
import com.complexible.memory.memoryblock.MemoryContext;
import com.complexible.memory.structure.ObjectSupplier;
import com.complexible.memory.structure.impl.hashtable.PartitionsArea;
import com.complexible.memory.structure.impl.hashtable.input.DefaultHashTableTapeElementInputFactory;
import com.complexible.memory.structure.impl.hashtable.iterator.sort.ConventionalHashTableMultiInputIterator;
import com.complexible.memory.structure.impl.hashtable.source.HashTableSlotByteReader;
import com.complexible.memory.structure.input.HashTableTapeElementInput;
import com.complexible.memory.structure.input.HashTableTapeElementInputFactory;
import com.complexible.memory.util.Utilities;
import java.io.IOException;

public final class HashTableDiskInputIterator
implements ConventionalHashTableMultiInputIterator {
    private static final int SLOT_SIZE = 24;
    private long mSlotsCounter;
    private long mRecordsCount;
    private final PartitionsArea mPartitionsArea;
    private HashTableTapeElementInput mTapeElementInput;
    private final FileReader mDataFileReader;
    private final ObjectSupplier<MemoryBlock> mPartitionHolder;
    private final HashTableSlotByteReader mHashTableSlotByteReader;
    private final HashTableTapeElementInputFactory mTapeElementInputFactory;
    private final FileReader mAddressingSpaceDefaultFileReader;

    public HashTableDiskInputIterator(MemoryContext theMemoryContext, PartitionsArea thePartitionsArea, MemoryBlockChainFactory theMemoryBlockChainFactory, ObjectSupplier<MemoryBlock> thePartitionHolder, FileReader theAddressingSpaceDefaultFileReader, FileReader theDataFileReader) {
        this.mPartitionsArea = thePartitionsArea;
        this.mDataFileReader = theDataFileReader;
        this.mPartitionHolder = thePartitionHolder;
        this.mAddressingSpaceDefaultFileReader = theAddressingSpaceDefaultFileReader;
        this.mHashTableSlotByteReader = new HashTableSlotByteReader(theMemoryContext.isUseBigEndian(), 24);
        this.mTapeElementInputFactory = new DefaultHashTableTapeElementInputFactory(theMemoryContext, theMemoryBlockChainFactory);
    }

    @Override
    public boolean next(int theInputId) {
        if (this.mSlotsCounter <= 0L) {
            this.finishCurrentInput();
            this.mTapeElementInputFactory.reset();
            return false;
        }
        if (!this.mAddressingSpaceDefaultFileReader.checkAvailable(24)) {
            throw new IllegalStateException("Can't read next slot - end of file");
        }
        --this.mSlotsCounter;
        this.finishCurrentInput();
        this.mDataFileReader.moveForward(16L);
        this.mTapeElementInput = this.createTapeElementInput();
        try {
            long theSegmentAddress = this.mAddressingSpaceDefaultFileReader.readLong();
            int theHashCode = this.mAddressingSpaceDefaultFileReader.readInt();
            int thePartitionHashCode = this.mAddressingSpaceDefaultFileReader.readInt();
            long theRecordsCount = this.mAddressingSpaceDefaultFileReader.readLong();
            this.mHashTableSlotByteReader.setSlot(theSegmentAddress, theHashCode, thePartitionHashCode, theRecordsCount);
            this.mRecordsCount = theRecordsCount - 1L;
        }
        catch (IOException theE) {
            throw Utilities.rethrow(theE);
        }
        return true;
    }

    @Override
    public HashTableTapeElementInput getInput(int theInputId) {
        return this.createInput(theInputId, this.mTapeElementInputFactory);
    }

    @Override
    public HashTableTapeElementInput createInput(int theInputId, HashTableTapeElementInputFactory theATapeElementInputFactory) {
        return (HashTableTapeElementInput)this.mTapeElementInputFactory.createByteReaderInput(this.mHashTableSlotByteReader);
    }

    @Override
    public HashTableTapeElementInput getDataInput(int theInputId) {
        return this.mTapeElementInput;
    }

    @Override
    public boolean hasNextDataInput() {
        if (this.mRecordsCount == 0L) {
            return false;
        }
        --this.mRecordsCount;
        return true;
    }

    @Override
    public HashTableTapeElementInput getNextDataInput() {
        this.mTapeElementInput = this.createTapeElementInput();
        return this.mTapeElementInput;
    }

    private void finishCurrentInput() {
        if (this.mTapeElementInput != null) {
            this.mTapeElementInput.finish();
        }
        this.mTapeElementInput = null;
    }

    @Override
    public void reset() {
        this.mRecordsCount = 0L;
        this.finishCurrentInput();
        this.mSlotsCounter = this.mPartitionHolder.get() != null ? this.mPartitionHolder.get().getHeader().getLong(24L) : (this.mPartitionsArea.get() != null ? this.mPartitionsArea.get().getTotalSpilledElementsCount() : 0L);
    }

    @Override
    public void dispose() {
        this.mRecordsCount = 0L;
        this.mSlotsCounter = 0L;
        this.mTapeElementInput = null;
        AutoCloseable[] autoCloseableArray = new AutoCloseable[3];
        autoCloseableArray[0] = () -> ((HashTableTapeElementInputFactory)this.mTapeElementInputFactory).dispose();
        autoCloseableArray[1] = this.mDataFileReader;
        autoCloseableArray[2] = this.mAddressingSpaceDefaultFileReader;
        AutoCloser.close((AutoCloseable[])autoCloseableArray);
    }

    private HashTableTapeElementInput createTapeElementInput() {
        return (HashTableTapeElementInput)this.mTapeElementInputFactory.createSpillingInput(this.mDataFileReader);
    }
}

