/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.impl.hashtable.iterator.sort;

import com.complexible.common.io.ByteReader;
import com.complexible.memory.memoryblock.MemoryContext;
import com.complexible.memory.structure.ObjectSupplier;
import com.complexible.memory.structure.impl.hashtable.context.ConventionalHashTableContext;
import com.complexible.memory.structure.impl.hashtable.input.DefaultHashTableTapeElementInputFactory;
import com.complexible.memory.structure.impl.hashtable.iterator.sort.ConventionalHashTableMultiInputIterator;
import com.complexible.memory.structure.impl.hashtable.source.HashTableSlotByteReader;
import com.complexible.memory.structure.input.HashTableTapeElementInput;
import com.complexible.memory.structure.input.HashTableTapeElementInputFactory;
import com.complexible.memory.util.Utilities;

public final class HashTableByteReaderInputIterator
implements ConventionalHashTableMultiInputIterator {
    private boolean mRecordMatching;
    private HashTableTapeElementInput mTapeElementInput;
    private final ConventionalHashTableContext mHashTableContext;
    private final ObjectSupplier<ByteReader> mReaderObjectSupplier;
    private final HashTableSlotByteReader mHashTableSlotByteReader;
    private final HashTableTapeElementInputFactory mTapeElementInputFactory;

    public HashTableByteReaderInputIterator(MemoryContext theMemoryContext, ConventionalHashTableContext theHashTableContext, ObjectSupplier<ByteReader> theReaderObjectSupplier, HashTableSlotByteReader theHashTableSlotByteReader) {
        this.mHashTableContext = theHashTableContext;
        this.mReaderObjectSupplier = theReaderObjectSupplier;
        this.mHashTableSlotByteReader = theHashTableSlotByteReader;
        this.mTapeElementInputFactory = new DefaultHashTableTapeElementInputFactory(theMemoryContext);
        this.mTapeElementInputFactory.setElementHeader(false);
        this.mTapeElementInputFactory.setUniquenessMode(true);
    }

    @Override
    public boolean next(int theInputId) {
        if (this.mRecordMatching) {
            return false;
        }
        this.mRecordMatching = true;
        return true;
    }

    @Override
    public HashTableTapeElementInput getInput(int theInputId) {
        HashTableTapeElementInput aTapeElementInput = this.mTapeElementInput;
        if (aTapeElementInput == null) {
            return this.createInput(theInputId, this.mTapeElementInputFactory);
        }
        aTapeElementInput.reset();
        return aTapeElementInput;
    }

    @Override
    public HashTableTapeElementInput createInput(int theInputId, HashTableTapeElementInputFactory theTapeElementInputFactory) {
        HashTableTapeElementInput aTapeElementInput;
        this.mTapeElementInput = aTapeElementInput = (HashTableTapeElementInput)theTapeElementInputFactory.createByteReaderInput(this.mHashTableSlotByteReader);
        return aTapeElementInput;
    }

    @Override
    public HashTableTapeElementInput getDataInput(int theInputId) {
        return (HashTableTapeElementInput)this.mTapeElementInputFactory.createByteReaderInput(this.mReaderObjectSupplier.get());
    }

    @Override
    public void reset() {
        this.mTapeElementInput = null;
        this.mRecordMatching = this.mHashTableContext.getPartitionId() == Utilities.DUMMY_INDEX;
    }

    @Override
    public void dispose() {
        this.reset();
        this.mReaderObjectSupplier.set(null);
        this.mTapeElementInputFactory.dispose();
    }
}

