/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.impl.hashtable.iterator.hashset;

import com.complexible.common.io.ByteReader;
import com.complexible.memory.file.FileReader;
import com.complexible.memory.structure.BaseLongTapeIterator;
import com.complexible.memory.structure.impl.array.sorted.index.BinaryIndex;
import com.complexible.memory.structure.impl.array.sorted.index.DiskIndex;
import com.complexible.memory.structure.impl.hashtable.PartitionsArea;
import com.complexible.memory.structure.impl.hashtable.context.LongHashTableContext;
import com.complexible.memory.structure.search.LongHashSetBinarySearcher;
import com.complexible.memory.structure.search.LongHashSetDiskBinarySearcher;

public final class LongHashSetDiskTapeIterator
extends BaseLongTapeIterator {
    private long mLongValue;
    private boolean isLookedUp;
    private final BinaryIndex mDiskIndex;
    private final PartitionsArea mPartitionsArea;
    private final LongHashSetBinarySearcher mSearcher;
    private final LongHashTableContext mHashTableContext;

    public LongHashSetDiskTapeIterator(PartitionsArea thePartitionsArea, LongHashTableContext theHashTableContext, FileReader theDataFileReader, ByteReader theMemoryIndex) {
        this.mPartitionsArea = thePartitionsArea;
        this.mHashTableContext = theHashTableContext;
        this.mDiskIndex = new DiskIndex(theDataFileReader, thePartitionsArea, thePartitionsArea);
        this.mSearcher = new LongHashSetDiskBinarySearcher(theHashTableContext, theMemoryIndex);
        this.mSearcher.init(this.mDiskIndex);
    }

    public void openResources() {
        this.reset0();
        this.mDiskIndex.open();
    }

    public void closeResources() {
        this.reset();
    }

    @Override
    protected boolean hasNext0() {
        if (this.isLookedUp) {
            return false;
        }
        if (this.partitionIndexSlotCount() <= 0L) {
            return false;
        }
        try {
            boolean bl = this.search();
            return bl;
        }
        finally {
            this.isLookedUp = true;
        }
    }

    @Override
    protected long next0() {
        return this.mLongValue;
    }

    @Override
    protected void reset0() {
        this.isLookedUp = false;
    }

    @Override
    protected void close0() {
        this.reset0();
    }

    private boolean search() {
        long aSlotNumber = this.mSearcher.search(this.mHashTableContext, this.partitionIndexSlotCount());
        if (aSlotNumber < 0L) {
            return false;
        }
        this.mLongValue = this.mSearcher.getActualLongValue();
        return true;
    }

    private long partitionIndexSlotCount() {
        if (this.mHashTableContext.getPartition() != null) {
            return this.mHashTableContext.getPartition().getHeader().getLong(24L);
        }
        return this.mPartitionsArea.get().getTotalSpilledElementsCount();
    }
}

