/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.impl.hashtable.iterator;

import com.complexible.common.io.ByteReader;
import com.complexible.memory.memoryblock.MemoryBlock;
import com.complexible.memory.memoryblock.MemoryBlockChain;
import com.complexible.memory.memoryblock.MemoryContext;
import com.complexible.memory.structure.impl.hashtable.PartitionsArea;
import com.complexible.memory.structure.impl.hashtable.comparator.HashComparator;
import com.complexible.memory.structure.impl.hashtable.context.ConventionalHashTableContext;
import com.complexible.memory.structure.impl.hashtable.input.DefaultHashTableTapeElementInputFactory;
import com.complexible.memory.structure.impl.hashtable.iterator.BaseConventionalHashTableTapeIterator;
import com.complexible.memory.structure.impl.tape.MemoryBlockAddressArea;
import com.complexible.memory.structure.input.HashTableTapeElementInput;
import com.complexible.memory.structure.input.HashTableTapeElementInputFactory;
import com.complexible.memory.structure.openaddressing.ConventionalOpenAddressingTable;
import com.complexible.memory.util.Utilities;
import java.util.function.Supplier;

public class MemoryTapeIterator
extends BaseConventionalHashTableTapeIterator<HashTableTapeElementInput> {
    protected boolean isActive;
    protected long mNextAddress;
    protected boolean mKeyUniqueness;
    protected boolean mIsElementHeader;
    protected MemoryBlock mPartitionMemoryBlock;
    protected final MemoryContext mMemoryContext;
    protected final HashComparator mHashComparator;
    protected final Supplier<MemoryBlockChain> mDataMemoryBlockChainHolder;
    protected final HashTableTapeElementInputFactory mTapeElementInputFactory;
    protected final ConventionalOpenAddressingTable<MemoryBlock> mOpenAddressingTable;

    public MemoryTapeIterator(PartitionsArea thePartitionsArea, MemoryBlockAddressArea theOverFlowPartitionsArea, HashComparator theMemoryHashComparator, ConventionalOpenAddressingTable<MemoryBlock> theOpenAddressingTable, Supplier<MemoryBlockChain> theDataMemoryBlockChainHolder, ConventionalHashTableContext theHashTableContext, MemoryContext theMemoryContext, boolean theKeyUniqueness) {
        super(thePartitionsArea, theOverFlowPartitionsArea, theHashTableContext);
        this.mMemoryContext = theMemoryContext;
        this.mHashComparator = theMemoryHashComparator;
        this.mOpenAddressingTable = theOpenAddressingTable;
        this.mDataMemoryBlockChainHolder = theDataMemoryBlockChainHolder;
        this.mTapeElementInputFactory = new DefaultHashTableTapeElementInputFactory(theMemoryContext);
        this.mTapeElementInputFactory.setUniquenessMode(theKeyUniqueness);
        this.mKeyUniqueness = theKeyUniqueness;
    }

    @Override
    public boolean hasNext0() {
        if (!this.isActive) {
            return this.activateIterator();
        }
        if (this.mNextAddress != -1L) {
            this.processNextAddress();
            return true;
        }
        return this.checkNextMemoryBlock() && this.processPartitionMemoryBlock();
    }

    @Override
    public void reset0() {
        this.isActive = false;
        this.mIsElementHeader = false;
        this.mPartitionMemoryBlock = null;
        this.mNextAddress = -1L;
    }

    @Override
    protected void close0() {
        this.reset0();
    }

    @Override
    public void dispose0() {
        super.dispose0();
        this.mHashComparator.dispose();
        this.mTapeElementInputFactory.dispose();
        this.mOpenAddressingTable.setMemoryAccessor(null);
    }

    private boolean activateIterator() {
        this.isActive = true;
        return this.checkNextMemoryBlock() && this.processPartitionMemoryBlock();
    }

    private void activateHeader() {
        this.mHashComparator.reset();
        this.mIsElementHeader = false;
        this.mNextAddress = -1L;
    }

    private long lookUp() {
        this.mOpenAddressingTable.initOpenAddressing(this.mPartitionMemoryBlock);
        ByteReader keyReader = this.mHashTableContext.getKeyReader();
        this.resetReader(keyReader);
        return this.mOpenAddressingTable.lookUp(keyReader, this.mHashTableContext.getCachedHashCode());
    }

    protected void processNextAddress() {
        MemoryBlockChain aMemoryBlockChain = this.mDataMemoryBlockChainHolder.get();
        int theDataBlockOffset = Utilities.maskLongPowerOfTwoAsInt(this.mNextAddress, this.mMemoryContext.getBlockSizeMask());
        int theDataBlockIndex = Utilities.divideLongPowerOfTwoAsInt(this.mNextAddress, this.mMemoryContext.getBlockSizeBitPosition());
        this.mTapeElementInputFactory.setElementHeader(this.mIsElementHeader);
        this.mTapeElementInput = this.mTapeElementInputFactory.createMemoryInput(aMemoryBlockChain, theDataBlockOffset, theDataBlockIndex);
        this.mNextAddress = ((HashTableTapeElementInput)this.mTapeElementInput).readNextElementAddress(true);
        this.mIsElementHeader = false;
    }

    private boolean processPartitionMemoryBlock() {
        this.activateHeader();
        do {
            long aAddress;
            if (!this.processHeader(aAddress = this.lookUp())) continue;
            return true;
        } while (this.checkNextMemoryBlock());
        return false;
    }

    protected boolean checkNextMemoryBlock() {
        if (this.mPartitionMemoryBlock == null) {
            return this.initFirstMemoryBlock();
        }
        if (this.mPartitionMemoryBlock == this.mHashTableContext.getPartition()) {
            this.reset0();
            return false;
        }
        int aNextOverFlowBlockId = this.mPartitionMemoryBlock.getHeader().getInt(32L);
        if (aNextOverFlowBlockId < 0) {
            this.mPartitionMemoryBlock = this.mHashTableContext.getPartition();
            return true;
        }
        this.mPartitionMemoryBlock = this.mOverFlowPartitionsArea.getMemoryBlock(aNextOverFlowBlockId);
        return true;
    }

    protected boolean processHeader(long theAddress) {
        if (theAddress != -1L) {
            this.mTapeElementInput = this.mHashComparator.getActualInput();
            this.mNextAddress = ((HashTableTapeElementInput)this.mTapeElementInput).readNextElementAddress(true);
            this.mIsElementHeader = false;
            return true;
        }
        return false;
    }

    private boolean initFirstMemoryBlock() {
        this.mPartitionMemoryBlock = this.mHashTableContext.getPartition();
        if (this.mPartitionMemoryBlock == null) {
            return false;
        }
        int aFirstOverFlowBlockId = this.mPartitionMemoryBlock.getHeader().getInt(32L);
        if (aFirstOverFlowBlockId >= 0) {
            this.mPartitionMemoryBlock = this.mOverFlowPartitionsArea.getMemoryBlock(aFirstOverFlowBlockId);
        }
        return true;
    }
}

