/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.impl.hashtable.iterator;

import com.complexible.common.base.AutoCloser;
import com.complexible.memory.structure.BaseConventionalTapeIterator;
import com.complexible.memory.structure.TapeIterator;
import com.complexible.memory.structure.impl.hashtable.iterator.DiskTapeIterator;
import com.complexible.memory.structure.impl.hashtable.iterator.MemoryTapeIterator;
import com.complexible.memory.structure.input.TapeElementInput;

public final class HashTableTapeIterator
extends BaseConventionalTapeIterator<TapeElementInput> {
    private final DiskTapeIterator mDiskTapeIterator;
    private final MemoryTapeIterator mMemoryTapeIterator;
    private boolean mDiskDone;
    private boolean mMemoryDone;
    private boolean mUseDisk = false;

    public HashTableTapeIterator(DiskTapeIterator theDiskTapeIterator, MemoryTapeIterator theMemoryTapeIterator) {
        this.mDiskTapeIterator = theDiskTapeIterator;
        this.mMemoryTapeIterator = theMemoryTapeIterator;
        this.reset();
    }

    public void setUseDisk(boolean theUseDisk) {
        this.mUseDisk = theUseDisk;
    }

    @Override
    public boolean hasNext0() {
        return this.checkDisk() || this.checkMemory();
    }

    @Override
    public TapeElementInput next0() {
        return this.mTapeElementInput;
    }

    @Override
    public void reset0() {
        this.mDiskDone = false;
        this.mMemoryDone = false;
        if (this.mUseDisk) {
            this.mDiskTapeIterator.reset();
        }
        this.mMemoryTapeIterator.reset();
    }

    @Override
    protected void close0() {
        this.mDiskDone = false;
        this.mMemoryDone = false;
        if (this.mUseDisk) {
            this.mDiskTapeIterator.close();
        }
        this.mMemoryTapeIterator.close();
    }

    @Override
    public void dispose0() {
        AutoCloseable[] autoCloseableArray = new AutoCloseable[3];
        autoCloseableArray[0] = this::close0;
        autoCloseableArray[1] = this.mDiskTapeIterator::dispose;
        autoCloseableArray[2] = this.mMemoryTapeIterator::dispose;
        AutoCloser.close((AutoCloseable[])autoCloseableArray);
    }

    private boolean checkDisk() {
        if (this.mUseDisk) {
            this.mDiskDone = this.mDiskDone || !this.checkIterator(this.mDiskTapeIterator);
            return !this.mDiskDone;
        }
        return false;
    }

    private boolean checkMemory() {
        this.mMemoryDone = this.mMemoryDone || !this.checkIterator(this.mMemoryTapeIterator);
        return !this.mMemoryDone;
    }

    private boolean checkIterator(TapeIterator<? extends TapeElementInput> theTapeIterator) {
        if (theTapeIterator.hasNext()) {
            this.mTapeElementInput = theTapeIterator.next();
            return true;
        }
        return false;
    }
}

