/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.impl.hashtable.iterator;

import com.complexible.common.base.AutoCloser;
import com.complexible.memory.file.FileReader;
import com.complexible.memory.memoryblock.MemoryBlockChain;
import com.complexible.memory.structure.impl.aggregator.iterator.BaseAggregatorSegmentedTapeIterator;
import com.complexible.memory.structure.impl.hashtable.PartitionsArea;
import com.complexible.memory.structure.input.HashTableTapeElementInput;
import com.complexible.memory.structure.input.HashTableTapeElementInputFactory;
import com.complexible.memory.structure.sort.iterator.ConventionalMultiInputIterator;
import com.complexible.memory.util.Utilities;
import java.io.IOException;
import java.util.function.Supplier;

public final class HashTableDiskTapeIterator
extends BaseAggregatorSegmentedTapeIterator {
    private static final int ADDRESS_MOVE_STEP = 16;
    private boolean mActive;
    private long mSegmentAddress;
    private final PartitionsArea mPartitionsArea;
    private final FileReader mDiskDataBlocksReader;
    private final FileReader mAddressingBlocksReader;
    private final ConventionalMultiInputIterator<HashTableTapeElementInput, HashTableTapeElementInputFactory> mDiskMultiInputIterator;
    private final Supplier<MemoryBlockChain> mDataMemoryBlockChain;

    public HashTableDiskTapeIterator(FileReader theDiskDataBlocksReader, FileReader theAddressingBlocksReader, Supplier<MemoryBlockChain> theDataMemoryBlockChain, PartitionsArea thePartitionsArea, ConventionalMultiInputIterator<HashTableTapeElementInput, HashTableTapeElementInputFactory> theDiskMultiInputIterator) {
        this.mPartitionsArea = thePartitionsArea;
        this.mDataMemoryBlockChain = theDataMemoryBlockChain;
        this.mDiskDataBlocksReader = theDiskDataBlocksReader;
        this.mAddressingBlocksReader = theAddressingBlocksReader;
        this.mDiskMultiInputIterator = theDiskMultiInputIterator;
    }

    @Override
    public boolean nextSegment0() {
        if (!this.mActive) {
            if (this.mDataMemoryBlockChain.get().getSpilledFile() == null || this.mPartitionsArea.get().getSpilledFile() == null) {
                return false;
            }
            this.activate();
            this.mActive = true;
        }
        if (!this.mAddressingBlocksReader.checkAvailable(24)) {
            this.closeReaders();
            return false;
        }
        try {
            this.mSegmentAddress = this.mAddressingBlocksReader.readLong();
            this.mAddressingBlocksReader.moveForward(16L);
            this.mDiskDataBlocksReader.setPosition(this.mSegmentAddress);
            this.mHashCode = this.mDiskDataBlocksReader.readNextInt();
            this.mPartitionHashCode = this.mDiskDataBlocksReader.readNextInt();
            this.mDiskDataBlocksReader.readNextLong();
            this.mRecordsCount = 1L;
            this.mDiskMultiInputIterator.reset();
        }
        catch (IOException theE) {
            throw Utilities.rethrow(theE);
        }
        return true;
    }

    @Override
    public boolean hasNext0() {
        if (this.mSegmentAddress != -1L && this.mDiskMultiInputIterator.next(0)) {
            this.mTapeElementInput = this.mDiskMultiInputIterator.getInput(0);
            this.mSegmentAddress = -1L;
            return true;
        }
        this.mSegmentAddress = -1L;
        return false;
    }

    @Override
    public HashTableTapeElementInput next0() {
        return (HashTableTapeElementInput)this.mTapeElementInput;
    }

    @Override
    public void reset0() {
        this.closeReaders();
        this.mActive = false;
        this.mSegmentAddress = -1L;
    }

    @Override
    protected void close0() {
        this.reset0();
    }

    @Override
    public void dispose0() {
        this.closeReaders();
        this.mDiskMultiInputIterator.dispose();
    }

    private void activate() {
        try {
            this.mDiskDataBlocksReader.setInput(this.mDataMemoryBlockChain.get().getSpilledFile());
            this.mAddressingBlocksReader.setInput(this.mPartitionsArea.get().getSpilledFile());
        }
        catch (IOException theE) {
            throw Utilities.rethrow(theE);
        }
    }

    private void closeReaders() {
        AutoCloser.close((AutoCloseable[])new AutoCloseable[]{this.mDiskDataBlocksReader, this.mAddressingBlocksReader});
    }
}

