/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.impl.hashtable.input;

import com.complexible.common.base.AutoCloser;
import com.complexible.common.base.Disposable;
import com.complexible.common.base.Disposables;
import com.complexible.common.io.ByteReader;
import com.complexible.memory.file.FileReader;
import com.complexible.memory.memoryblock.MemoryBlock;
import com.complexible.memory.memoryblock.MemoryBlockChain;
import com.complexible.memory.memoryblock.MemoryBlockChainFactory;
import com.complexible.memory.memoryblock.MemoryContext;
import com.complexible.memory.structure.impl.hashtable.input.DefaultHashTableTapeElementInput;
import com.complexible.memory.structure.input.HashTableTapeElementInput;
import com.complexible.memory.structure.input.HashTableTapeElementInputFactory;
import com.complexible.memory.structure.input.TapeElementInput;
import com.complexible.memory.structure.input.impl.DefaultTapeElementInputFactory;

public final class DefaultHashTableTapeElementInputFactory
implements HashTableTapeElementInputFactory {
    private final DefaultHashTableTapeElementInput mMemoryInput;
    private final DefaultHashTableTapeElementInput mByteReaderInput;
    private final DefaultTapeElementInputFactory mTapeElementInputFactory;
    private final DefaultHashTableTapeElementInput mSpillingMemoryInput;

    public DefaultHashTableTapeElementInputFactory(MemoryContext theMemoryContext) {
        this(theMemoryContext, null);
    }

    public DefaultHashTableTapeElementInputFactory(MemoryContext theMemoryContext, MemoryBlockChainFactory theMemoryBlockChainFactory) {
        try {
            this.mMemoryInput = new DefaultHashTableTapeElementInput();
            this.mByteReaderInput = new DefaultHashTableTapeElementInput();
            this.mSpillingMemoryInput = new DefaultHashTableTapeElementInput();
            this.mTapeElementInputFactory = new DefaultTapeElementInputFactory(theMemoryContext, theMemoryBlockChainFactory);
            this.mMemoryInput.setUniquenessMode(true);
            this.mMemoryInput.setElementHeader(false);
            this.mByteReaderInput.setElementHeader(false);
            this.mByteReaderInput.setUniquenessMode(true);
            this.mSpillingMemoryInput.setElementHeader(false);
            this.mSpillingMemoryInput.setUniquenessMode(true);
        }
        catch (Throwable t) {
            this.dispose();
            throw t;
        }
        Disposables.markCreated((Object)this);
    }

    @Override
    public HashTableTapeElementInput createByteReaderInput(ByteReader theByteReader) {
        this.mByteReaderInput.setDelegate(this.mTapeElementInputFactory.createByteReaderInput(theByteReader));
        return this.mByteReaderInput;
    }

    @Override
    public HashTableTapeElementInput createMemoryInput(MemoryBlockChain theDataMemoryBlockChain, int theDataBlockOffset, int theDataBlockIndex) {
        this.mMemoryInput.setDelegate(this.mTapeElementInputFactory.createMemoryInput(theDataMemoryBlockChain, theDataBlockOffset, theDataBlockIndex));
        return this.mMemoryInput;
    }

    @Override
    public HashTableTapeElementInput createSpillingInput(FileReader theDiskInput, long theAddress) {
        this.mSpillingMemoryInput.setDelegate(this.mTapeElementInputFactory.createSpillingInput(theDiskInput, theAddress));
        return this.mSpillingMemoryInput;
    }

    @Override
    public HashTableTapeElementInput createSpillingInput(FileReader theDiskInput) {
        this.mSpillingMemoryInput.setDelegate(this.mTapeElementInputFactory.createSpillingInput(theDiskInput));
        return this.mSpillingMemoryInput;
    }

    @Override
    public HashTableTapeElementInput createSpillingInput(FileReader theDiskInput, long theAddress, long theLength, MemoryBlockChain theBufferMemoryBlockChain) {
        this.mSpillingMemoryInput.setDelegate(this.mTapeElementInputFactory.createSpillingInput(theDiskInput, theAddress, theLength, theBufferMemoryBlockChain));
        return this.mSpillingMemoryInput;
    }

    @Override
    public HashTableTapeElementInput createMemoryInput(MemoryContext theMemoryContext, MemoryBlockChain theDataMemoryBlockChain, long theAddress) {
        this.mMemoryInput.setDelegate((TapeElementInput)this.mTapeElementInputFactory.createMemoryInput(theMemoryContext, theDataMemoryBlockChain, theAddress));
        return this.mMemoryInput;
    }

    @Override
    public TapeElementInput cloneSpillingInput(FileReader theDiskInput, long theAddress, long theLength, MemoryBlockChain theBufferMemoryBlockChain) {
        this.mSpillingMemoryInput.setDelegate(this.mTapeElementInputFactory.createSpillingInput(theDiskInput, theAddress, theLength, theBufferMemoryBlockChain));
        return this.mSpillingMemoryInput;
    }

    @Override
    public HashTableTapeElementInput createMemoryInput(MemoryBlock theMemoryBlock, int theOffset, int theLength) {
        this.mMemoryInput.setDelegate(this.mTapeElementInputFactory.createMemoryInput(theMemoryBlock, theOffset, theLength));
        return this.mMemoryInput;
    }

    @Override
    public void reset() {
        this.mTapeElementInputFactory.reset();
    }

    public void dispose() {
        Disposables.markReleased((Object)this);
        AutoCloser.close((AutoCloseable[])new AutoCloseable[]{Disposables.asCloseable((Disposable)this.mTapeElementInputFactory)});
    }

    @Override
    public void setElementHeader(boolean theIsElementHeader) {
        this.mMemoryInput.setElementHeader(theIsElementHeader);
    }

    @Override
    public void setUniquenessMode(boolean theUniquenessMode) {
        this.mMemoryInput.setUniquenessMode(theUniquenessMode);
        this.mSpillingMemoryInput.setUniquenessMode(true);
        this.mByteReaderInput.setUniquenessMode(true);
    }
}

