/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.impl.hashtable.collector;

import com.complexible.memory.file.FileWriter;
import com.complexible.memory.structure.OperationTracker;
import com.complexible.memory.structure.impl.aggregator.collector.AggregatorOutputCollector;
import com.complexible.memory.structure.impl.aggregator.collector.SpillingDiskOutputCollector;
import com.complexible.memory.structure.input.HashTableTapeElementInput;
import com.complexible.memory.util.SpillingUtil;
import com.complexible.memory.util.Utilities;
import java.io.IOException;
import org.apache.commons.lang3.mutable.MutableLong;

public final class HashTableSpillingOutputCollector
implements AggregatorOutputCollector {
    private long mSegmentAddress;
    private final OperationTracker mOperationTracker;
    private final FileWriter mIndexWriter;
    private final MutableLong mPartitionSpilledElementsCount;
    private final AggregatorOutputCollector mAggregatorOutputCollector;

    public HashTableSpillingOutputCollector(FileWriter theIndexWriter, FileWriter theDataWriter, MutableLong theSpilledBytesCount, MutableLong thePartitionSpilledElementsCount, OperationTracker theOperationTracker) {
        this.mIndexWriter = theIndexWriter;
        this.mPartitionSpilledElementsCount = thePartitionSpilledElementsCount;
        this.mOperationTracker = SpillingUtil.resolveTracker(theOperationTracker);
        this.mAggregatorOutputCollector = new SpillingDiskOutputCollector(theDataWriter, theSpilledBytesCount, theOperationTracker);
    }

    @Override
    public void collectSegment(int theHashCode, int thePartitionHashCode, long theRecordsCount) {
        try {
            this.mIndexWriter.writeLong(this.mSegmentAddress);
            this.mIndexWriter.writeInt(theHashCode);
            this.mIndexWriter.writeInt(thePartitionHashCode);
            this.mIndexWriter.writeLong(theRecordsCount);
        }
        catch (IOException theE) {
            throw Utilities.rethrow(theE);
        }
        this.mAggregatorOutputCollector.collectSegment(theHashCode, thePartitionHashCode, theRecordsCount);
        this.mSegmentAddress += 16L;
        this.mOperationTracker.onSpilling(16L);
        this.mPartitionSpilledElementsCount.increment();
    }

    @Override
    public void collect(HashTableTapeElementInput theTapeElementInput) {
        this.mAggregatorOutputCollector.collect(theTapeElementInput);
        long aWrittenBytes = theTapeElementInput.length() + 8L;
        this.mSegmentAddress += aWrittenBytes;
        this.mOperationTracker.onSpilling(aWrittenBytes);
    }

    @Override
    public void reset() {
        this.mSegmentAddress = 0L;
    }
}

