/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.impl.hashtable;

import com.complexible.common.io.ByteReader;
import com.complexible.memory.factory.CollectionFactory;
import com.complexible.memory.memoryblock.MemoryContext;
import com.complexible.memory.structure.Collection;
import com.complexible.memory.structure.Comparator;
import com.complexible.memory.structure.OperationTracker;
import com.complexible.memory.structure.impl.hashtable.spilling.ConventionalSpillingSupportedHashCollection;
import com.complexible.memory.structure.impl.tape.ConventionalSpillingSupportedAddressingHashTape;
import com.complexible.memory.structure.impl.tape.addressing.hashtape.ConventionalMemoryHashTape;
import com.complexible.memory.structure.impl.tape.addressing.hashtape.impl.HashTableUtil;
import java.io.IOException;

public abstract class BaseConventionalHashTable<T extends Collection, S extends ConventionalSpillingSupportedHashCollection>
extends ConventionalSpillingSupportedAddressingHashTape<T> {
    private static final double MISSES_LOAD_FACTOR = 0.01;
    private static final int MISSES_LIMIT_LOAD = 0x100000;
    private int mMissesCount = 0;
    final S mSpillingSupportHashTable;

    BaseConventionalHashTable(int theSpillingBufferSize, MemoryContext theMemoryContext, Comparator mDefaultComparator, CollectionFactory<T> theCollectionFactory, int theEstimatedKeysCount, OperationTracker theOperationTracker) {
        super(theSpillingBufferSize, theMemoryContext, HashTableUtil.calculatePartitionCount(theMemoryContext, theEstimatedKeysCount, 16), mDefaultComparator, theCollectionFactory, theOperationTracker);
        this.mSpillingSupportHashTable = this.createSpillingSupportHashTable(this.mMemoryHashTape, theOperationTracker);
    }

    @Override
    public void put(ByteReader theReader) throws IOException {
        if (this.mSpillingSupportHashTable.isOpened()) {
            throw new IllegalStateException("HashTable should be closed for put - use stop method");
        }
        if (this.mSpillingSupportHashTable.isIterating()) {
            this.mSpillingSupportHashTable.restoreMemoryTables();
            this.mSpillingSupportHashTable.setActive();
        }
        super.put(theReader);
    }

    protected final void startLookUp() {
        if (this.mMissesCount < 0) {
            return;
        }
        if (this.mDataMemoryBlockChain.getMemoryElementsCount() > 0x100000L) {
            this.mMissesCount = -1;
            return;
        }
        if ((double)this.mMissesCount > (double)this.mDataMemoryBlockChain.getMemoryElementsCount() * 0.01) {
            this.resize();
            this.mMissesCount = -1;
        }
    }

    protected final void finishLookUp(boolean aResult) {
        if (this.mMissesCount < 0) {
            return;
        }
        if (aResult) {
            this.mMissesCount = 0;
            return;
        }
        ++this.mMissesCount;
    }

    public void start() {
        this.mMissesCount = 0;
        this.mSpillingSupportHashTable.start();
    }

    public void stop() {
        this.mMissesCount = 0;
        this.mSpillingSupportHashTable.stop();
    }

    public void reset() {
        this.mSpillingSupportHashTable.reset();
    }

    @Override
    public void dispose() {
        super.dispose();
        this.mSpillingSupportHashTable.dispose();
    }

    @Override
    protected void spillTapeToTheDisk() {
        this.mSpillingSupportHashTable.spillToTheDisk();
    }

    @Override
    protected void spillBlob(ByteReader theReader) throws IOException {
        this.resetByteReader(theReader);
        this.mMemoryHashTape.initContext(theReader);
        this.mSpillingSupportHashTable.spillBlob(theReader, this.mMemoryHashTape.getHashCode(), this.mMemoryHashTape.getPartitionHashCode());
    }

    @Override
    protected void create() {
        this.mSpillingSupportHashTable.setActive();
        super.create();
    }

    @Override
    protected boolean resize() {
        return HashTableUtil.resizeHashTable(this.mPartitionsArea, this.mDataMemoryBlockChain, this.mMemoryHashTape);
    }

    protected abstract S createSpillingSupportHashTable(ConventionalMemoryHashTape var1, OperationTracker var2);
}

