/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.impl.array.sorted.spilling.impl.multiple;

import com.complexible.memory.file.impl.DefaultFileReader;
import com.complexible.memory.file.impl.DefaultFileWriter;
import com.complexible.memory.structure.OperationTracker;
import com.complexible.memory.structure.OperationType;
import com.complexible.memory.structure.QuadLongOutputCollector;
import com.complexible.memory.structure.QuadLongSkippingIterator;
import com.complexible.memory.structure.QuadLongTapeIterator;
import com.complexible.memory.structure.impl.array.sorted.index.BinaryIndex;
import com.complexible.memory.structure.impl.array.sorted.iterator.multiple.QuadLongMemoryIterator;
import com.complexible.memory.structure.impl.array.sorted.iterator.multiple.QuadLongSortableArrayTapeIterator;
import com.complexible.memory.structure.impl.array.sorted.iterator.multiple.QuadLongValueIterator;
import com.complexible.memory.structure.impl.array.sorted.iterator.skipping.addressable.multiple.QuadLongAddressableTapeIterator;
import com.complexible.memory.structure.impl.array.sorted.iterator.skipping.addressable.multiple.QuadLongDiskAddressableTapeIterator;
import com.complexible.memory.structure.impl.array.sorted.iterator.skipping.addressable.multiple.QuadLongMemoryAddressableTapeIterator;
import com.complexible.memory.structure.impl.array.sorted.iterator.skipping.multiple.QuadLongSkippingTapeIterator;
import com.complexible.memory.structure.impl.array.sorted.multiple.context.QuadLongContext;
import com.complexible.memory.structure.impl.array.sorted.multiple.context.impl.QuadLongContextImpl;
import com.complexible.memory.structure.impl.array.sorted.spilling.impl.BaseMultipleLongSpillingSupportedSortableArray;
import com.complexible.memory.structure.impl.array.sorted.spilling.multiple.QuadLongSpillingSupportedSortableArray;
import com.complexible.memory.structure.impl.tape.MemoryBlocksDataArea;
import com.complexible.memory.structure.impl.tape.addressing.sort.impl.QuadLongSortableMemoryTape;
import com.complexible.memory.structure.search.multiple.QuadLongBinarySearcher;
import com.complexible.memory.structure.search.multiple.QuadLongDiskBinarySeacher;
import com.complexible.memory.structure.search.multiple.QuadLongSortedArrayBinarySearcher;
import com.complexible.memory.structure.sort.QuadLongSortOrder;
import com.complexible.memory.structure.sort.SortOrder;
import com.complexible.memory.structure.sort.iterator.LongMultiInputIterator;
import com.complexible.memory.structure.sort.iterator.impl.longiterator.multiple.QuadLongDiskInputIterator;
import com.complexible.memory.structure.sort.iterator.impl.longiterator.multiple.QuadLongDualMultiInputIterator;
import com.complexible.memory.structure.sort.iterator.impl.longiterator.multiple.QuadLongInputIterator;
import com.complexible.memory.structure.sort.sorters.heap.multiple.QuadLongHeapSorter;
import com.complexible.memory.util.SpillingUtil;
import java.io.File;

public final class QuadLongSpillingSupportedSortableArrayImpl
extends BaseMultipleLongSpillingSupportedSortableArray<LongMultiInputIterator, QuadLongOutputCollector, QuadLongHeapSorter, QuadLongSkippingIterator, QuadLongTapeIterator, QuadLongSortableMemoryTape>
implements QuadLongSpillingSupportedSortableArray {
    private final QuadLongSortOrder mSortOrder;
    private final QuadLongContext mLongContext;
    private final QuadLongHeapSorter mHeapSorter;
    private final QuadLongTapeIterator mTapeIterator;
    private final QuadLongTapeIterator mMemoryIterator;
    private final LongMultiInputIterator mDiskInputIterator;
    private final LongMultiInputIterator mMemoryInputIterator;
    private final QuadLongSkippingIterator mDiskIndexIterator;
    private final QuadLongSkippingIterator mMemoryIndexIterator;
    private final LongMultiInputIterator mLongValuesInputIterator;
    private final LongMultiInputIterator mDiskToMemoryDualIterator;
    private final LongMultiInputIterator mLongValuesToSpilledDualIterator;

    public QuadLongSpillingSupportedSortableArrayImpl(QuadLongSortableMemoryTape theMemorySortableTape, DefaultFileReader theFileReader, DefaultFileWriter theFileWriter, int theSpillingBufferSize, SortOrder theDirection, QuadLongSortOrder theSortOrder, OperationTracker theOperationTracker) {
        super(theMemorySortableTape, theFileReader, theFileWriter, theSpillingBufferSize, theDirection, theOperationTracker);
        this.mSortOrder = theSortOrder;
        this.mHeapSorter = this.createHeapSorter();
        this.mLongContext = new QuadLongContextImpl();
        this.mMemoryIndexIterator = this.createMemorySkippingIterator(this.mMemoryIndex);
        this.mDiskIndexIterator = this.createDiskSkippingIterator(this.mDiskIndex, this.mTapeFileReader);
        this.mMemoryInputIterator = this.createMemoryInputIterator();
        this.mDiskInputIterator = this.createDiskInputIterator(theFileReader);
        this.mMemoryIterator = this.createMemoryIterator(this.mMemoryInputIterator);
        this.mDiskToMemoryDualIterator = this.createDualInputIterator(this.mDiskInputIterator, this.mMemoryInputIterator);
        this.mTapeIterator = this.createTapeIterator(this.mHeapSorter, this.mDiskToMemoryDualIterator, theFileReader);
        this.mLongValuesInputIterator = this.createLongBlobIterator();
        this.mLongValuesToSpilledDualIterator = this.createDualInputIterator(this.mLongValuesInputIterator, this.mDiskInputIterator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void spillLongs(long theLongValue, long theLongValue2, long theLongValue3, long theLongValue4) {
        try {
            this.mOperationTracker.onStart(OperationType.SPILLING);
            QuadLongHeapSorter aHeapSorter = this.getHeapSorter();
            aHeapSorter.setChunkSize(this.mSortingChunkSize);
            aHeapSorter.resetTo(this.mLongValuesToSpilledDualIterator, (QuadLongOutputCollector)this.mSpillingOutputCollector);
            File aDestinationFile = SpillingUtil.ensureFile(this.mMemoryContext.getSpillingDirectory());
            try {
                this.onSpillingStarted(aDestinationFile);
                this.mLongContext.setLongValue(theLongValue);
                this.mLongContext.setLongValue1(theLongValue2);
                this.mLongContext.setLongValue2(theLongValue3);
                this.mLongContext.setLongValue3(theLongValue4);
                aHeapSorter.assembleAll();
            }
            finally {
                this.onSpillingDone(aDestinationFile);
            }
        }
        finally {
            this.mOperationTracker.onDone(OperationType.SPILLING);
        }
    }

    @Override
    protected QuadLongHeapSorter getHeapSorter() {
        return this.mHeapSorter;
    }

    @Override
    protected LongMultiInputIterator getDualInputIterator() {
        return this.mDiskToMemoryDualIterator;
    }

    @Override
    protected LongMultiInputIterator getDiskInputIterator() {
        return this.mDiskInputIterator;
    }

    @Override
    protected LongMultiInputIterator getMemoryInputIterator() {
        return this.mMemoryInputIterator;
    }

    @Override
    protected QuadLongSkippingIterator getDiskIndexIterator() {
        return this.mDiskIndexIterator;
    }

    @Override
    protected QuadLongSkippingIterator getMemoryIndexIterator() {
        return this.mMemoryIndexIterator;
    }

    @Override
    protected QuadLongOutputCollector createSpillingOutputCollector(OperationTracker theOperationTracker) {
        return new QuadLongOutputCollectorImpl(theOperationTracker);
    }

    @Override
    protected QuadLongTapeIterator tapeIterator() {
        return this.mTapeIterator;
    }

    @Override
    protected QuadLongTapeIterator diskIndexIterator() {
        return this.getDiskIndexIterator();
    }

    @Override
    protected QuadLongHeapSorter createHeapSorter() {
        return new QuadLongHeapSorter(this.mDirection, this.mSortOrder);
    }

    @Override
    protected QuadLongTapeIterator createMemoryIterator(LongMultiInputIterator theMemoryInputIterator) {
        return new QuadLongMemoryIterator(theMemoryInputIterator);
    }

    @Override
    protected QuadLongTapeIterator memoryIndexIterator() {
        return this.getMemoryIndexIterator();
    }

    @Override
    protected QuadLongTapeIterator newDiskIndexIterator() {
        return this.createDiskIndexIterator();
    }

    @Override
    protected QuadLongTapeIterator newMemoryIndexIterator() {
        return this.createMemoryIndexIterator();
    }

    @Override
    protected QuadLongSkippingIterator createDiskIndexIterator() {
        DefaultFileReader theFileReader = new DefaultFileReader(this.mSpillingBufferSize);
        return this.createDiskSkippingIterator(this.createDiskIndex(theFileReader), theFileReader);
    }

    @Override
    protected QuadLongSkippingIterator createMemoryIndexIterator() {
        return this.createMemorySkippingIterator(this.createMemoryIndex(this.createMemoryIndexAccessor()));
    }

    private LongMultiInputIterator createLongBlobIterator() {
        return new QuadLongValueIterator<QuadLongContext>(this.mLongContext);
    }

    @Override
    protected QuadLongTapeIterator createTapeIterator(QuadLongHeapSorter theHeapSorter, LongMultiInputIterator theDiskToMemoryDualIterator, DefaultFileReader theFileReader) {
        return new QuadLongSortableArrayTapeIterator(theDiskToMemoryDualIterator, theHeapSorter, this.mTapeArea, theFileReader);
    }

    @Override
    protected LongMultiInputIterator createDualInputIterator(LongMultiInputIterator theLeftInputIterator, LongMultiInputIterator theRightInputIterator) {
        return new QuadLongDualMultiInputIterator<LongMultiInputIterator>(theLeftInputIterator, theRightInputIterator);
    }

    @Override
    protected LongMultiInputIterator createDiskInputIterator(DefaultFileReader theFileReader) {
        return new QuadLongDiskInputIterator(theFileReader);
    }

    @Override
    protected LongMultiInputIterator createMemoryInputIterator() {
        return new QuadLongInputIterator(this.mTapeArea, this.mMemoryContext);
    }

    private QuadLongSkippingIterator createDiskSkippingIterator(BinaryIndex theBinaryIndex, DefaultFileReader theFileReader) {
        return new QuadLongSkippingTapeIterator(this.createDiskAddressableTapeIterator(theFileReader), this.createDiskSearcher(theFileReader), theBinaryIndex);
    }

    private QuadLongSkippingIterator createMemorySkippingIterator(BinaryIndex theBinaryIndex) {
        return new QuadLongSkippingTapeIterator(this.createMemoryAddressableTapeIterator(), this.createMemorySearcher(), theBinaryIndex);
    }

    private QuadLongSortedArrayBinarySearcher createMemorySearcher() {
        return new QuadLongBinarySearcher(this.mDirection, this.mSortOrder);
    }

    private QuadLongSortedArrayBinarySearcher createDiskSearcher(DefaultFileReader theFileReader) {
        return new QuadLongDiskBinarySeacher(theFileReader, this.mTapeArea, this.mDirection, this.mSortOrder);
    }

    private QuadLongAddressableTapeIterator createDiskAddressableTapeIterator(DefaultFileReader theFileReader) {
        return new QuadLongDiskAddressableTapeIterator(theFileReader);
    }

    private QuadLongAddressableTapeIterator createMemoryAddressableTapeIterator() {
        return new QuadLongMemoryAddressableTapeIterator(this.mMemoryContext, this.mTapeArea);
    }

    @Override
    public void dispose() {
        this.mHeapSorter.dispose();
        this.mTapeIterator.dispose();
        this.mDiskIndexIterator.dispose();
        this.mMemoryIndexIterator.dispose();
        this.mDiskInputIterator.dispose();
        this.mMemoryInputIterator.dispose();
        this.mLongValuesInputIterator.dispose();
        this.mDiskToMemoryDualIterator.dispose();
        this.mLongValuesToSpilledDualIterator.dispose();
    }

    @Override
    protected QuadLongTapeIterator getMemoryIterator() {
        return this.mMemoryIterator;
    }

    class QuadLongOutputCollectorImpl
    implements QuadLongOutputCollector {
        private final OperationTracker mOperationTracker;

        public QuadLongOutputCollectorImpl(OperationTracker theOperationTracker) {
            this.mOperationTracker = SpillingUtil.resolveTracker(theOperationTracker);
        }

        @Override
        public void collect(long theLongValue1, long theLongValue2, long theLongValue3, long theLongValue4) {
            QuadLongSpillingSupportedSortableArrayImpl.this.mTapeFileWriter.writeLong(theLongValue1);
            QuadLongSpillingSupportedSortableArrayImpl.this.mTapeFileWriter.writeLong(theLongValue2);
            QuadLongSpillingSupportedSortableArrayImpl.this.mTapeFileWriter.writeLong(theLongValue3);
            QuadLongSpillingSupportedSortableArrayImpl.this.mTapeFileWriter.writeLong(theLongValue4);
            ((MemoryBlocksDataArea)QuadLongSpillingSupportedSortableArrayImpl.this.mTapeArea).get().incrementTotalSpilledBytes(32L);
            this.mOperationTracker.onSpilling(32L);
        }
    }
}

