/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.impl.array.sorted.spilling.impl.multiple;

import com.complexible.memory.file.impl.DefaultFileReader;
import com.complexible.memory.file.impl.DefaultFileWriter;
import com.complexible.memory.structure.DoubleLongOutputCollector;
import com.complexible.memory.structure.DoubleLongSkippingIterator;
import com.complexible.memory.structure.DoubleLongTapeIterator;
import com.complexible.memory.structure.OperationTracker;
import com.complexible.memory.structure.OperationType;
import com.complexible.memory.structure.impl.array.sorted.index.BinaryIndex;
import com.complexible.memory.structure.impl.array.sorted.iterator.multiple.DoubleLongMemoryIterator;
import com.complexible.memory.structure.impl.array.sorted.iterator.multiple.DoubleLongSortableArrayTapeIterator;
import com.complexible.memory.structure.impl.array.sorted.iterator.multiple.DoubleLongValueIterator;
import com.complexible.memory.structure.impl.array.sorted.iterator.skipping.addressable.multiple.DoubleLongAddressableTapeIterator;
import com.complexible.memory.structure.impl.array.sorted.iterator.skipping.addressable.multiple.DoubleLongDiskAddressableTapeIterator;
import com.complexible.memory.structure.impl.array.sorted.iterator.skipping.addressable.multiple.DoubleLongMemoryAddressableTapeIterator;
import com.complexible.memory.structure.impl.array.sorted.iterator.skipping.multiple.DoubleLongSkippingTapeIterator;
import com.complexible.memory.structure.impl.array.sorted.multiple.context.DoubleLongContext;
import com.complexible.memory.structure.impl.array.sorted.multiple.context.impl.DoubleLongContextImpl;
import com.complexible.memory.structure.impl.array.sorted.spilling.impl.BaseMultipleLongSpillingSupportedSortableArray;
import com.complexible.memory.structure.impl.array.sorted.spilling.multiple.DoubleLongSpillingSupportedSortableArray;
import com.complexible.memory.structure.impl.tape.MemoryBlocksDataArea;
import com.complexible.memory.structure.impl.tape.addressing.sort.impl.DoubleLongSortableMemoryTape;
import com.complexible.memory.structure.search.multiple.DoubleLongBinarySearcher;
import com.complexible.memory.structure.search.multiple.DoubleLongDiskBinarySearcher;
import com.complexible.memory.structure.search.multiple.DoubleLongSortedArrayBinarySearcher;
import com.complexible.memory.structure.sort.DoubleLongSortOrder;
import com.complexible.memory.structure.sort.SortOrder;
import com.complexible.memory.structure.sort.iterator.LongMultiInputIterator;
import com.complexible.memory.structure.sort.iterator.impl.longiterator.multiple.DoubleLongDiskInputIterator;
import com.complexible.memory.structure.sort.iterator.impl.longiterator.multiple.DoubleLongDualMultiInputIterator;
import com.complexible.memory.structure.sort.iterator.impl.longiterator.multiple.DoubleLongInputIterator;
import com.complexible.memory.structure.sort.sorters.heap.multiple.DoubleLongHeapSorter;
import com.complexible.memory.util.SpillingUtil;
import java.io.File;

public final class DoubleLongSpillingSupportedSortableArrayImpl
extends BaseMultipleLongSpillingSupportedSortableArray<LongMultiInputIterator, DoubleLongOutputCollector, DoubleLongHeapSorter, DoubleLongSkippingIterator, DoubleLongTapeIterator, DoubleLongSortableMemoryTape>
implements DoubleLongSpillingSupportedSortableArray {
    private final DoubleLongSortOrder mSortOrder;
    private final DoubleLongContext mLongContext;
    private final DoubleLongHeapSorter mHeapSorter;
    private final DoubleLongTapeIterator mTapeIterator;
    private final DoubleLongTapeIterator mMemoryIterator;
    private final LongMultiInputIterator mDiskInputIterator;
    private final LongMultiInputIterator mMemoryInputIterator;
    private final DoubleLongSkippingIterator mDiskIndexIterator;
    private final DoubleLongSkippingIterator mMemoryIndexIterator;
    private final LongMultiInputIterator mLongValuesInputIterator;
    private final LongMultiInputIterator mDiskToMemoryDualIterator;
    private final LongMultiInputIterator mLongValuesToSpilledDualIterator;

    public DoubleLongSpillingSupportedSortableArrayImpl(DoubleLongSortableMemoryTape theMemorySortableTape, DefaultFileReader theFileReader, DefaultFileWriter theFileWriter, int theSpillingBufferSize, SortOrder theDirection, DoubleLongSortOrder theSortOrder, OperationTracker theOperationTracker) {
        super(theMemorySortableTape, theFileReader, theFileWriter, theSpillingBufferSize, theDirection, theOperationTracker);
        this.mSortOrder = theSortOrder;
        this.mHeapSorter = this.createHeapSorter();
        this.mLongContext = new DoubleLongContextImpl();
        this.mMemoryIndexIterator = this.createMemorySkippingIterator(this.mMemoryIndex);
        this.mDiskIndexIterator = this.createDiskSkippingIterator(this.mDiskIndex, this.mTapeFileReader);
        this.mMemoryInputIterator = this.createMemoryInputIterator();
        this.mDiskInputIterator = this.createDiskInputIterator(theFileReader);
        this.mMemoryIterator = new DoubleLongMemoryIterator(this.mMemoryInputIterator);
        this.mDiskToMemoryDualIterator = this.createDualInputIterator(this.mDiskInputIterator, this.mMemoryInputIterator);
        this.mTapeIterator = this.createTapeIterator(this.mHeapSorter, this.mDiskToMemoryDualIterator, theFileReader);
        this.mLongValuesInputIterator = this.createLongBlobIterator();
        this.mLongValuesToSpilledDualIterator = this.createDualInputIterator(this.mLongValuesInputIterator, this.mDiskInputIterator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void spillLongs(long theLongValue, long theLongValue2) {
        try {
            this.mOperationTracker.onStart(OperationType.SPILLING);
            DoubleLongHeapSorter aHeapSorter = this.getHeapSorter();
            aHeapSorter.setChunkSize(this.mSortingChunkSize);
            aHeapSorter.resetTo(this.mLongValuesToSpilledDualIterator, (DoubleLongOutputCollector)this.mSpillingOutputCollector);
            File aDestinationFile = SpillingUtil.ensureFile(this.mMemoryContext.getSpillingDirectory());
            try {
                this.onSpillingStarted(aDestinationFile);
                this.mLongContext.setLongValue(theLongValue);
                this.mLongContext.setLongValue1(theLongValue2);
                aHeapSorter.assembleAll();
            }
            finally {
                this.onSpillingDone(aDestinationFile);
            }
        }
        finally {
            this.mOperationTracker.onDone(OperationType.SPILLING);
        }
    }

    @Override
    protected DoubleLongHeapSorter getHeapSorter() {
        return this.mHeapSorter;
    }

    @Override
    protected LongMultiInputIterator getDualInputIterator() {
        return this.mDiskToMemoryDualIterator;
    }

    @Override
    protected LongMultiInputIterator getDiskInputIterator() {
        return this.mDiskInputIterator;
    }

    @Override
    protected LongMultiInputIterator getMemoryInputIterator() {
        return this.mMemoryInputIterator;
    }

    @Override
    protected DoubleLongSkippingIterator getDiskIndexIterator() {
        return this.mDiskIndexIterator;
    }

    @Override
    protected DoubleLongSkippingIterator getMemoryIndexIterator() {
        return this.mMemoryIndexIterator;
    }

    @Override
    protected DoubleLongTapeIterator tapeIterator() {
        return this.mTapeIterator;
    }

    @Override
    protected DoubleLongTapeIterator diskIndexIterator() {
        return this.getDiskIndexIterator();
    }

    @Override
    protected DoubleLongTapeIterator newTapeIterator() {
        DefaultFileReader theFileReader = new DefaultFileReader(this.mSpillingBufferSize);
        return this.createTapeIterator(new DoubleLongHeapSorter(this.mDirection, this.mSortOrder), this.createDualInputIterator(this.createDiskInputIterator(theFileReader), this.createMemoryInputIterator()), theFileReader);
    }

    @Override
    protected DoubleLongHeapSorter createHeapSorter() {
        return new DoubleLongHeapSorter(this.mDirection, this.mSortOrder);
    }

    @Override
    protected DoubleLongTapeIterator memoryIndexIterator() {
        return this.getMemoryIndexIterator();
    }

    @Override
    protected DoubleLongTapeIterator newDiskIndexIterator() {
        return this.createDiskIndexIterator();
    }

    @Override
    protected DoubleLongTapeIterator newMemoryIndexIterator() {
        return this.createMemoryIndexIterator();
    }

    @Override
    protected DoubleLongSkippingIterator createDiskIndexIterator() {
        DefaultFileReader theFileReader = new DefaultFileReader(this.mSpillingBufferSize);
        return this.createDiskSkippingIterator(this.createDiskIndex(theFileReader), theFileReader);
    }

    @Override
    protected DoubleLongSkippingIterator createMemoryIndexIterator() {
        return this.createMemorySkippingIterator(this.createMemoryIndex(this.createMemoryIndexAccessor()));
    }

    @Override
    protected DoubleLongOutputCollector createSpillingOutputCollector(OperationTracker theOperationTracker) {
        return new DoubleLongOutputCollectorImpl(theOperationTracker);
    }

    private LongMultiInputIterator createLongBlobIterator() {
        return new DoubleLongValueIterator<DoubleLongContext>(this.mLongContext);
    }

    @Override
    protected DoubleLongTapeIterator createTapeIterator(DoubleLongHeapSorter theHeapSorter, LongMultiInputIterator theDiskToMemoryDualIterator, DefaultFileReader theFileReader) {
        return new DoubleLongSortableArrayTapeIterator(theDiskToMemoryDualIterator, theHeapSorter, this.mTapeArea, theFileReader);
    }

    @Override
    protected DoubleLongTapeIterator createMemoryIterator(LongMultiInputIterator theMemoryInputIterator) {
        return new DoubleLongMemoryIterator(theMemoryInputIterator);
    }

    @Override
    protected LongMultiInputIterator createDualInputIterator(LongMultiInputIterator theLeftInputIterator, LongMultiInputIterator theRightInputIterator) {
        return new DoubleLongDualMultiInputIterator<LongMultiInputIterator>(theLeftInputIterator, theRightInputIterator);
    }

    @Override
    protected LongMultiInputIterator createDiskInputIterator(DefaultFileReader theFileReader) {
        return new DoubleLongDiskInputIterator(theFileReader);
    }

    @Override
    protected LongMultiInputIterator createMemoryInputIterator() {
        return new DoubleLongInputIterator(this.mTapeArea, this.mMemoryContext);
    }

    private DoubleLongSkippingIterator createDiskSkippingIterator(BinaryIndex theBinaryIndex, DefaultFileReader theFileReader) {
        return new DoubleLongSkippingTapeIterator(this.createDiskAddressableTapeIterator(theFileReader), this.createDiskSearcher(theFileReader), theBinaryIndex);
    }

    private DoubleLongSkippingIterator createMemorySkippingIterator(BinaryIndex theBinaryIndex) {
        return new DoubleLongSkippingTapeIterator(this.createMemoryAddressableTapeIterator(), this.createMemorySearcher(), theBinaryIndex);
    }

    private DoubleLongSortedArrayBinarySearcher createMemorySearcher() {
        return new DoubleLongBinarySearcher(this.mDirection, this.mSortOrder);
    }

    private DoubleLongSortedArrayBinarySearcher createDiskSearcher(DefaultFileReader theFileReader) {
        return new DoubleLongDiskBinarySearcher(theFileReader, this.mTapeArea, this.mDirection, this.mSortOrder);
    }

    private DoubleLongAddressableTapeIterator createDiskAddressableTapeIterator(DefaultFileReader theFileReader) {
        return new DoubleLongDiskAddressableTapeIterator(theFileReader);
    }

    private DoubleLongAddressableTapeIterator createMemoryAddressableTapeIterator() {
        return new DoubleLongMemoryAddressableTapeIterator(this.mMemoryContext, this.mTapeArea);
    }

    @Override
    public void dispose() {
        this.mHeapSorter.dispose();
        this.mTapeIterator.dispose();
        this.mDiskIndexIterator.dispose();
        this.mMemoryIndexIterator.dispose();
        this.mDiskInputIterator.dispose();
        this.mMemoryInputIterator.dispose();
        this.mLongValuesInputIterator.dispose();
        this.mDiskToMemoryDualIterator.dispose();
        this.mLongValuesToSpilledDualIterator.dispose();
    }

    @Override
    protected DoubleLongTapeIterator getMemoryIterator() {
        return this.mMemoryIterator;
    }

    class DoubleLongOutputCollectorImpl
    implements DoubleLongOutputCollector {
        private final OperationTracker mOperationTracker;

        public DoubleLongOutputCollectorImpl(OperationTracker theOperationTracker) {
            this.mOperationTracker = SpillingUtil.resolveTracker(theOperationTracker);
        }

        @Override
        public void collect(long theLongValue1, long theLongValue2) {
            DoubleLongSpillingSupportedSortableArrayImpl.this.mTapeFileWriter.writeLong(theLongValue1);
            DoubleLongSpillingSupportedSortableArrayImpl.this.mTapeFileWriter.writeLong(theLongValue2);
            ((MemoryBlocksDataArea)DoubleLongSpillingSupportedSortableArrayImpl.this.mTapeArea).get().incrementTotalSpilledBytes(16L);
            this.mOperationTracker.onSpilling(16L);
        }
    }
}

