/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.impl.array.sorted.spilling.impl;

import com.complexible.common.io.ByteReader;
import com.complexible.memory.file.FileReader;
import com.complexible.memory.file.impl.DefaultFileReader;
import com.complexible.memory.file.impl.DefaultFileWriter;
import com.complexible.memory.memoryblock.MemoryBlockChain;
import com.complexible.memory.memoryblock.MemoryBlockChainFactory;
import com.complexible.memory.memoryblock.MemoryContext;
import com.complexible.memory.structure.Comparator;
import com.complexible.memory.structure.ConventionalOutputCollector;
import com.complexible.memory.structure.ObjectSupplier;
import com.complexible.memory.structure.OperationTracker;
import com.complexible.memory.structure.OperationType;
import com.complexible.memory.structure.TapeIterator;
import com.complexible.memory.structure.impl.array.sorted.index.BinaryIndex;
import com.complexible.memory.structure.impl.array.sorted.index.DiskIndex;
import com.complexible.memory.structure.impl.array.sorted.index.MemoryIndex;
import com.complexible.memory.structure.impl.array.sorted.iterator.ByteReaderIterator;
import com.complexible.memory.structure.impl.array.sorted.iterator.DefaultConventionalSortableArrayIterator;
import com.complexible.memory.structure.impl.array.sorted.iterator.skipping.ConventionalSkippingTapeIterator;
import com.complexible.memory.structure.impl.array.sorted.iterator.skipping.SorterSkippingIterator;
import com.complexible.memory.structure.impl.array.sorted.iterator.skipping.addressable.ConventionalMemoryAddressableTapeIterator;
import com.complexible.memory.structure.impl.array.sorted.iterator.skipping.addressable.DiskAddressableTapeIterator;
import com.complexible.memory.structure.impl.array.sorted.spilling.GenericSpillingSupportedSortableArray;
import com.complexible.memory.structure.impl.array.sorted.spilling.impl.BaseConventionalSpillingSupportedSortableArray;
import com.complexible.memory.structure.impl.tape.MemoryBlockAddressArea;
import com.complexible.memory.structure.impl.tape.addressing.sort.GenericMemorySortableTape;
import com.complexible.memory.structure.input.TapeElementInput;
import com.complexible.memory.structure.input.TapeElementInputFactory;
import com.complexible.memory.structure.iterator.ConventionalAddressableTapeIterator;
import com.complexible.memory.structure.search.ConventionalDiskBinarySearcher;
import com.complexible.memory.structure.search.ConventionalMemoryBinarySearcher;
import com.complexible.memory.structure.sort.SortOrder;
import com.complexible.memory.structure.sort.iterator.GenericMultiInputIterator;
import com.complexible.memory.structure.sort.iterator.impl.AddressMultiInputIterator;
import com.complexible.memory.structure.sort.iterator.impl.GenericDiskMultiInputIterator;
import com.complexible.memory.structure.sort.iterator.impl.GenericDualConventionalMultiInputIterator;
import com.complexible.memory.structure.sort.sorters.heap.DefaultHeapSorter;
import java.util.function.Supplier;

public final class SpillingSupportedSortableArrayImpl
extends BaseConventionalSpillingSupportedSortableArray<GenericMultiInputIterator, ConventionalOutputCollector<TapeElementInput>, DefaultHeapSorter, SorterSkippingIterator, Comparator, GenericMemorySortableTape>
implements GenericSpillingSupportedSortableArray {
    private final TapeIterator mTapeIterator;
    private final DefaultHeapSorter mHeapSorter = this.createHeapSorter();
    private final SorterSkippingIterator mDiskIndexIterator;
    private final SorterSkippingIterator mMemoryIndexIterator;
    private final GenericMultiInputIterator mDiskInputIterator;
    private final GenericMultiInputIterator mBlobInputIterator;
    private final GenericMultiInputIterator mMemoryInputIterator = this.createMemoryInputIterator(this.mMemoryContext);
    private final GenericMultiInputIterator mDiskToMemoryDualIterator;
    private final GenericMultiInputIterator mBlobToSpilledDualIterator;

    public SpillingSupportedSortableArrayImpl(GenericMemorySortableTape theMemorySortableTape, DefaultFileReader theAddressingFileReader, DefaultFileWriter theAddressingFileWriter, DefaultFileReader theDataFileReader, DefaultFileWriter theDataFileWriter, int theSpillingBufferSize, SortOrder theSortOrder, Comparator theComparator, OperationTracker theOperationTracker) {
        super(theMemorySortableTape, theAddressingFileReader, theAddressingFileWriter, theDataFileReader, theDataFileWriter, theSpillingBufferSize, theSortOrder, theComparator, theOperationTracker);
        this.mDiskInputIterator = this.createDiskInputIterator(this.mMemoryBlockChainFactory, theDataFileReader, this.mMemoryContext);
        this.mMemoryIndexIterator = this.createMemorySkippingIterator(this.mMemoryContext, this.mMemoryIndex);
        this.mDiskIndexIterator = this.createDiskSkippingIterator(this.mMemoryContext, this.mDiskInputIterator, this.mDiskIndex, this.mDataFileReader);
        this.mDiskToMemoryDualIterator = this.createDualInputIterator(this.mDiskInputIterator, this.mMemoryInputIterator);
        this.mTapeIterator = new DefaultConventionalSortableArrayIterator<GenericMultiInputIterator, DefaultHeapSorter>(this.mHeapSorter, this.mDiskToMemoryDualIterator, theMemorySortableTape.getDataMemoryBlockChainSupplier(), theDataFileReader);
        this.mBlobInputIterator = this.createByteReaderIterator(this.mReaderObjectSupplier);
        this.mBlobToSpilledDualIterator = this.createDualInputIterator(this.mBlobInputIterator, this.mDiskInputIterator);
    }

    private DefaultHeapSorter createHeapSorter() {
        return new DefaultHeapSorter(((GenericMemorySortableTape)this.mMemorySortableTape).getMemoryContext(), ((GenericMemorySortableTape)this.mMemorySortableTape).getMemoryBlockChainFactory(), this.mDirection, (Comparator)this.mComparator);
    }

    @Override
    public TapeIterator getTapeIterator() {
        if (((GenericMemorySortableTape)this.mMemorySortableTape).isIndexBuilt()) {
            TapeIterator aIndexIterator = (TapeIterator)this.getIndexIterator();
            aIndexIterator.reset();
            return aIndexIterator;
        }
        this.checkAndSortSeparately();
        this.mTapeIterator.reset();
        return this.mTapeIterator;
    }

    @Override
    public TapeIterator createTapeIterator() {
        if (((GenericMemorySortableTape)this.mMemorySortableTape).isIndexBuilt()) {
            TapeIterator aIndexIterator = (TapeIterator)this.createIndexIterator();
            aIndexIterator.reset();
            return aIndexIterator;
        }
        this.checkAndSortSeparately();
        DefaultFileReader theDataFileReader = new DefaultFileReader(this.mSpillingBufferSize);
        GenericMultiInputIterator aDiskInputIterator = this.createDiskInputIterator(this.mMemoryBlockChainFactory, theDataFileReader, this.mMemoryContext);
        GenericMultiInputIterator aMemoryInputIterator = this.createMemoryInputIterator(this.mMemoryContext);
        DefaultConventionalSortableArrayIterator<GenericMultiInputIterator, DefaultHeapSorter> aTapeIterator = new DefaultConventionalSortableArrayIterator<GenericMultiInputIterator, DefaultHeapSorter>(this.createHeapSorter(), this.createDualInputIterator(aDiskInputIterator, aMemoryInputIterator), ((GenericMemorySortableTape)this.mMemorySortableTape).getDataMemoryBlockChainSupplier(), theDataFileReader);
        aTapeIterator.reset();
        return aTapeIterator;
    }

    @Override
    protected int slotSizeBitPosition() {
        return 3;
    }

    @Override
    protected GenericMultiInputIterator getBlobInputIterator() {
        return this.mBlobInputIterator;
    }

    @Override
    protected GenericMultiInputIterator getBlobToSpilledDualIterator() {
        return this.mBlobToSpilledDualIterator;
    }

    @Override
    protected DefaultHeapSorter getHeapSorter() {
        return this.mHeapSorter;
    }

    @Override
    protected SorterSkippingIterator getDiskIndexIterator() {
        return this.mDiskIndexIterator;
    }

    @Override
    protected SorterSkippingIterator getMemoryIndexIterator() {
        return this.mMemoryIndexIterator;
    }

    @Override
    protected GenericMultiInputIterator getDiskInputIterator() {
        return this.mDiskInputIterator;
    }

    @Override
    protected GenericMultiInputIterator getMemoryInputIterator() {
        return this.mMemoryInputIterator;
    }

    @Override
    protected ConventionalOutputCollector<TapeElementInput> getIndexOutputCollector() {
        return this.mIndexOutputCollector;
    }

    @Override
    protected GenericMultiInputIterator getDualInputIterator() {
        return this.mDiskToMemoryDualIterator;
    }

    @Override
    protected ConventionalOutputCollector<TapeElementInput> createSpillingOutputCollector(OperationTracker theOperationTracker) {
        return new BaseConventionalSpillingSupportedSortableArray.SpillingOutputCollector(this, theOperationTracker);
    }

    @Override
    protected void sortMemoryBlocksDataBeforeSpilling() {
        this.checkAndSortSeparately();
    }

    @Override
    protected SorterSkippingIterator createDiskIndexIterator() {
        DefaultFileReader theDataFileReader = new DefaultFileReader(this.mSpillingBufferSize);
        DefaultFileReader theTapeFileReader = new DefaultFileReader(this.mSpillingBufferSize);
        return this.createDiskSkippingIterator(this.mMemoryContext, this.createDiskInputIterator(this.mMemoryBlockChainFactory, theDataFileReader, this.mMemoryContext), new DiskIndex(theTapeFileReader, this.mTapeArea, this.mDataMemoryBlockChainSupplier), theDataFileReader);
    }

    @Override
    protected SorterSkippingIterator createMemoryIndexIterator() {
        return this.createMemorySkippingIterator(this.mMemoryContext, new MemoryIndex(this.createMemoryIndexAccessor(), this.mDataMemoryBlockChainSupplier));
    }

    @Override
    protected GenericMultiInputIterator createByteReaderIterator(ObjectSupplier<ByteReader> theReaderObjectSupplier) {
        return new ByteReaderIterator(this.mMemoryContext, theReaderObjectSupplier);
    }

    private GenericMultiInputIterator createDiskInputIterator(MemoryBlockChainFactory theFactory, FileReader theDiskInput, MemoryContext theMemoryContext) {
        return new GenericDiskMultiInputIterator(theFactory, theDiskInput, theMemoryContext);
    }

    private GenericMultiInputIterator createDualInputIterator(GenericMultiInputIterator theLeftProvider, GenericMultiInputIterator theRightProvider) {
        return new GenericDualConventionalMultiInputIterator(theLeftProvider, theRightProvider);
    }

    private ConventionalSkippingTapeIterator createDiskSkippingIterator(MemoryContext theMemoryContext, GenericMultiInputIterator theDiskInputIterator, BinaryIndex theBinaryDiskIndex, FileReader theDataFileReader) {
        return new ConventionalSkippingTapeIterator((ConventionalAddressableTapeIterator)this.createAddressableDiskIterator(theDiskInputIterator, theBinaryDiskIndex, theDataFileReader), this.createConventionalDiskSearcher(theMemoryContext, theDataFileReader), theBinaryDiskIndex);
    }

    private ConventionalSkippingTapeIterator createMemorySkippingIterator(MemoryContext theMemoryContext, BinaryIndex theBinaryMemoryIndex) {
        return new ConventionalSkippingTapeIterator((ConventionalAddressableTapeIterator)this.createAddressableMemoryIterator(), this.createConventionalMemorySearcher(theMemoryContext), theBinaryMemoryIndex);
    }

    private ConventionalMemoryBinarySearcher createConventionalMemorySearcher(MemoryContext theMemoryContext) {
        return new ConventionalMemoryBinarySearcher(theMemoryContext, this.mDataMemoryBlockChainSupplier, this.mDirection, (Comparator)this.mComparator);
    }

    private ConventionalMemoryAddressableTapeIterator createAddressableMemoryIterator() {
        return new ConventionalMemoryAddressableTapeIterator(this.mMemoryContext, (Supplier<MemoryBlockChain>)((GenericMemorySortableTape)this.mMemorySortableTape).getTapeArea(), this.mDataMemoryBlockChainSupplier, 8, this.slotSizeBitPosition());
    }

    private ConventionalDiskBinarySearcher createConventionalDiskSearcher(MemoryContext theMemoryContext, FileReader theFileReader) {
        return new ConventionalDiskBinarySearcher(theMemoryContext, theFileReader, this.mDataMemoryBlockChainSupplier, this.mMemoryBlockChainFactory, this.mDirection, (Comparator)this.mComparator);
    }

    private DiskAddressableTapeIterator createAddressableDiskIterator(GenericMultiInputIterator theDiskInputIterator, BinaryIndex theBinaryIndex, FileReader theFileReader) {
        return new DiskAddressableTapeIterator<TapeElementInput, TapeElementInputFactory<TapeElementInput>>(theDiskInputIterator, theBinaryIndex, theFileReader);
    }

    private GenericMultiInputIterator createMemoryInputIterator(MemoryContext theMemoryContext) {
        return new AddressMultiInputIterator(this.mDataMemoryBlockChainSupplier, (MemoryBlockAddressArea)this.mTapeArea, theMemoryContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAndSortSeparately() {
        if (((GenericMemorySortableTape)this.mMemorySortableTape).isEmpty() || ((GenericMemorySortableTape)this.mMemorySortableTape).isMemorySortedSeparately()) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            if (!((GenericMemorySortableTape)this.mMemorySortableTape).isMemorySortedSeparately()) {
                try {
                    this.mOperationTracker.onStart(OperationType.SORTING);
                    ((GenericMemorySortableTape)this.mMemorySortableTape).sortMemoryBlocksDataSeparately(this.mOperationTracker);
                }
                finally {
                    this.mOperationTracker.onDone(OperationType.SORTING);
                }
            }
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.mHeapSorter.dispose();
        this.mTapeIterator.dispose();
        this.mDiskInputIterator.dispose();
        this.mDiskIndexIterator.dispose();
        this.mBlobInputIterator.dispose();
        this.mMemoryIndexIterator.dispose();
        this.mMemoryInputIterator.dispose();
        this.mDiskToMemoryDualIterator.dispose();
        this.mBlobToSpilledDualIterator.dispose();
    }
}

