/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.impl.array.sorted.spilling.impl;

import com.complexible.common.base.AutoCloser;
import com.complexible.common.io.ByteReader;
import com.complexible.memory.file.FileReader;
import com.complexible.memory.file.FileWriter;
import com.complexible.memory.file.impl.DefaultFileReader;
import com.complexible.memory.file.impl.DefaultFileWriter;
import com.complexible.memory.memoryblock.DefaultMemoryBlockChain;
import com.complexible.memory.memoryblock.MemoryBlock;
import com.complexible.memory.memoryblock.MemoryBlockChain;
import com.complexible.memory.memoryblock.MemoryBlockChainFactory;
import com.complexible.memory.memoryblock.MemoryContext;
import com.complexible.memory.structure.BaseConventionalTapeIterator;
import com.complexible.memory.structure.ConventionalOutputCollector;
import com.complexible.memory.structure.ObjectSupplier;
import com.complexible.memory.structure.OperationTracker;
import com.complexible.memory.structure.OperationType;
import com.complexible.memory.structure.TapeIterator;
import com.complexible.memory.structure.impl.array.sorted.BaseIndexOutputCollector;
import com.complexible.memory.structure.impl.array.sorted.index.BinaryIndex;
import com.complexible.memory.structure.impl.array.sorted.index.MemoryIndex;
import com.complexible.memory.structure.impl.array.sorted.iterator.ByteReaderIterator;
import com.complexible.memory.structure.impl.array.sorted.iterator.DefaultConventionalSortableArrayIterator;
import com.complexible.memory.structure.impl.array.sorted.iterator.skipping.BaseConventionalSkippingTapeIterator;
import com.complexible.memory.structure.impl.array.sorted.iterator.skipping.SorterLongOptimizedSkippingIterator;
import com.complexible.memory.structure.impl.array.sorted.iterator.skipping.addressable.ConventionalMemoryAddressableTapeIterator;
import com.complexible.memory.structure.impl.array.sorted.iterator.skipping.addressable.DiskAddressableTapeIterator;
import com.complexible.memory.structure.impl.array.sorted.spilling.LongOptimizedConventionalSpillingSupportedSortableArray;
import com.complexible.memory.structure.impl.array.sorted.spilling.impl.BaseConventionalSpillingSupportedSortableArray;
import com.complexible.memory.structure.impl.tape.MemoryBlockAddressArea;
import com.complexible.memory.structure.impl.tape.addressing.sort.LongOptimizedSortableTape;
import com.complexible.memory.structure.input.TapeElementInput;
import com.complexible.memory.structure.input.TapeElementInputFactory;
import com.complexible.memory.structure.input.impl.DefaultTapeElementInputFactory;
import com.complexible.memory.structure.iterator.ConventionalAddressableTapeIterator;
import com.complexible.memory.structure.search.LongOptimizedBinarySearcher;
import com.complexible.memory.structure.search.LongOptimizedDiskBinarySearcher;
import com.complexible.memory.structure.search.SearchUtils;
import com.complexible.memory.structure.search.multiple.LongSortedArrayBinarySearcher;
import com.complexible.memory.structure.sort.LongComparator;
import com.complexible.memory.structure.sort.SortOrder;
import com.complexible.memory.structure.sort.iterator.ConventionalLongOptimizedMultiInputIterator;
import com.complexible.memory.structure.sort.iterator.GenericMultiInputIterator;
import com.complexible.memory.structure.sort.iterator.impl.longiterator.ConventionalLongOptimizedInputIterator;
import com.complexible.memory.structure.sort.iterator.impl.longiterator.DiskConventionalLongMultiInputIterator;
import com.complexible.memory.structure.sort.iterator.impl.longiterator.DualConventionalLongOptimizedMultiInputIterator;
import com.complexible.memory.structure.sort.sorters.heap.ConventionalLongOptimizedHeapSorter;
import com.complexible.memory.util.Utilities;
import com.google.common.base.Preconditions;
import java.io.IOException;

public final class SpillingSupportedLongOptimizedSortableArrayImpl
extends BaseConventionalSpillingSupportedSortableArray<ConventionalLongOptimizedMultiInputIterator, ConventionalOutputCollector<TapeElementInput>, ConventionalLongOptimizedHeapSorter, SorterLongOptimizedSkippingIterator, LongComparator, LongOptimizedSortableTape>
implements LongOptimizedConventionalSpillingSupportedSortableArray {
    private long mCompareLongIndex;
    private long mCachedCompareLong;
    private final DefaultConventionalSortableArrayIterator mTapeIterator;
    private final ConventionalLongOptimizedHeapSorter mHeapSorter = this.createHeapSorter();
    private final DefaultSkippingTapeIterator mDiskIndexIterator;
    private final ConventionalLongOptimizedMultiInputIterator mBlobInputIterator;
    private final ConventionalLongOptimizedMultiInputIterator mDiskInputIterator;
    private final ConventionalLongOptimizedMultiInputIterator mMemoryInputIterator = this.createMemoryInputIterator(this.mMemoryContext);
    private final ConventionalOutputCollector<TapeElementInput> mIndexOutputCollector;
    private final ConventionalLongOptimizedMultiInputIterator mDiskToMemoryDualIterator;
    private final ConventionalLongOptimizedMultiInputIterator mBlobToSpilledDualIterator;

    public SpillingSupportedLongOptimizedSortableArrayImpl(LongOptimizedSortableTape theMemorySortableTape, DefaultFileReader theAddressingFileReader, DefaultFileWriter theAddressingFileWriter, DefaultFileReader theDataFileReader, DefaultFileWriter theDataFileWriter, int theSpillingBufferSize, SortOrder theDirection, LongComparator theComparator, OperationTracker theOperationTracker) {
        super(theMemorySortableTape, theAddressingFileReader, theAddressingFileWriter, theDataFileReader, theDataFileWriter, theSpillingBufferSize, theDirection, theComparator, theOperationTracker);
        this.mDiskInputIterator = this.createDiskInputIterator(this.mMemoryBlockChainFactory, theDataFileReader, this.mMemoryContext);
        this.mDiskIndexIterator = this.createDiskSkippingIterator(this.mMemoryContext, this.mDiskInputIterator, this.mDiskIndex, this.mDataFileReader);
        this.mIndexOutputCollector = new LongOptimizedIndexOutputCollector((ConventionalOutputCollector)this.mSpillingOutputCollector, this.mTapeFileWriter, theOperationTracker);
        this.mDiskToMemoryDualIterator = this.createDualInputIterator(this.mDiskInputIterator, this.mMemoryInputIterator);
        this.mTapeIterator = new DefaultConventionalSortableArrayIterator<ConventionalLongOptimizedMultiInputIterator, ConventionalLongOptimizedHeapSorter>(this.mHeapSorter, this.mDiskToMemoryDualIterator, this.mDataMemoryBlockChainSupplier, this.mDataFileReader);
        this.mBlobInputIterator = this.createByteReaderIterator(this.mReaderObjectSupplier);
        this.mBlobToSpilledDualIterator = this.createDualInputIterator(this.mBlobInputIterator, this.mDiskInputIterator);
    }

    private ConventionalLongOptimizedHeapSorter createHeapSorter() {
        return new ConventionalLongOptimizedHeapSorter(this.mDirection, (LongComparator)this.mComparator);
    }

    @Override
    protected ConventionalOutputCollector<TapeElementInput> createSpillingOutputCollector(OperationTracker theOperationTracker) {
        return new BaseConventionalSpillingSupportedSortableArray.SpillingOutputCollector(this, theOperationTracker);
    }

    @Override
    public TapeIterator getTapeIterator() {
        if (this.isDataSpilled()) {
            if (!((LongOptimizedSortableTape)this.mMemorySortableTape).isMemoryIndexBuilt()) {
                ((LongOptimizedSortableTape)this.mMemorySortableTape).buildMemorySortedIndex(this.mOperationTracker);
            }
            this.mTapeIterator.reset();
            return this.mTapeIterator;
        }
        return (TapeIterator)this.getSkippingTapeIterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TapeIterator createTapeIterator() {
        if (this.isDataSpilled()) {
            if (!((LongOptimizedSortableTape)this.mMemorySortableTape).isMemoryIndexBuilt()) {
                Object object = this.mLock;
                synchronized (object) {
                    if (!((LongOptimizedSortableTape)this.mMemorySortableTape).isMemoryIndexBuilt()) {
                        ((LongOptimizedSortableTape)this.mMemorySortableTape).buildMemorySortedIndex(this.mOperationTracker);
                    }
                }
            }
            DefaultFileReader theDataFileReader = new DefaultFileReader(this.mSpillingBufferSize);
            ConventionalLongOptimizedMultiInputIterator aDiskInputIterator = this.createDiskInputIterator(this.mMemoryBlockChainFactory, theDataFileReader, this.mMemoryContext);
            ConventionalLongOptimizedMultiInputIterator aDiskToMemoryDualIterator = this.createDualInputIterator(aDiskInputIterator, this.createMemoryInputIterator(this.mMemoryContext));
            DefaultConventionalSortableArrayIterator<ConventionalLongOptimizedMultiInputIterator, ConventionalLongOptimizedHeapSorter> aTapeIterator = new DefaultConventionalSortableArrayIterator<ConventionalLongOptimizedMultiInputIterator, ConventionalLongOptimizedHeapSorter>(this.createHeapSorter(), aDiskToMemoryDualIterator, this.mDataMemoryBlockChainSupplier, theDataFileReader);
            aTapeIterator.reset();
            return aTapeIterator;
        }
        return (TapeIterator)this.createSkippingTapeIterator();
    }

    @Override
    protected int slotSizeBitPosition() {
        return 4;
    }

    @Override
    protected ConventionalLongOptimizedHeapSorter getHeapSorter() {
        return this.mHeapSorter;
    }

    @Override
    protected SorterLongOptimizedSkippingIterator getDiskIndexIterator() {
        return this.mDiskIndexIterator;
    }

    @Override
    protected SorterLongOptimizedSkippingIterator getMemoryIndexIterator() {
        return this.createMemoryIndexIterator();
    }

    @Override
    protected void sortMemoryBlocksDataBeforeSpilling() {
        try {
            this.mOperationTracker.onStart(OperationType.SORTING);
            ((LongOptimizedSortableTape)this.mMemorySortableTape).sortMemoryBlocksDataTogether(this.mOperationTracker);
        }
        finally {
            this.mOperationTracker.onDone(OperationType.SORTING);
        }
    }

    @Override
    protected SorterLongOptimizedSkippingIterator createDiskIndexIterator() {
        DefaultFileReader theDataFileReader = new DefaultFileReader(this.mSpillingBufferSize);
        DefaultFileReader theTapeFileReader = new DefaultFileReader(this.mSpillingBufferSize);
        ConventionalLongOptimizedMultiInputIterator aDiskInputIterator = this.createDiskInputIterator(this.mMemoryBlockChainFactory, theDataFileReader, this.mMemoryContext);
        return this.createDiskSkippingIterator(this.mMemoryContext, aDiskInputIterator, this.createDiskIndex(theTapeFileReader), theDataFileReader);
    }

    @Override
    protected SorterLongOptimizedSkippingIterator createMemoryIndexIterator() {
        return this.createMemorySkippingIterator(new MemoryIndex(this.createMemoryIndexAccessor(), this.mDataMemoryBlockChainSupplier));
    }

    @Override
    protected ConventionalLongOptimizedMultiInputIterator createByteReaderIterator(ObjectSupplier<ByteReader> theReaderObjectSupplier) {
        return new ByteReaderIterator(this.mMemoryContext, theReaderObjectSupplier);
    }

    @Override
    protected ConventionalOutputCollector<TapeElementInput> getIndexOutputCollector() {
        return this.mIndexOutputCollector;
    }

    @Override
    protected ConventionalLongOptimizedMultiInputIterator getDualInputIterator() {
        return this.mDiskToMemoryDualIterator;
    }

    @Override
    protected ConventionalLongOptimizedMultiInputIterator getDiskInputIterator() {
        return this.mDiskInputIterator;
    }

    @Override
    public void setComparableLongOffset(long theOffset) {
        this.mCompareLongIndex = theOffset;
        this.mBlobInputIterator.setComparableLongOffset(theOffset);
        this.mDiskInputIterator.setComparableLongOffset(theOffset);
        this.mMemoryInputIterator.setComparableLongOffset(theOffset);
    }

    @Override
    protected ConventionalLongOptimizedMultiInputIterator getBlobInputIterator() {
        return this.mBlobInputIterator;
    }

    @Override
    protected ConventionalLongOptimizedMultiInputIterator getBlobToSpilledDualIterator() {
        return this.mBlobToSpilledDualIterator;
    }

    @Override
    protected ConventionalLongOptimizedMultiInputIterator getMemoryInputIterator() {
        return this.mMemoryInputIterator;
    }

    @Override
    public void dispose() {
        AutoCloseable[] autoCloseableArray = new AutoCloseable[10];
        autoCloseableArray[0] = () -> super.dispose();
        autoCloseableArray[1] = this.mHeapSorter::dispose;
        autoCloseableArray[2] = this.mTapeIterator::dispose;
        autoCloseableArray[3] = this.mDiskIndexIterator::dispose;
        autoCloseableArray[4] = this.mBlobInputIterator::dispose;
        autoCloseableArray[5] = this.mDiskInputIterator::dispose;
        autoCloseableArray[6] = this.mIndexOutputCollector::reset;
        autoCloseableArray[7] = this.mMemoryInputIterator::dispose;
        autoCloseableArray[8] = this.mDiskToMemoryDualIterator::dispose;
        autoCloseableArray[9] = this.mBlobToSpilledDualIterator::dispose;
        AutoCloser.close((AutoCloseable[])autoCloseableArray);
    }

    private ConventionalLongOptimizedMultiInputIterator createDiskInputIterator(MemoryBlockChainFactory theFactory, FileReader theDiskInput, MemoryContext theMemoryContext) {
        return new DiskConventionalLongMultiInputIterator(theFactory, theDiskInput, theMemoryContext);
    }

    private ConventionalLongOptimizedMultiInputIterator createDualInputIterator(ConventionalLongOptimizedMultiInputIterator theLeftProvider, ConventionalLongOptimizedMultiInputIterator theRightProvider) {
        return new DualConventionalLongOptimizedMultiInputIterator(theLeftProvider, theRightProvider);
    }

    private SorterLongOptimizedSkippingIterator createMemorySkippingIterator(BinaryIndex theBinaryMemoryIndex) {
        if (FastSkippingTapeIterator.usable(this.mMemoryContext, (LongComparator)this.mComparator, this.mDirection) && ((MemoryBlockAddressArea)this.mTapeArea).get() != null) {
            return new FastSkippingTapeIterator((MemoryBlockChain)this.mDataMemoryBlockChainSupplier.get(), ((MemoryBlockAddressArea)this.mTapeArea).get(), this.mDirection, ((LongOptimizedSortableTape)this.mMemorySortableTape).getMemoryElementsCount());
        }
        return new DefaultSkippingTapeIterator((ConventionalAddressableTapeIterator)this.createMemoryAddressableTapeIterator(), this.createMemoryBinarySearcher(), theBinaryMemoryIndex);
    }

    private ConventionalLongOptimizedMultiInputIterator createMemoryInputIterator(MemoryContext theMemoryContext) {
        return new ConventionalLongOptimizedInputIterator(this.mDataMemoryBlockChainSupplier, (MemoryBlockAddressArea)this.mTapeArea, theMemoryContext);
    }

    private LongOptimizedBinarySearcher createMemoryBinarySearcher() {
        return new LongOptimizedBinarySearcher(this.mDirection, (LongComparator)this.mComparator);
    }

    private ConventionalMemoryAddressableTapeIterator createMemoryAddressableTapeIterator() {
        return new ConventionalMemoryAddressableTapeIterator(this.mMemoryContext, this.mTapeArea, this.mDataMemoryBlockChainSupplier, 16, this.slotSizeBitPosition());
    }

    private DefaultSkippingTapeIterator createDiskSkippingIterator(MemoryContext theMemoryContext, GenericMultiInputIterator theDiskInputIterator, BinaryIndex theBinaryDiskIndex, FileReader theDataFileReader) {
        return new DefaultSkippingTapeIterator((ConventionalAddressableTapeIterator)this.createDiskAddressableTapeIterator(theDiskInputIterator, theBinaryDiskIndex, theDataFileReader), this.createLongDiskBinarySearcher(theMemoryContext, theDataFileReader), theBinaryDiskIndex);
    }

    private LongOptimizedDiskBinarySearcher createLongDiskBinarySearcher(MemoryContext theMemoryContext, FileReader theFileReader) {
        return new LongOptimizedDiskBinarySearcher(theMemoryContext, theFileReader, this.mDataMemoryBlockChainSupplier, this.mMemoryBlockChainFactory, this.mDirection, (LongComparator)this.mComparator);
    }

    private DiskAddressableTapeIterator<TapeElementInput, TapeElementInputFactory<TapeElementInput>> createDiskAddressableTapeIterator(GenericMultiInputIterator theDiskInputIterator, BinaryIndex theBinaryIndex, FileReader theFileReader) {
        return new DiskAddressableTapeIterator<TapeElementInput, TapeElementInputFactory<TapeElementInput>>(theDiskInputIterator, theBinaryIndex, theFileReader);
    }

    private void readComparingLong(ByteReader theDataReader) throws IOException {
        theDataReader.setPosition(this.mCompareLongIndex);
        this.mCachedCompareLong = theDataReader.readLong();
        theDataReader.setPosition(0L);
    }

    private static final class DefaultSkippingTapeIterator
    extends BaseConventionalSkippingTapeIterator<LongSortedArrayBinarySearcher>
    implements SorterLongOptimizedSkippingIterator {
        public DefaultSkippingTapeIterator(ConventionalAddressableTapeIterator theAddressableTapeIterator, LongSortedArrayBinarySearcher theSortedArrayBinarySearcher, BinaryIndex theBinaryIndex) {
            super(theAddressableTapeIterator, theSortedArrayBinarySearcher, theBinaryIndex);
        }

        @Override
        public boolean skipTo(long theValue) {
            this.checkOpen();
            if (this.mCurrentSlotNumber == (long)Utilities.DUMMY_INDEX) {
                return false;
            }
            long aSlotNumber = ((LongSortedArrayBinarySearcher)this.mBinarySearcher).search(this.mCurrentSlotNumber, theValue, this.mBinaryIndex.slotsCount(), false);
            return this.handleSlot(aSlotNumber);
        }

        @Override
        protected long getAddressBySlotNumber(long theSlotNumber) {
            return Utilities.multiplyLongPowerOfTwoAsLong(theSlotNumber, 4);
        }
    }

    private final class LongOptimizedIndexOutputCollector
    extends BaseIndexOutputCollector {
        public LongOptimizedIndexOutputCollector(ConventionalOutputCollector<TapeElementInput> theBaseCollector, FileWriter theIndexWriter, OperationTracker theOperationTracker) {
            super(theBaseCollector, theIndexWriter, theOperationTracker);
        }

        @Override
        public void collectIndex(TapeElementInput theTapeElementInput) throws IOException {
            SpillingSupportedLongOptimizedSortableArrayImpl.this.readComparingLong(theTapeElementInput);
            super.collectIndex(theTapeElementInput);
            this.mIndexWriter.writeLong(SpillingSupportedLongOptimizedSortableArrayImpl.this.mCachedCompareLong);
        }
    }

    private static final class FastSkippingTapeIterator
    extends BaseConventionalTapeIterator<TapeElementInput>
    implements SorterLongOptimizedSkippingIterator {
        private final DefaultMemoryBlockChain mDataMemoryChain;
        private final DefaultMemoryBlockChain mAddressingMemoryChain;
        private final DefaultTapeElementInputFactory mTapeElementInputFactory;
        private final int mBlockSizeMask;
        private final int mBlockSizeBitPosition;
        private final SortOrder mSortOrder;
        private final long mSlotCount;
        private long mCurrentSlotNumber;

        public FastSkippingTapeIterator(MemoryBlockChain theDataMemoryChain, MemoryBlockChain theAddressingChain, SortOrder theOrder, long theSlotCount) {
            Preconditions.checkNotNull((Object)theDataMemoryChain, (Object)"Data memory chain cannot be null");
            Preconditions.checkNotNull((Object)theAddressingChain, (Object)"Addressing memory chain cannot be null");
            this.mDataMemoryChain = (DefaultMemoryBlockChain)theDataMemoryChain;
            this.mAddressingMemoryChain = (DefaultMemoryBlockChain)theAddressingChain;
            this.mTapeElementInputFactory = new DefaultTapeElementInputFactory(this.mDataMemoryChain.getMemoryContext());
            this.mBlockSizeMask = this.mAddressingMemoryChain.getMemoryContext().getBlockSizeMask();
            this.mBlockSizeBitPosition = this.mAddressingMemoryChain.getMemoryContext().getBlockSizeBitPosition();
            this.mSortOrder = theOrder;
            this.mSlotCount = theSlotCount;
        }

        static boolean usable(MemoryContext ctx, LongComparator theComparator, SortOrder theOrder) {
            return ctx.getBlockSize() % 16 == 0 && (theComparator == null || theComparator == LongComparator.DEFAULT);
        }

        @Override
        public boolean hasNext0() {
            return this.mCurrentSlotNumber < this.mSlotCount;
        }

        @Override
        protected TapeElementInput next0() {
            long aAddress = this.addressOfIndex(this.mCurrentSlotNumber++);
            long offset = this.blockOffset(aAddress);
            MemoryBlock block = this.mAddressingMemoryChain.get(this.blockIndex(aAddress));
            int dataBlockIndex = block.getInt(offset);
            int dataBlockOffset = block.getInt(offset + 4L);
            return this.mTapeElementInputFactory.createMemoryInput(this.mDataMemoryChain, dataBlockOffset, dataBlockIndex);
        }

        @Override
        protected void reset0() {
            this.mCurrentSlotNumber = 0L;
        }

        @Override
        protected void close0() {
            this.mCurrentSlotNumber = this.mSlotCount;
            this.mTapeElementInputFactory.dispose();
        }

        @Override
        public void dispose0() {
            this.mCurrentSlotNumber = this.mSlotCount;
            this.mTapeElementInputFactory.dispose();
        }

        @Override
        public boolean skipTo(long theValue) {
            if (this.mCurrentSlotNumber >= this.mSlotCount) {
                return false;
            }
            long slotNumber = SearchUtils.binarySearch(this.mCurrentSlotNumber, this.mSlotCount, false, false, this.mSortOrder, slot -> Long.compare(theValue, this.cmpValue(slot)));
            if (slotNumber == (long)SearchUtils.SEARCH_RESULT_NOT_FOUND) {
                this.mCurrentSlotNumber = this.mSlotCount;
                return false;
            }
            if (slotNumber != (long)SearchUtils.SEARCH_RESULT_ELEMENT_IN_LEFT_RANGE) {
                assert (slotNumber >= 0L && slotNumber < this.mSlotCount) : "out of range - slotNumber = " + slotNumber;
                assert (this.cmpValue(slotNumber) >= theValue) : "expected " + theValue + " but got " + this.cmpValue(slotNumber);
                this.mCurrentSlotNumber = slotNumber;
            }
            return this.hasNext0();
        }

        private long addressOfIndex(long slot) {
            return Utilities.multiplyLongPowerOfTwoAsLong(slot, 4);
        }

        private int blockOffset(long theSourcePosition) {
            return Utilities.maskLongPowerOfTwoAsInt(theSourcePosition, this.mBlockSizeMask);
        }

        private int blockIndex(long theSourcePosition) {
            return Utilities.divideLongPowerOfTwoAsInt(theSourcePosition, this.mBlockSizeBitPosition);
        }

        private long slotValue(long theSlot, long theOffset) {
            long aAddress = this.addressOfIndex(theSlot);
            return this.mAddressingMemoryChain.get(this.blockIndex(aAddress)).getLong((long)this.blockOffset(aAddress) + theOffset);
        }

        private long cmpValue(long theSlot) {
            return this.slotValue(theSlot, 8L);
        }
    }
}

